/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.BizPartnerUtil;
import kd.scm.common.util.ParamUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.MultiBasedataUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.tnd.common.util.TndApplyUtils;
import org.apache.commons.collections.CollectionUtils;

public class TndBidenrollEdit
extends AbstractFormPlugin
implements BeforeF7SelectListener,
UploadListener {
    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long projectId = this.getProjectId();
        this.getModel().setValue("project", (Object)projectId);
        long supplierId = this.getEnrollSupplierId(projectId);
        if (supplierId == 0L) {
            String msg = ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7684\u4f9b\u5e94\u5546\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TndBidenrollEdit_0", (String)"scm-tnd-formplugin", (Object[])new Object[0]);
            this.getView().showConfirm(msg, MessageBoxOptions.OK);
            return;
        }
        this.getModel().setValue("supplier", (Object)supplierId);
        this.getBillInfo();
        if (!this.getEnrollInfo(projectId, supplierId)) {
            this.getSupMsgBySupId(supplierId);
        }
        this.setPackageValueAndVisible();
        this.setEnrollStatus();
    }

    public void afterBindData(EventObject evt) {
        super.afterBindData(evt);
        this.setSelectPackages();
    }

    private void setSelectPackages() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entrypackage");
        List<Long> enrollPackageIds = this.getEnrollpackageIds();
        for (DynamicObject row : rows) {
            if (!enrollPackageIds.contains(row.getLong("packagename.id"))) continue;
            row.set("isselect", (Object)"1");
        }
        if (enrollPackageIds.size() == 0 && rows.size() == 1) {
            ((DynamicObject)rows.get(0)).set("isselect", (Object)"1");
        }
        this.getView().updateView("entrypackage");
    }

    private void setPackageValueAndVisible() {
        String manageType;
        List<Long> packageIds = this.getpackageIds();
        if (packageIds.size() > 0) {
            AbstractFormDataModel model = (AbstractFormDataModel)this.getModel();
            TableValueSetter ts = new TableValueSetter(new String[0]);
            for (int i = 0; i < packageIds.size(); ++i) {
                ts.set("packagename", (Object)packageIds.get(i), i);
            }
            model.batchCreateNewEntryRow("entrypackage", ts);
        }
        if (!"2".equals(manageType = this.getModel().getDataEntity().getString("project.managetype"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"enrollpackage", "tabpackage"});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit supplierF7 = (BasedataEdit)this.getView().getControl("supplier");
        supplierF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit packageF7 = (BasedataEdit)this.getView().getControl("enrollpackage");
        packageF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = evt.getProperty().getName()) {
            case "supplier": {
                ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
                showParameter.setCustomParam("setSupStatusShowAll", (Object)"true");
                List supplierIds = PdsCommonUtils.getSupplierByUserOfBizPartner();
                QFilter supplierFilter = new QFilter("id", "in", (Object)supplierIds);
                ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().setFilter(supplierFilter);
                break;
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        DynamicObject supplier;
        super.propertyChanged(e);
        String fieldkey = e.getProperty().getName();
        if (StringUtils.equals((CharSequence)fieldkey, (CharSequence)"supplier") && (supplier = (DynamicObject)e.getChangeSet()[0].getNewValue()) != null) {
            long supplierId = supplier.getLong("id");
            this.getSupMsgBySupId(supplierId);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs beforeDoOperationEventArgs) {
        super.beforeDoOperation(beforeDoOperationEventArgs);
        if (beforeDoOperationEventArgs.isCancel()) {
            return;
        }
        String operateKey = ((AbstractOperate)beforeDoOperationEventArgs.getSource()).getOperateKey();
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)operateKey)) {
            IFormView view = this.getView();
            IPageCache cache = (IPageCache)view.getService(IPageCache.class);
            String uploadingAttJson = cache.get("UploadingAtt" + view.getPageId());
            if (StringUtils.isNotBlank((CharSequence)uploadingAttJson)) {
                beforeDoOperationEventArgs.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u518d\u8bd5\u3002", (String)"TndBidenrollEdit_1", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
                return;
            }
            this.writeBackPackages();
        }
    }

    private void writeBackPackages() {
        DynamicObjectCollection rows = this.getModel().getEntryEntity("entrypackage");
        DynamicObjectCollection selectRows = new DynamicObjectCollection();
        for (DynamicObject row : rows) {
            if (!row.getBoolean("isselect")) continue;
            selectRows.add((Object)row);
        }
        Object[] basedataIds = MultiBasedataUtils.getMultiBaseDataIds((DynamicObjectCollection)selectRows, (String)"packagename.id");
        this.getModel().setValue("enrollpackage", (Object)basedataIds);
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (StringUtils.equals((CharSequence)"confirm", (CharSequence)operateKey) && evt.getOperationResult().isSuccess()) {
            PdsCommonUtils.refreshParentView((IFormView)this.getView());
        }
    }

    private List<Long> getpackageIds() {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity().getDynamicObject("project"));
        DynamicObjectCollection packageObjs = QueryServiceHelper.query((String)"src_packagef7", (String)"package.id", (QFilter[])new QFilter[]{new QFilter("project.id", "=", (Object)projectId)}, (String)"package.packagename");
        return packageObjs.stream().map(e -> e.getLong("package.id")).collect(Collectors.toList());
    }

    private List<Long> getEnrollpackageIds() {
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity().getDynamicObject("project"));
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity().getDynamicObject("supplier"));
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId).and("supplier", "=", (Object)supplierId);
        DynamicObjectCollection packageObjs = QueryServiceHelper.query((String)"src_enrollsupplier", (String)"package.id", (QFilter[])qFilter.toArray(), (String)"package.packagename");
        if (packageObjs.size() > 0) {
            return packageObjs.stream().map(e -> e.getLong("package.id")).collect(Collectors.toList());
        }
        return new ArrayList<Long>();
    }

    private long getProjectId() {
        Map Params = this.getView().getFormShowParameter().getCustomParams();
        if (Params == null) {
            return 0L;
        }
        return PdsCommonUtils.object2Long(Params.get("project"));
    }

    private void getSupMsgBySupId(long supplierId) {
        IDataModel model = this.getModel();
        HashMap lingkerMap = new HashMap(8);
        Object supplierType = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"suppliertype");
        lingkerMap = supplierType == null || "".equals(supplierType) || "bd_supplier".equals(supplierType.toString()) ? PdsLinkManFacade.getSupplierLinkMan((Object)supplierId) : PdsLinkManFacade.getRegSupplierLinkMan((Object)supplierId);
        model.setValue("linkman", lingkerMap.get("linkman"));
        model.setValue("duty", lingkerMap.get("duty"));
        model.setValue("phone", lingkerMap.get("phone"));
        model.setValue("email", lingkerMap.get("email"));
        model.setValue("address", lingkerMap.get("address"));
        DynamicObject loadSup = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)"bd_supplier");
        model.setValue("societycreditcode", (Object)loadSup.getString("societycreditcode"));
    }

    public void getBillInfo() {
        Map Params = this.getView().getFormShowParameter().getCustomParams();
        this.getModel().setValue("billdate", Params.get("billdate"));
        this.getModel().setValue("stopbiddate", Params.get("stopbiddate"));
        if (Params.get("replydate") == null) {
            this.getModel().setValue("replydate", (Object)TndApplyUtils.getDateByOffsetDay((Date)TimeServiceHelper.now(), (int)30));
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"labelap3", "dateto", "replydate"});
        } else {
            this.getModel().setValue("replydate", Params.get("replydate"));
            Date endDate = this.getModel().getDataEntity().getDate("replydate");
            Date nowDate = TimeServiceHelper.now();
            String dateDiff = TndApplyUtils.getDatePoor((Date)endDate, (Date)nowDate);
            this.getModel().setValue("dateto", (Object)dateDiff);
        }
    }

    public boolean getEnrollInfo(long projectId, long supplierId) {
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId).and("supplier", "=", (Object)supplierId);
        String selectFields = "linkman,duty,phone,email,address,remark,bidattach,societycreditcode";
        DynamicObject enrollObj = BusinessDataServiceHelper.loadSingle((String)"src_enrollsupplier", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (enrollObj != null) {
            this.getModel().setValue("linkman", (Object)enrollObj.getString("linkman"));
            this.getModel().setValue("duty", (Object)enrollObj.getString("duty"));
            this.getModel().setValue("phone", (Object)enrollObj.getString("phone"));
            this.getModel().setValue("address", (Object)enrollObj.getString("address"));
            this.getModel().setValue("email", (Object)enrollObj.getString("email"));
            this.getModel().setValue("remark", (Object)enrollObj.getString("remark"));
            this.getModel().setValue("societycreditcode", (Object)enrollObj.getString("societycreditcode"));
            this.getModel().getDataEntity().set("enrollbidattach", (Object)enrollObj.getDynamicObjectCollection("bidattach"));
            return true;
        }
        return false;
    }

    public void setEnrollStatus() {
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)this.getModel().getDataEntity().getDynamicObject("supplier"));
        ArrayList<Long> supplierIds = new ArrayList<Long>();
        supplierIds.add(supplierId);
        long projectId = this.getProjectId();
        ArrayList<Long> projectIds = new ArrayList<Long>();
        projectIds.add(projectId);
        Set enrollIds = TndApplyUtils.getEnrollIds(supplierIds, projectIds);
        Set inviteIds = TndApplyUtils.getInviteIds(supplierIds, projectIds);
        if (projectId != 0L) {
            String enrollstatus = TndApplyUtils.getEnrollStatus((DynamicObject)BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"tnd_apply"), (Set)enrollIds, (Set)inviteIds, (Date)this.getModel().getDataEntity().getDate("replydate"), (Date)this.getModel().getDataEntity().getDate("stopbiddate"));
            this.getModel().setValue("enrollstatus", (Object)enrollstatus);
        }
    }

    public long getEnrollSupplierId(long projectId) {
        long supplierId = 0L;
        List supplierIds = BizPartnerUtil.getSupplierByUserOfBizPartner((Set)PdsCommonUtils.buildSet((String[])new String[]{"1"}), null);
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId);
        qFilter.and("supplier", "in", (Object)supplierIds);
        DynamicObject enrollObj = QueryServiceHelper.queryOne((String)"src_enrollsupplier", (String)"suppliertype,supplier.id", (QFilter[])new QFilter[]{qFilter});
        if (enrollObj != null) {
            supplierId = enrollObj.getLong("supplier.id");
        } else if (CollectionUtils.isNotEmpty((Collection)supplierIds)) {
            supplierId = (Long)supplierIds.get(0);
        }
        return supplierId;
    }
}

