/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.edit;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.orm.query.QFilter;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.FeatureCheckUtil;
import kd.scm.pds.common.entity.PdsObjectPools;
import kd.scm.pds.common.opencontrol.PdsOpenControlUtils;
import kd.scm.pds.common.question.PdsQuestionFacade;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.TndQuoteUtil;
import kd.scm.pds.common.vie.PdsVieHelper;
import kd.scm.pds.formplugin.edit.PdsBillCompTplEdit;
import kd.scm.tnd.common.util.TndListFilterUtil;
import org.apache.commons.lang3.StringUtils;

public class TndQuoteBillEdit
extends PdsBillCompTplEdit {
    private volatile boolean isExiting = false;

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        if (PdsCommonUtils.isTnd((String)e.getFormShowParameter().getAppId(), (String)RequestContext.get().getUserType())) {
            Map checkResult = FeatureCheckUtil.checkTndFeature();
            if (!((Boolean)checkResult.get("hasLicense")).booleanValue()) {
                e.setCancel(true);
                e.setCancelMessage(String.valueOf(checkResult.get("licenseMsg")));
            } else {
                List projectIds = TndListFilterUtil.getProjectByIsConfirm();
                Long pkId = 0L;
                BillShowParameter showParam = (BillShowParameter)e.getSource();
                Object pkIdStr = showParam.getPkId();
                if (pkIdStr instanceof String) {
                    pkId = Long.parseLong(String.valueOf(pkIdStr));
                } else if (pkIdStr instanceof Long) {
                    pkId = (Long)pkIdStr;
                }
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map checkResult;
        super.afterCreateNewData(e);
        if (PdsCommonUtils.isTnd((String)this.getView().getFormShowParameter().getAppId(), (String)RequestContext.get().getUserType()) && !((Boolean)(checkResult = FeatureCheckUtil.checkTndFeature()).get("hasLicense")).booleanValue()) {
            this.getView().showMessage(String.valueOf(checkResult.get("licenseMsg")));
            return;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        if (((Boolean)this.getModel().getValue("iscompete")).booleanValue()) {
            boolean isFinish = (Boolean)this.getModel().getValue("isfinish");
            boolean isVisiable = true;
            if (!isFinish) {
                isVisiable = false;
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"bar_viehall"});
            }
            this.getView().setVisible(Boolean.valueOf(isVisiable), new String[]{"bar_audit", "bar_unaudit", "bar_save"});
        }
        if (!PdsCommonUtils.isTnd((String)this.getView().getFormShowParameter().getAppId(), (String)RequestContext.get().getUserType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"answerque", "changequery", "bidchange", "encrypt", "bar_viehall", "bar_vieanalyse"});
        }
    }

    public void beforeBindData(EventObject arg0) {
        super.beforeBindData(arg0);
        if (PdsOpenControlUtils.isExistsSupUnProcessTask((DynamicObject)this.getModel().getDataEntity())) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"encrypt"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"encrypt"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        String operateKey;
        super.beforeDoOperation(evt);
        if (evt.isCancel()) {
            return;
        }
        switch (operateKey = ((AbstractOperate)evt.getSource()).getOperateKey()) {
            case "answer": {
                PdsQuestionFacade.openQuestionList((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"tnd_question", (boolean)false);
                break;
            }
            case "analyse": {
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"tnd_vieanalyze", (ShowType)ShowType.MainNewTabPage, null, (QFilter)TndQuoteUtil.getProjectAndSupplierFilter((IFormView)this.getView()), null);
                break;
            }
            case "encrypt": {
                OpenFormUtils.openListPage((IFormView)this.getView(), (String)"tnd_supencryptdetail", (ShowType)ShowType.MainNewTabPage, null, (QFilter)TndQuoteUtil.getProjectAndSupplierFilter((IFormView)this.getView()), null);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        OperationResult operationResult;
        super.afterDoOperation(evt);
        String key = evt.getOperateKey();
        if (Objects.equals(key, "viehall")) {
            if (!evt.getOperationResult().isSuccess()) {
                return;
            }
            Map paraMap = PdsVieHelper.getQuoteBillMap((long)PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue()));
            if (paraMap != null) {
                String projectId = paraMap.get("projectid").toString();
                String vieturns = paraMap.get("vieturns").toString();
                String targetPageId = PdsCommonUtils.object2String((Object)PdsObjectPools.getInstance((String)PdsCommonUtils.getPageIdKey((IFormView)this.getView().getParentView(), (String)"tnd_quotebill", (String)(projectId + '_' + vieturns))), (String)"");
                OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"tnd_vie_online", (ShowType)ShowType.MainNewTabPage, (Map)paraMap, null, (String)targetPageId);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6709\u6548\u7684\u7535\u5b50\u7ade\u4ef7\u9879\u76ee\u3002", (String)"TndQuoteBillEdit_2", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
            }
            return;
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"save") || "audit".equals(key)) {
            Map resultMap = TndQuoteUtil.calcTotalAmount((String)this.getView().getEntityId(), (long)PdsCommonUtils.object2Long((Object)this.getModel().getDataEntity().getPkValue()));
            this.getModel().setValue("sumamount", resultMap.get("sumamount"));
            this.getModel().setValue("sumtaxamount", resultMap.get("sumtaxamount"));
        }
        if ("submit".equals(key) && (operationResult = evt.getOperationResult()).isSuccess()) {
            operationResult.setShowMessage(false);
        }
        if ("audit".equals(key) && BillStatusEnum.AUDIT.getVal().equals(this.getModel().getValue("billstatus"))) {
            operationResult = evt.getOperationResult();
            if (operationResult.isSuccess()) {
                operationResult.setShowMessage(false);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.getModel().getDataEntity().getString("supplier.name"));
            sb.append('\n');
            sb.append(this.getModel().getDataEntity().getString("project.bidname"));
            sb.append('\n');
            sb.append(ResManager.loadKDString((String)"\u62a5\u4ef7\u6210\u529f\u3002", (String)"TndQuoteBillEdit_3", (String)"scm-tnd-formplugin", (Object[])new Object[0]));
            this.getView().showSuccessNotification(sb.toString());
        }
        if (("audit".equals(key) || "unaudit".equals(key)) && evt.getOperationResult() != null && evt.getOperationResult().isSuccess()) {
            PdsCommonUtils.refreshParentView((IFormView)this.getView());
            this.getView().invokeOperation("refresh");
        }
    }

    public void beforeClosed(BeforeClosedEvent evt) {
        String callBackId;
        super.beforeClosed(evt);
        if (!this.isExiting && !evt.isCancel() && BillStatusEnum.SAVE.getVal().equals(this.getModel().getDataEntity().getString("billstatus")) && !"1".equals(callBackId = this.getPageCache().get("pdsCompDataChangeCallBackKey"))) {
            evt.setCancel(true);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u60a8\u5f53\u524d\u5904\u7406\u7684\u9879\u76ee\u672a\u5b8c\u6210\u62a5\u4ef7\uff0c\u8bf7\u8fdb\u884c\u62a5\u4ef7\u6216\u4fdd\u5b58\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u9000\u51fa\uff1f", (String)"TndQuoteBillEdit_4", (String)"scm-tnd-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener("exit"));
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        if (StringUtils.equals((CharSequence)"exit", (CharSequence)evt.getCallBackId()) && evt.getResult().equals((Object)MessageBoxResult.Yes)) {
            this.isExiting = true;
            this.getView().invokeOperation("close");
        }
    }
}

