/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.formplugin.list;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.scm.common.util.BillFormUtil;
import kd.scm.pds.common.enums.EnrollStatusEnums;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.util.OpenFormUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.tnd.common.util.TndApplyUtils;

public class TndApplyList
extends AbstractListPlugin {
    private String enrollStatus = null;

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List qFilters = e.getQFilters();
        Iterator ite = qFilters.iterator();
        while (ite.hasNext()) {
            QFilter filter = (QFilter)ite.next();
            if (!StringUtils.equals((CharSequence)filter.getProperty(), (CharSequence)"enrollstatus")) continue;
            this.enrollStatus = filter.getValue().toString();
            ite.remove();
        }
        QFilter qFilter = ExtFilterUtils.getExtQFilters((String)"pds_extfilter", (String)"tnd_apply", (IFormView)this.getView(), null);
        qFilters.add(qFilter);
        if (this.enrollStatus != null && this.enrollStatus.equals(EnrollStatusEnums.UNENROLL.getValue())) {
            Set unEnrollIds = TndApplyUtils.getUnEnrollIds((QFilter)this.builderQFilter(qFilters));
            QFilter unEnrollFilter = new QFilter("id", "in", (Object)unEnrollIds);
            qFilters.add(unEnrollFilter);
        }
    }

    private QFilter builderQFilter(List<QFilter> qFilters) {
        if (null == qFilters || qFilters.size() == 0) {
            return null;
        }
        QFilter qfilters = qFilters.get(0);
        for (int i = 1; i < qFilters.size(); ++i) {
            qfilters.and(qFilters.get(i));
        }
        return qfilters;
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (opKey.equals("enroll") && result.isSuccess()) {
            DynamicObject billObj = BillFormUtil.getSelectData((IFormView)this.getView(), (String)"tnd_apply");
            if (billObj == null) {
                return;
            }
            HashMap<String, Object> paraMap = new HashMap<String, Object>();
            paraMap.put("project", billObj.getPkValue());
            paraMap.put("stopbiddate", billObj.getDate("stopbiddate"));
            paraMap.put("billdate", billObj.getDate("billdate"));
            paraMap.put("replydate", billObj.getDate("replydate"));
            OpenFormUtils.openDynamicPage((IFormView)this.getView(), (String)"tnd_bidenroll", (ShowType)ShowType.Modal, paraMap, (CloseCallBack)new CloseCallBack((IFormPlugin)this, "tnd_bidenroll"));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId;
        super.closedCallBack(closedCallBackEvent);
        switch (actionId = closedCallBackEvent.getActionId()) {
            case "tnd_bidenroll": {
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int arg0, int arg1) {
            DynamicObjectCollection rows = super.getData(arg0, arg1);
            if (CollectionUtils.isEmpty((Collection)rows)) {
                return rows;
            }
            if (rows.size() > 0 && ((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)"enrollstatus")) {
                List supplierIds = PdsCommonUtils.getSupplierByUserOfBizPartner();
                List projectIds = rows.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
                Set enrollIds = TndApplyUtils.getEnrollIds((List)supplierIds, projectIds);
                Set inviteIds = TndApplyUtils.getInviteIds((List)supplierIds, projectIds);
                for (DynamicObject row2 : rows) {
                    row2.set("enrollstatus", (Object)TndApplyUtils.getEnrollStatus((DynamicObject)row2, (Set)enrollIds, (Set)inviteIds, (Date)row2.getDate("replydate"), (Date)row2.getDate("stopbiddate")));
                }
                if (TndApplyList.this.enrollStatus != null) {
                    List filterRows = rows.stream().filter(row -> row.getString("enrollstatus").equals(TndApplyList.this.enrollStatus)).collect(Collectors.toList());
                    rows = filterRows != null && filterRows.size() > 0 ? new DynamicObjectCollection(((DynamicObject)filterRows.get(0)).getDynamicObjectType(), null, filterRows) : new DynamicObjectCollection(((DynamicObject)rows.get(0)).getDynamicObjectType(), null, new ArrayList());
                }
            }
            this.getQueryResult().setCollection(rows);
            this.getQueryResult().setDataCount(rows.size());
            this.getQueryResult().setBillDataCount(rows.size());
            return rows;
        }
    }
}

