/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.BizLog;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.util.DateUtil;
import kd.scm.pds.common.extfilter.ExtFilterUtils;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.openapi.IQueryList;
import kd.scm.pds.common.extplugin.openapi.QueryContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.tnd.common.util.TndListFilterUtil;
import kd.scm.tnd.service.ITndBillService;

public class TndBillServiceImpl
implements ITndBillService {
    private static final long serialVersionUID = 1L;

    public Map<String, Object> getTenderList() {
        Set<Long> tenderIdSet = this.getDataByQueryPlugin("tnd_tenderbill");
        HashMap<String, Object> resultMap = new HashMap<String, Object>(2);
        resultMap.put("id", tenderIdSet);
        return resultMap;
    }

    public Map<String, Set<Long>> getTodoData() {
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>(2);
        Set<Long> inviteIdSet = this.getDataByQueryPlugin("tnd_inviteletter");
        resultMap.put("inviteBillId", inviteIdSet);
        Set<Long> tenderIdSet = this.getDataByQueryPlugin("tnd_tenderbill");
        resultMap.put("tenderBillId", tenderIdSet);
        Set<Long> quoteIdSet = this.getQuoteData();
        resultMap.put("quoteBillId", quoteIdSet);
        Set<Long> winNoticeIdSet = this.getDataByQueryPlugin("tnd_winnotice");
        resultMap.put("winNoticeBillId", winNoticeIdSet);
        Set<Long> questionIdSet = this.getQuestionData();
        resultMap.put("questionBillId", questionIdSet);
        return resultMap;
    }

    private Set<Long> getDataByQueryPlugin(String entityKey) {
        String extNumber = String.format("IQueryList-%s", entityKey);
        IQueryList queryList = (IQueryList)ExtPluginFactory.getInstance().getExtPluginInstance(extNumber);
        QueryContext context = new QueryContext();
        HashMap<String, Object> queryMap = new HashMap<String, Object>(8);
        this.setQueryMap(entityKey, queryMap);
        context.setFilterByParams(true);
        context.setParamMap(queryMap);
        QFilter filter = queryList.getFilter(context);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)entityKey, (String)"id", (QFilter[])filter.toArray());
        BizLog.log((String)(entityKey + "###getData size:" + cols.size()));
        HashSet<Long> idSet = new HashSet<Long>(cols.size());
        for (DynamicObject col : cols) {
            idSet.add(col.getLong("id"));
        }
        return idSet;
    }

    private void setQueryMap(String entityKey, Map<String, Object> queryMap) {
        ArrayList<String> statusList = new ArrayList<String>(2);
        if ("tnd_inviteletter".equals(entityKey) || "tnd_winnotice".equals(entityKey)) {
            statusList.add("A");
            statusList.add("D");
            queryMap.put("cfmstatus", statusList);
        } else if ("tnd_tenderbill".equals(entityKey)) {
            statusList.add("A");
            statusList.add("B");
            queryMap.put("billstatus", statusList);
        }
        this.addThreeMonthAgo(queryMap);
    }

    private void addThreeMonthAgo(Map<String, Object> queryMap) {
        Date now = TimeServiceHelper.now();
        Date addOneDay = DateUtil.addDays((Date)now, (int)1);
        Date threeMonthAgo = DateUtil.addMonth((Date)now, (int)-3);
        queryMap.put("end_date", DateUtil.date2str((Date)addOneDay, (String)"yyyy-MM-dd") + " 00:00:00");
        queryMap.put("start_date", DateUtil.date2str((Date)threeMonthAgo, (String)"yyyy-MM-dd") + " 00:00:00");
    }

    private Set<Long> getQuoteData() {
        HashSet<Long> idSet = new HashSet<Long>();
        ArrayList<String> statusList = new ArrayList<String>(2);
        statusList.add("A");
        statusList.add("B");
        QFilter filter = new QFilter("billstatus", "in", statusList);
        HashMap<String, Object> queryMap = new HashMap<String, Object>(2);
        this.addThreeMonthAgo(queryMap);
        filter.and(new QFilter("createtime", "<=", (Object)DateUtil.string2date((String)String.valueOf(queryMap.get("end_date")), (String)"yyyy-MM-dd HH:mm:ss")));
        filter.and(new QFilter("createtime", ">=", (Object)DateUtil.string2date((String)String.valueOf(queryMap.get("start_date")), (String)"yyyy-MM-dd HH:mm:ss")));
        List projectIds = TndListFilterUtil.getProjectByIsConfirm();
        QFilter projectFilter = new QFilter("project", "in", (Object)projectIds);
        filter.and(projectFilter);
        String supType = SupplierUtil.getSupType(null);
        String filterSupPro = SupplierUtil.getSupProBySupType((String)supType);
        filter.and(new QFilter(filterSupPro + "." + "id", "in", (Object)PdsCommonUtils.getSupplierByUserOfBizPartner()));
        Set supplierUserIds = SupplierUtil.getSupplierUserIdsByCurrUserId();
        QFilter userFilter = ExtFilterUtils.getMultiBaseDataFilter((String)"supplieruser", (Set)supplierUserIds);
        filter.and(userFilter);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"tnd_quotebill", (String)"id", (QFilter[])filter.toArray());
        BizLog.log((String)("###getQuoteData size:" + cols.size()));
        for (DynamicObject col : cols) {
            idSet.add(col.getLong("id"));
        }
        return idSet;
    }

    private Set<Long> getQuestionData() {
        HashSet<Long> idSet = new HashSet<Long>();
        QFilter filter = new QFilter("replytime", "is null", null);
        HashMap<String, Object> queryMap = new HashMap<String, Object>(2);
        this.addThreeMonthAgo(queryMap);
        filter.and(new QFilter("createtime", "<=", (Object)DateUtil.string2date((String)String.valueOf(queryMap.get("end_date")), (String)"yyyy-MM-dd HH:mm:ss")));
        filter.and(new QFilter("createtime", ">=", (Object)DateUtil.string2date((String)String.valueOf(queryMap.get("start_date")), (String)"yyyy-MM-dd HH:mm:ss")));
        filter.and("publishtype", "=", (Object)"4");
        QFilter extFilter = ExtFilterUtils.getExtQFilters((String)"pds_extfilter", (String)"tnd_question", null, null);
        filter.and(extFilter);
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"tnd_question", (String)"id", (QFilter[])filter.toArray());
        BizLog.log((String)("###getQuestionData size:" + cols.size()));
        for (DynamicObject col : cols) {
            idSet.add(col.getLong("id"));
        }
        return idSet;
    }

    private Set<Long> getAptitudeAuditData() {
        HashSet<Long> idSet = new HashSet<Long>(16);
        QFilter filter = new QFilter("isaptitudereply", "=", (Object)true);
        String supType = SupplierUtil.getSupType(null);
        String filterSupPro = SupplierUtil.getSupProBySupType((String)supType);
        filter.and(new QFilter(filterSupPro + "." + "id", "in", (Object)PdsCommonUtils.getSupplierByUserOfBizPartner()));
        Set supplierUserIds = SupplierUtil.getSupplierUserIdsByCurrUserId();
        QFilter userFilter = ExtFilterUtils.getMultiBaseDataFilter((String)"supplieruser", (Set)supplierUserIds);
        filter.and(userFilter);
        filter.and("cfmstatus", "=", (Object)"A");
        HashMap<String, Object> queryMap = new HashMap<String, Object>(2);
        this.addThreeMonthAgo(queryMap);
        filter.and(new QFilter("createtime", "<=", (Object)DateUtil.string2date((String)String.valueOf(queryMap.get("end_date")), (String)"yyyy-MM-dd HH:mm:ss")));
        filter.and(new QFilter("createtime", ">=", (Object)DateUtil.string2date((String)String.valueOf(queryMap.get("start_date")), (String)"yyyy-MM-dd HH:mm:ss")));
        QFilter qFilter = ExtFilterUtils.getExtQFilters((String)"pds_extfilter", (String)"tnd_aptitude", null, null);
        filter.and(qFilter);
        QFilter orgFilter = this.getOrgFilter("tnd_aptitude");
        if (null != orgFilter) {
            filter.and(orgFilter);
        }
        DynamicObjectCollection cols = QueryServiceHelper.query((String)"tnd_aptitude", (String)"id", (QFilter[])filter.toArray());
        BizLog.log((String)("###getQuestionData size:" + cols.size()));
        for (DynamicObject col : cols) {
            idSet.add(col.getLong("id"));
        }
        return idSet;
    }

    private QFilter getOrgFilter(String entityKey) {
        QFilter orgFilter = null;
        HasPermOrgResult orgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), null, (String)entityKey, (String)"47150e89000000ac");
        if (!orgResult.hasAllOrgPerm()) {
            orgFilter = new QFilter("org", "in", (Object)orgResult.getHasPermOrgs());
        }
        return orgFilter;
    }

    public Map<String, Set<Long>> getTodoAptitudeData() {
        HashMap<String, Set<Long>> resultMap = new HashMap<String, Set<Long>>(1);
        Set<Long> aptitudeIdSet = this.getAptitudeAuditData();
        resultMap.put("aptitudeBillId", aptitudeIdSet);
        return resultMap;
    }
}

