/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.aptitude;

import java.util.HashSet;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.enums.BillStatusEnum;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.extplugin.ExtPluginContext;
import kd.scm.pds.common.extplugin.IExtPluginHandler;
import kd.scm.pds.common.util.PdsCommonUtils;

public class TndAptutideReplyHandler
implements IExtPluginHandler {
    private static final long serialVersionUID = 1L;

    public Set<String> getOnPreparePropertys() {
        HashSet<String> propertys = new HashSet<String>(8);
        propertys.add("project");
        propertys.add("supplier");
        propertys.add("supplierip");
        propertys.add("cfmstatus");
        propertys.add("cfmstatus_pur");
        propertys.add("cfmstatus_sup");
        propertys.add("auditdate");
        propertys.add("auditor");
        return propertys;
    }

    public void process(ExtPluginContext context) {
        if (this.updateEntryStatus(context)) {
            this.updateBillStatus(context);
            this.updateReplyStatus(context);
        }
    }

    public void updateBillStatus(ExtPluginContext context) {
        boolean isAudit = "audit".equals(context.getOperationKey());
        if (isAudit) {
            context.getBillObj().set("supplierip", (Object)PdsCommonUtils.getLoginIp());
            context.getBillObj().set("auditdate", (Object)TimeServiceHelper.now());
            context.getBillObj().set("auditor", (Object)RequestContext.get().getCurrUserId());
            context.getBillObj().set("cfmstatus", (Object)BillStatusEnum.AUDIT.getVal());
            context.getBillObj().set("cfmstatus_pur", (Object)BillStatusEnum.AUDIT.getVal());
            context.getBillObj().set("cfmstatus_sup", (Object)BillStatusEnum.AUDIT.getVal());
        } else {
            context.getBillObj().set("supplierip", null);
            context.getBillObj().set("auditdate", null);
            context.getBillObj().set("auditor", null);
            context.getBillObj().set("cfmstatus", (Object)BillStatusEnum.SAVE.getVal());
            context.getBillObj().set("cfmstatus_pur", (Object)BillStatusEnum.SAVE.getVal());
            context.getBillObj().set("cfmstatus_sup", (Object)BillStatusEnum.SAVE.getVal());
        }
    }

    public void updateReplyStatus(ExtPluginContext context) {
        boolean isAudit = "audit".equals(context.getOperationKey());
        this.updateReplyStatus(context, "src_enrollsupplier", isAudit);
        this.updateReplyStatus(context, "src_supplierinvite", isAudit);
        this.updateReplyStatus(context, "src_bidopensupplier", isAudit);
    }

    public void updateReplyStatus(ExtPluginContext context, String entityName, boolean isAudit) {
        QFilter qfilter = this.getQFilter(context);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)entityName, (String)"isaptitudereply", (QFilter[])qfilter.toArray());
        if (null != rows && rows.length > 0) {
            for (DynamicObject row : rows) {
                if (isAudit) {
                    row.set("isaptitudereply", (Object)"1");
                    continue;
                }
                row.set("isaptitudereply", (Object)"0");
            }
            PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
        }
    }

    public QFilter getQFilter(ExtPluginContext context) {
        DynamicObject projectObj = context.getBillObj().getDynamicObject("project");
        String manageType = projectObj.getString("managetype");
        QFilter qfilter = new QFilter("billid", "=", (Object)SrmCommonUtil.getPkValue((DynamicObject)projectObj));
        qfilter.and("supplier", "=", (Object)context.getBillObj().getLong("supplier.id"));
        if ("2".equals(manageType)) {
            qfilter.and("package", "=", (Object)context.getBillObj().getLong("package.id"));
        }
        return qfilter;
    }

    public boolean updateEntryStatus(ExtPluginContext context) {
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)context.getBillObj().getLong("id"), (String)"src_aptitudetask");
        DynamicObjectCollection rows = billObj.getDynamicObjectCollection("entryentity");
        boolean isSupplier = "3".equals(RequestContext.get().getUserType());
        String newEntryStatus = "audit".equals(context.getOperationKey()) ? (isSupplier ? BillStatusEnum.SUBMIT.getVal() : BillStatusEnum.AUDIT.getVal()) : BillStatusEnum.SAVE.getVal();
        boolean isChanged = false;
        for (DynamicObject row : rows) {
            String itemType = PdsCommonUtils.object2String((Object)row.get("index.itemtype"), (String)"1");
            if (isSupplier && !"1".equals(itemType) && !"2".equals(itemType) || !isSupplier && !"1".equals(itemType) && !"3".equals(itemType) && !"4".equals(itemType)) continue;
            String currEntryStatus = row.getString("entrystatus");
            if (!BillStatusEnum.SAVE.getVal().equals(currEntryStatus) && (isSupplier && BillStatusEnum.AUDIT.getVal().equals(currEntryStatus) || !isSupplier && BillStatusEnum.SUBMIT.getVal().equals(currEntryStatus)) || newEntryStatus.equals(currEntryStatus)) continue;
            row.set("entrystatus", (Object)newEntryStatus);
            isChanged = true;
        }
        if (isChanged) {
            PdsCommonUtils.saveDynamicObjects((DynamicObject)billObj);
        }
        if ("audit".equals(context.getOperationKey())) {
            return (long)rows.size() == rows.stream().filter(e -> e.getString("entrystatus").equals(BillStatusEnum.SUBMIT.getVal()) || e.getString("entrystatus").equals(BillStatusEnum.AUDIT.getVal())).count();
        }
        return (long)rows.size() == rows.stream().filter(e -> e.getString("entrystatus").equals(BillStatusEnum.SAVE.getVal())).count();
    }
}

