/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.audithandle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.common.util.DynamicObjectUtil;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.tndaudit.TndBillAuditContext;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.pds.common.util.TemplateUtil;

public class TndBillAuditUtils {
    public static int calcBidCount(TndBillAuditContext context, DynamicObject billObj) {
        int bidCount = billObj.getInt("bidcount");
        bidCount = context.isAudit() ? ++bidCount : --bidCount;
        if (bidCount < 0) {
            bidCount = 0;
        }
        return bidCount;
    }

    public static void getQuoteBillInfo(TndBillAuditContext context) {
        DynamicObject billObj = context.getBillObj();
        HashSet<Long> entryIds = new HashSet<Long>(16);
        HashSet<Long> srcEntryIds = new HashSet<Long>(16);
        HashSet<Long> purlistIds = new HashSet<Long>(16);
        HashSet<Long> packageIds = new HashSet<Long>(8);
        DynamicObject template = billObj.getDynamicObject("template");
        if (null == template) {
            return;
        }
        List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)billObj);
        Set purlistCompKeyList = TemplateUtil.getPurListCompKeySet();
        DynamicObject compObj = null;
        for (String compKey : compKeyList) {
            if (!purlistCompKeyList.contains(compKey)) continue;
            QFilter filter = TemplateUtil.getComponentQfilter((Object)String.valueOf(billObj.getPkValue()), (String)context.getEntityName(), (String)compKey);
            StringBuilder selectFields = new StringBuilder();
            selectFields.append("id");
            selectFields.append(',');
            selectFields.append("entryentity");
            selectFields.append('.');
            selectFields.append("purlist");
            selectFields.append(',');
            selectFields.append("entryentity");
            selectFields.append('.');
            selectFields.append("package");
            selectFields.append(',');
            selectFields.append("entryentity");
            selectFields.append('.');
            selectFields.append("srcentryid");
            compObj = BusinessDataServiceHelper.loadSingle((String)compKey, (String)selectFields.toString(), (QFilter[])new QFilter[]{filter});
            if (null == compObj) continue;
            context.getCompKey_compObjMap().put(compKey, compObj);
            DynamicObjectCollection rows = null;
            try {
                rows = compObj.getDynamicObjectCollection("entryentity");
            }
            catch (Exception e) {
                continue;
            }
            for (DynamicObject row : rows) {
                entryIds.add(row.getLong("id"));
                if (!StringUtils.isBlank((CharSequence)row.getString("srcentryid"))) {
                    try {
                        long srcEntryId = Long.parseLong(row.getString("srcentryid"));
                        srcEntryIds.add(srcEntryId);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                purlistIds.add(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("purlist")));
                packageIds.add(SrmCommonUtil.getPkValue((DynamicObject)row.getDynamicObject("package")));
            }
        }
        context.setEntryIds(entryIds);
        context.setSrcEntryIds(srcEntryIds);
        context.setPurlistIds(purlistIds);
        context.setPackageIds(packageIds);
    }

    public static void getNegId_QuoteMap(TndBillAuditContext context) {
        QFilter qfilter = new QFilter("id", "in", (Object)context.getEntryIds());
        qfilter.and("srcentryid", "is not null", (Object)"");
        String selectFields = DynamicObjectUtil.getSelectfields((String)"src_purlistf7", (boolean)false);
        DynamicObject[] rows = BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilter.toArray());
        if (rows.length == 0) {
            return;
        }
        Map<Long, DynamicObject> negId_QuoteMap = Arrays.asList(rows).stream().filter(e -> !StringUtils.isBlank((CharSequence)e.getString("srcentryid"))).collect(Collectors.groupingBy(e -> Long.parseLong(e.getString("srcentryid")), Collectors.collectingAndThen(Collectors.toList(), value -> (DynamicObject)value.get(0))));
        context.setNegId_QuoteMap(negId_QuoteMap);
    }

    public static List<String> getWriteBackFieldList(TndBillAuditContext context, String compKey, String compEntryKey) {
        List writebackFieldList = (ArrayList)context.getCompKey_compConfigMap().get(compKey);
        if (null == writebackFieldList) {
            writebackFieldList = PdsCompConfigUtil.getPros((DynamicObject)context.getBillObj(), (String)compKey, (String)"entryentity", (String)"iswriteback", (boolean)true);
            if (null == writebackFieldList) {
                writebackFieldList = new ArrayList();
            } else {
                TndBillAuditUtils.addSpecialWriteBackField(writebackFieldList);
            }
            context.getCompKey_compConfigMap().put(compKey, writebackFieldList);
        }
        return writebackFieldList;
    }

    private static void addSpecialWriteBackField(List<String> writebackFieldList) {
        if (!writebackFieldList.contains("quotedate")) {
            writebackFieldList.add("quotedate");
        }
        if (writebackFieldList.contains("taxitem")) {
            writebackFieldList.add("taxrate");
        }
    }

    public static void writeBackNegotiateData(TndBillAuditContext context, DynamicObject row, List<String> writebackFieldList) {
        long key = row.getLong("id");
        DynamicObject quoteRow = (DynamicObject)context.getNegId_QuoteMap().get(key);
        if (quoteRow == null) {
            return;
        }
        for (int i = 0; i < writebackFieldList.size(); ++i) {
            if ("purlistentry_supfj".equals(writebackFieldList.get(i))) continue;
            try {
                if (context.isAudit()) {
                    row.set(writebackFieldList.get(i), quoteRow.get(writebackFieldList.get(i)));
                    continue;
                }
                row.set(writebackFieldList.get(i), null);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static DynamicObject[] getNegEntryRows(TndBillAuditContext context, List<String> writebackFieldList) {
        QFilter qfilter = new QFilter("id", "in", (Object)context.getSrcEntryIds());
        String selectFields = TndBillAuditUtils.getSelectFields(writebackFieldList);
        return BusinessDataServiceHelper.load((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilter.toArray());
    }

    private static String getSelectFields(List<String> writebackFieldList) {
        HashSet<String> fieldsSet = new HashSet<String>(writebackFieldList.size() + 4);
        fieldsSet.addAll(writebackFieldList);
        fieldsSet.add("entrystatus");
        fieldsSet.add("isdiscarded");
        fieldsSet.add("quotedate");
        return String.join((CharSequence)",", fieldsSet);
    }
}

