/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.audithandle;

import kd.bos.dataentity.entity.DynamicObject;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.tndaudit.ITndBillAuditHandler;
import kd.scm.pds.common.tndaudit.TndBillAuditContext;
import kd.scm.tnd.opplugin.audithandle.TndBillAuditUtils;

public class TndBillContextInit
implements ITndBillAuditHandler {
    private static final long serialVersionUID = 1L;

    public void process(TndBillAuditContext context) {
        this.initContext(context);
    }

    protected void initContext(TndBillAuditContext context) {
        DynamicObject billObj = context.getBillObj();
        context.setEntityName(billObj.getDataEntityType().getName());
        context.setAudit(context.getOperationKey().equals("audit"));
        context.setBillId(SrmCommonUtil.getPkValue((DynamicObject)billObj));
        context.setProjectId(SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("project")));
        context.setSuppliertype(billObj.getString("suppliertype"));
        context.setSupplierId(SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("supplier")));
        if (context.getEntityName().equals("tnd_quotebill")) {
            context.setOpenType(billObj.getString("opentype"));
        } else {
            context.setOpenType(billObj.getString("project.opentype"));
        }
        context.setMultipackage(billObj.getBoolean("project.ismultipackage"));
        context.setTurns(billObj.getString("turns"));
        TndBillAuditUtils.getQuoteBillInfo(context);
        if (context.getOpenType().equals("9")) {
            TndBillAuditUtils.getNegId_QuoteMap(context);
        }
    }
}

