/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.audithandle;

import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.tndaudit.ITndBillAuditHandler;
import kd.scm.pds.common.tndaudit.TndBillAuditContext;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.tnd.opplugin.audithandle.TndBillAuditUtils;

public class TndBillNegOpenHandler
implements ITndBillAuditHandler {
    private static final long serialVersionUID = 1L;

    public void process(TndBillAuditContext context) {
        if (!context.getOpenType().equals("9")) {
            return;
        }
        if (context.getEntityName().equals("tnd_tenderbill") || context.getTurns().equals(QuoteTurnsEnums.NEGOTIATE00.getValue())) {
            return;
        }
        this.updateNegBillStatus(context);
        Map compKey_compObjMap = context.getCompKey_compObjMap();
        for (String compKey : compKey_compObjMap.keySet()) {
            context.setCompKey(compKey);
            this.updateNegEntryStatus(context);
        }
    }

    private void updateNegBillStatus(TndBillAuditContext context) {
        QFilter qfilter = new QFilter("project", "=", (Object)context.getProjectId());
        qfilter.and("turns", "=", (Object)context.getTurns());
        DynamicObject negBillObj = BusinessDataServiceHelper.loadSingle((String)"src_negotiatebill", (String)"id,turns,isquotebidopen,bidcount", (QFilter[])qfilter.toArray());
        if (negBillObj == null) {
            return;
        }
        boolean isquotebidopen = negBillObj.getBoolean("isquotebidopen");
        int bidCount = TndBillAuditUtils.calcBidCount(context, negBillObj);
        if (bidCount > 0 && !isquotebidopen) {
            negBillObj.set("isquotebidopen", (Object)"1");
        } else if (bidCount == 0 && isquotebidopen) {
            negBillObj.set("isquotebidopen", (Object)"0");
        }
        negBillObj.set("bidcount", (Object)bidCount);
        PdsCommonUtils.saveDynamicObjects((DynamicObject)negBillObj);
    }

    protected void updateNegEntryStatus(TndBillAuditContext context) {
        DynamicObject[] rows;
        List<String> writebackFieldList = TndBillAuditUtils.getWriteBackFieldList(context, context.getCompKey(), "entryentity");
        for (DynamicObject row : rows = TndBillAuditUtils.getNegEntryRows(context, writebackFieldList)) {
            if (!row.getBoolean("isdiscarded")) {
                TndBillAuditUtils.writeBackNegotiateData(context, row, writebackFieldList);
                if (context.isAudit()) {
                    row.set("entrystatus", (Object)ProjectStatusEnums.QUOTED.getValue());
                    row.set("quotedate", (Object)TimeServiceHelper.now());
                    continue;
                }
                row.set("entrystatus", (Object)ProjectStatusEnums.TOQUOTE.getValue());
                row.set("quotedate", null);
                continue;
            }
            row.set("entrystatus", (Object)ProjectStatusEnums.DISCARDED.getValue());
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])rows);
    }
}

