/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.audithandle;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.BidOpenStatusEnums;
import kd.scm.pds.common.enums.QuoteTurnsEnums;
import kd.scm.pds.common.tndaudit.ITndBillAuditHandler;
import kd.scm.pds.common.tndaudit.TndBillAuditContext;
import kd.scm.pds.common.util.ExtParameterUtils;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.tnd.opplugin.audithandle.TndBillAuditUtils;

public class TndBillPackageOpenHandler
implements ITndBillAuditHandler {
    private static final long serialVersionUID = 1L;

    public void process(TndBillAuditContext context) {
        if (!context.getOpenType().equals("9")) {
            return;
        }
        this.setProjectOpenStatus(context);
        if (context.getEntityName().equals("tnd_quotebill") && !context.getTurns().equals(QuoteTurnsEnums.NEGOTIATE00.getValue())) {
            return;
        }
        if (context.getPackageOpenType() > 0) {
            this.setPackageOpenStatus(context, "src_bidopenpackage");
            long sourceFlowId = SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj().getDynamicObject("project").getDynamicObject("srctype"));
            boolean isOpenBySupplier = ExtParameterUtils.convertToBoolen((Object)ExtParameterUtils.getExtParameterValueById((String)"pds_flowconfig", (long)sourceFlowId, (String)"isopenbysupplier", (Object)false, (long)SrmCommonUtil.getPkValue((DynamicObject)context.getBillObj().getDynamicObject("project"))));
            if (isOpenBySupplier) {
                this.setPackageOpenStatus(context, "src_supplieropen");
            }
        }
    }

    protected void setProjectOpenStatus(TndBillAuditContext context) {
        DynamicObject openBillObj = BusinessDataServiceHelper.loadSingle((Object)context.getProjectId(), (String)"src_bidopen_open");
        if (null == openBillObj) {
            return;
        }
        int bidCount = TndBillAuditUtils.calcBidCount(context, openBillObj);
        String openStatus = openBillObj.getString("openstatus");
        if (bidCount > 0 && !openStatus.equals(BidOpenStatusEnums.OPEN.getValue())) {
            openBillObj.set("openstatus", (Object)BidOpenStatusEnums.OPEN.getValue());
            context.setPackageOpenType(1);
        } else if (bidCount == 0 && !openStatus.equals(BidOpenStatusEnums.NOOPEN.getValue())) {
            openBillObj.set("openstatus", (Object)BidOpenStatusEnums.NOOPEN.getValue());
            context.setPackageOpenType(2);
        }
        openBillObj.set("bidcount", (Object)bidCount);
        PdsCommonUtils.saveDynamicObjects((DynamicObject)openBillObj);
    }

    protected void setPackageOpenStatus(TndBillAuditContext context, String entityName) {
        DynamicObject[] packageObjs;
        String selectFields = "istecopen,tecopendate,tecopenuser,isbizopen,bizopendate,bizopenuser,isaptopen,aptopendate,aptopenuser";
        QFilter qfilter = new QFilter("billid", "=", (Object)context.getProjectId());
        for (DynamicObject packageObj : packageObjs = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])qfilter.toArray())) {
            if (context.getPackageOpenType() == 1) {
                packageObj.set("istecopen", (Object)"1");
                packageObj.set("tecopendate", (Object)TimeServiceHelper.now());
                packageObj.set("tecopenuser", null);
                packageObj.set("isbizopen", (Object)"1");
                packageObj.set("bizopendate", (Object)TimeServiceHelper.now());
                packageObj.set("bizopenuser", null);
                packageObj.set("isaptopen", (Object)"1");
                packageObj.set("aptopendate", (Object)TimeServiceHelper.now());
                packageObj.set("aptopenuser", null);
                continue;
            }
            packageObj.set("istecopen", (Object)"0");
            packageObj.set("tecopendate", null);
            packageObj.set("tecopenuser", null);
            packageObj.set("isbizopen", (Object)"0");
            packageObj.set("bizopendate", null);
            packageObj.set("bizopenuser", null);
            packageObj.set("isaptopen", (Object)"0");
            packageObj.set("aptopendate", null);
            packageObj.set("aptopenuser", null);
        }
        PdsCommonUtils.saveDynamicObjects((DynamicObject[])packageObjs);
    }
}

