/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.validator;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.tnd.common.util.TndApplyUtils;
import org.apache.commons.collections.CollectionUtils;

public class TndAptitudeExpireValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;
    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public void validate(SrcValidatorData arg0) {
        DynamicObject billObj = arg0.getBillObj();
        long supplierId = SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("supplier"));
        if (supplierId == 0L) {
            return;
        }
        List aptitudes = TndApplyUtils.isSupplierAptitude(Collections.singletonList(supplierId));
        if (CollectionUtils.isEmpty((Collection)aptitudes)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject aptitude : aptitudes) {
            sb.append(aptitude.getString("entry_aptitude.aptitudename")).append("\uff1a").append(this.sdf.format(aptitude.getDate("entry_aptitude.dateto"))).append(";\n");
        }
        arg0.setSucced(false);
        arg0.setMessage(String.format(ResManager.loadKDString((String)"\u60a8\u7684\u8fd9\u4e9b\u8d44\u8d28\u5df2\u7ecf\u8fc7\u671f\uff0c\u4e0d\u5141\u8bb8\u6295\u6807\u62a5\u540d\uff1a%1$s", (String)"TndAptitudeExpireValidator_0", (String)"scm-tnd-opplugin", (Object[])new Object[0]), sb.toString()));
    }
}

