/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.validator;

import java.text.MessageFormat;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.ProjectStatusEnums;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class TndBidDocValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData srcValidatorData) {
        DynamicObject billObj = srcValidatorData.getBillObj();
        if (!billObj.getBoolean("isneedbiddoc")) {
            return;
        }
        long billId = SrmCommonUtil.getPkValue((DynamicObject)billObj);
        DynamicObject supBidDocObj = TemplateUtil.getComponentData((String)String.valueOf(billId), (String)"src_biddoc_tnd");
        if (null == supBidDocObj) {
            return;
        }
        DynamicObjectCollection docRows = supBidDocObj.getDynamicObjectCollection("entryentity");
        if (null == docRows || docRows.size() == 0) {
            return;
        }
        int i = 1;
        StringBuilder sb = new StringBuilder();
        for (DynamicObject docRow : docRows) {
            String entryStatus = docRow.getString("entrystatus");
            if (ProjectStatusEnums.INVALID.getValue().equals(entryStatus)) continue;
            DynamicObjectCollection bidattachs = docRow.getDynamicObjectCollection("bidattach");
            if (bidattachs.size() == 0) {
                sb.append(MessageFormat.format(ResManager.loadKDString((String)ResManager.loadKDString((String)"\u4f9b\u5e94\u5546\u6295\u6807\u6587\u4ef6\u7b2c{0}\u884c,\u9644\u4ef6\u672a\u4e0a\u4f20;", (String)"TndBidDocValidator_1", (String)"scm-tnd-opplugin", (Object[])new Object[0]), (String)"TndBidDocValidator_1", (String)"scm-tnd-opplugin", (Object[])new Object[0]), i));
            }
            ++i;
        }
        if (sb.length() > 0) {
            srcValidatorData.setSucced(false);
            srcValidatorData.setMessage(sb.toString());
        }
    }
}

