/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.validator;

import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class TndEnrollAptOpenValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData validatorData) {
        validatorData.setSucced(true);
        String operation = validatorData.getOperation();
        DynamicObject projectObj = null;
        projectObj = "tnd_apply".equals(validatorData.getBillObj().getDataEntityType().getName()) ? validatorData.getBillObj() : validatorData.getBillObj().getDynamicObject("project");
        if ((Objects.equals(operation, "confirm") || Objects.equals(operation, "unenroll")) && this.isOpenApt(projectObj, "isaptopen")) {
            validatorData.setSucced(false);
            validatorData.setMessage(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u5f00\u8d44\u5ba1\u6807\uff0c\u4e0d\u5141\u8bb8\u62a5\u540d\u3002", (String)"TndEnrollAptOpenValidator_0", (String)"scm-tnd-opplugin", (Object[])new Object[0]));
        }
    }

    public boolean isOpenApt(DynamicObject projectObj, String openType) {
        long pkValue = PdsCommonUtils.object2Long((Object)projectObj.getPkValue());
        QFilter aptFilter = new QFilter("billid", "=", (Object)pkValue);
        aptFilter.and(openType, "=", (Object)true);
        if (PdsCommonUtils.isOpenBySupplier((DynamicObject)projectObj)) {
            this.addSupplierOpenFilter(aptFilter);
            return QueryServiceHelper.exists((String)"src_supplieropen", (QFilter[])aptFilter.toArray());
        }
        return QueryServiceHelper.exists((String)"src_bidopenpackage", (QFilter[])aptFilter.toArray());
    }

    public void addSupplierOpenFilter(QFilter qfilters) {
        qfilters.and("istender", "=", (Object)"1");
        qfilters.and("isdiscard", "=", (Object)"0");
        qfilters.and("isaptitude", "!=", (Object)"2");
    }
}

