/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.validator;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class TndPriceClarifyValidator
implements ISrcValidator {
    private static final long serialVersionUID = 8460831337812415389L;

    public void validate(SrcValidatorData srcValidatorData) {
        if (!srcValidatorData.getBillObj().getBoolean("isclarify")) {
            return;
        }
        DynamicObjectCollection rows = srcValidatorData.getBillObj().getDynamicObjectCollection("entryentity");
        if (null == rows || rows.size() == 0) {
            return;
        }
        Map<String, String> fieldNameMap = this.getMustInputPriceOrAmountField(srcValidatorData);
        boolean isZero = rows.stream().anyMatch(e -> e.getBoolean("isnew") && !e.getBoolean("isdiscarded_new") && e.getBigDecimal((String)fieldNameMap.get("fieldid")).compareTo(BigDecimal.ZERO) <= 0);
        if (isZero) {
            srcValidatorData.setMessage(String.format(ResManager.loadKDString((String)"\u9700\u8981\u6f84\u6e05\uff0c\u4e14\u975e\u53bb\u6807\u7684\u65f6\uff0c%1$s \u4e0d\u5141\u8bb8\u4e3a0", (String)"TndPriceClarifyValidator_0", (String)"scm-tnd-opplugin", (Object[])new Object[0]), fieldNameMap.get("fieldname")));
            srcValidatorData.setSucced(false);
            return;
        }
    }

    private Map<String, String> getMustInputPriceOrAmountField(SrcValidatorData srcValidatorData) {
        String taxType = srcValidatorData.getBillObj().getString("project.taxtype");
        String decisionTpe = srcValidatorData.getBillObj().getString("project.decisiontype");
        return PdsCommonUtils.getMustInputPriceOrAmountField((String)taxType, (String)decisionTpe, (String)"", (String)"_new");
    }
}

