/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class TndQuoteBillPurlistValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData validatorData) {
        validatorData.setSucced(true);
        DynamicObject billObj = validatorData.getBillObj();
        HashMap<String, DynamicObject> emptyCompMap = new HashMap<String, DynamicObject>(4);
        List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)billObj);
        for (String compKey : compKeyList) {
            DynamicObject compDataObj = TemplateUtil.getCompData((DynamicObject)billObj, (String)compKey);
            if (!this.isEmpty(compDataObj, compKey)) continue;
            if (emptyCompMap.size() == 0) {
                validatorData.setSucced(false);
            }
            emptyCompMap.put(compKey, compDataObj);
        }
        if (emptyCompMap.size() > 0) {
            this.reCreateCompData(billObj, emptyCompMap);
        }
    }

    public void reCreateCompData(DynamicObject billObj, Map<String, DynamicObject> emptyCompMap) {
        String turns = billObj.getString("turns");
        if ("1".equals(turns) || "".equals(turns)) {
            DynamicObject project = billObj.getDynamicObject("project");
            String manageType = project.getString("managetype");
            DynamicObject purlistObj = this.getPurlistObj(project.getLong("id"));
            boolean isItemSupplier = false;
            Map<String, DynamicObject> compKey_objMap = this.getBillCompGroupData(purlistObj);
            isItemSupplier = "1".equals(manageType) || "2".equals(manageType) ? purlistObj.getBoolean("isitemsupplier") : true;
            Map<String, Object> pkgOrPurListIdMap = null;
            pkgOrPurListIdMap = isItemSupplier ? this.getPurlistIdMapByItemSup(billObj) : this.getPackageIdMapByInviteSup(billObj);
            for (Map.Entry<String, DynamicObject> emptyCompMapEntry : emptyCompMap.entrySet()) {
                this.createCompData(billObj, emptyCompMapEntry.getValue(), pkgOrPurListIdMap, compKey_objMap, isItemSupplier);
            }
        } else {
            DynamicObject negObj = this.getNegBillObj(billObj);
            if (null == negObj) {
                return;
            }
            Map<String, DynamicObject> compKey_objMap = this.getBillCompGroupData(negObj);
            for (Map.Entry<String, DynamicObject> emptyCompMapEntry : emptyCompMap.entrySet()) {
                this.createCompData(billObj, emptyCompMapEntry.getValue(), compKey_objMap);
            }
        }
    }

    public Map<String, Object> getPackageIdMapByInviteSup(DynamicObject billObj) {
        HashMap<String, Object> packageIdMap = new HashMap<String, Object>(8);
        DynamicObject project = billObj.getDynamicObject("project");
        DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)project, (String)"src_supplier_invite");
        if (null == compObj) {
            return packageIdMap;
        }
        DynamicObject quoSupplier = billObj.getDynamicObject("supplier");
        DynamicObjectCollection cols = compObj.getDynamicObjectCollection("entrysupplier");
        for (DynamicObject col : cols) {
            DynamicObject packageObj;
            DynamicObject supplier = col.getDynamicObject("supplier");
            if (!col.getBoolean("isinvite") || null == supplier || !Objects.equals(supplier.getPkValue(), quoSupplier.getPkValue()) || null == (packageObj = col.getDynamicObject("package"))) continue;
            Object packageId = packageObj.getPkValue();
            packageIdMap.put(String.valueOf(packageId), packageId);
        }
        return packageIdMap;
    }

    public Map<String, Object> getPurlistIdMapByItemSup(DynamicObject billObj) {
        HashMap<String, Object> purlistIdMap = new HashMap<String, Object>(8);
        DynamicObject project = billObj.getDynamicObject("project");
        DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)project, (String)"src_itemsupplier");
        if (null == compObj) {
            return purlistIdMap;
        }
        DynamicObject quoSupplier = billObj.getDynamicObject("supplier");
        DynamicObjectCollection cols = compObj.getDynamicObjectCollection("entryentity");
        block0: for (DynamicObject col : cols) {
            DynamicObjectCollection supplierCols = col.getDynamicObjectCollection("supplier");
            if (null == supplierCols) continue;
            DynamicObject purlistObj = col.getDynamicObject("purlist");
            for (DynamicObject supplierCol : supplierCols) {
                Object supId;
                Object supObj = supplierCol.get("fbasedataid");
                if (!(supObj instanceof DynamicObject) || !Objects.equals(supId = ((DynamicObject)supObj).getPkValue(), quoSupplier.getPkValue())) continue;
                purlistIdMap.put(purlistObj.getPkValue().toString(), purlistObj.getPkValue());
                continue block0;
            }
        }
        return purlistIdMap;
    }

    public DynamicObject getPurlistObj(long projectId) {
        QFilter filter = new QFilter("id", "=", (Object)projectId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"src_purlist", (String)"id,template,ismustapply,managetype,isitemsupplier,stopbiddate,tplentry.tmp_template,tplentry.tmp_component,tplentry.tmp_bizobject", (QFilter[])filter.toArray());
        return obj;
    }

    public Map<String, DynamicObject> getBillCompGroupData(DynamicObject obj) {
        HashMap<String, DynamicObject> compKey_objMap = new HashMap<String, DynamicObject>(4);
        List compKeyList = TemplateUtil.getCompKeyListByTplEntry((DynamicObject)obj);
        for (String compKey : compKeyList) {
            DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)obj, (String)compKey);
            if (null == compObj) continue;
            compKey_objMap.put(compKey, compObj);
        }
        return compKey_objMap;
    }

    public void createCompData(DynamicObject billObj, DynamicObject compObj, Map<String, Object> pkgOrPurListIdMap, Map<String, DynamicObject> compKey_objMap, boolean isItemSupplier) {
        DynamicObject project = billObj.getDynamicObject("project");
        String manageType = project.getString("managetype");
        String supType = billObj.getString("suppliertype");
        long supplierId = billObj.getLong("supplier.id");
        DynamicObject supplier = BusinessDataServiceHelper.loadSingle((Object)supplierId, (String)supType);
        DynamicObject taxRate = supplier.getDynamicObject("taxrate");
        for (Map.Entry<String, DynamicObject> compKey_obj : compKey_objMap.entrySet()) {
            DynamicObject compData = compKey_obj.getValue();
            String compKey = compKey_obj.getKey();
            DynamicObject newCompData = null;
            if (null == compObj) {
                newCompData = (DynamicObject)OrmUtils.clone((IDataEntityBase)compData, (boolean)false, (boolean)true);
                newCompData.set("parentid", billObj.getPkValue());
                newCompData.set("entitykey", (Object)compKey);
            } else {
                if (!compKey.equals(compObj.getDataEntityType().getName())) continue;
                newCompData = compObj;
            }
            DynamicObjectCollection newCols = null;
            try {
                newCols = newCompData.getDynamicObjectCollection("entryentity");
            }
            catch (Exception e) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCompData});
                continue;
            }
            if (null != newCols && newCols.size() > 0) {
                newCols.clear();
            }
            DynamicObjectCollection cols = compData.getDynamicObjectCollection("entryentity");
            for (DynamicObject col : cols) {
                if (isItemSupplier) {
                    String purlistId;
                    Object purListObj = col.get("purlist");
                    if (!(purListObj instanceof DynamicObject) || null == pkgOrPurListIdMap.get(purlistId = String.valueOf(((DynamicObject)purListObj).getPkValue()))) {
                        continue;
                    }
                } else if ("2".equals(manageType)) {
                    Object packageObj = col.get("package");
                    if (packageObj instanceof String) continue;
                    DynamicObject packageDyObj = (DynamicObject)packageObj;
                    if (null != packageObj) {
                        String packageName = packageDyObj.getString("packagename");
                        if (null == pkgOrPurListIdMap.get(packageDyObj.getPkValue().toString()) && !Objects.equals(packageName, "ByItem")) continue;
                    }
                }
                DynamicObject newCol = (DynamicObject)OrmUtils.clone((IDataEntityBase)col, (boolean)true, (boolean)true);
                newCol.set("suppliertype", (Object)supType);
                newCol.set("supplier", (Object)supplierId);
                newCol.set("supplier_id", (Object)supplierId);
                newCol.set("billtype", (Object)"2");
                newCol.set("compkey", (Object)compKey);
                String turns = newCol.getString("turns");
                if (null == turns || turns.trim().length() == 0) {
                    newCol.set("turns", (Object)"1");
                }
                if (null != taxRate) {
                    newCol.set("taxitem", taxRate.getPkValue());
                    newCol.set("taxitem_id", taxRate.getPkValue());
                    BigDecimal taxRateVal = taxRate.getBigDecimal("taxrate");
                    newCol.set("taxrate", (Object)taxRateVal);
                }
                newCols.add((Object)newCol);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCompData});
        }
    }

    public DynamicObject getNegBillObj(DynamicObject billObj) {
        String turns = billObj.getString("turns");
        QFilter negFilter = new QFilter("turns", "=", (Object)turns);
        DynamicObject project = billObj.getDynamicObject("project");
        negFilter.and("project", "=", project.getPkValue());
        DynamicObject negObj = BusinessDataServiceHelper.loadSingle((String)"src_negotiatebill", (String)"id,template,tplentry.tmp_template,tplentry.tmp_component,tplentry.tmp_bizobject", (QFilter[])negFilter.toArray());
        return negObj;
    }

    public void createCompData(DynamicObject billObj, DynamicObject compObj, Map<String, DynamicObject> compKey_objMap) {
        if (null == compObj) {
            return;
        }
        long supplierId = billObj.getLong("supplier.id");
        if (0L == supplierId) {
            return;
        }
        for (Map.Entry<String, DynamicObject> compKey_obj : compKey_objMap.entrySet()) {
            DynamicObject compData = compKey_obj.getValue();
            DynamicObject newCompData = compObj;
            DynamicObjectCollection newCols = newCompData.getDynamicObjectCollection("entryentity");
            newCols.clear();
            DynamicObjectCollection cols = compData.getDynamicObjectCollection("entryentity");
            for (DynamicObject col : cols) {
                DynamicObject supplier = col.getDynamicObject("supplier");
                if (null == supplier || !String.valueOf(supplierId).equals(supplier.getPkValue().toString())) continue;
                DynamicObject newCol = (DynamicObject)OrmUtils.clone((IDataEntityBase)col, (boolean)true, (boolean)true);
                newCol.set("srcentryid", col.getPkValue());
                DynamicObject taxItem = col.getDynamicObject("taxitem");
                if (null != taxItem) {
                    BigDecimal taxRate = taxItem.getBigDecimal("taxrate");
                    newCol.set("taxrate", (Object)taxRate);
                }
                newCols.add((Object)newCol);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newCompData});
        }
    }

    public boolean isEmpty(DynamicObject compDataObj, String compKey) {
        if ("src_biddoc_src".equals(compKey) || "src_biddoc_tnd".equals(compKey) || Objects.equals("tnd_biddoc_query", compKey) || Objects.equals("src_purlist_item", compKey)) {
            return false;
        }
        boolean isEmpty = false;
        if (null != compDataObj) {
            DynamicObjectCollection cols;
            String entry_entity = "entryentity";
            if ("src_purlist_item".equals(compKey)) {
                entry_entity = "itementity";
            }
            if ((cols = compDataObj.getDynamicObjectCollection(entry_entity)).size() == 0) {
                isEmpty = true;
            }
        }
        return isEmpty;
    }
}

