/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.enums.SrcNegotiatetypeEnums;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;
import kd.scm.pds.common.vie.PdsVieHelper;

public class TndQuoteTendencyValidator
implements ISrcValidator {
    private static final long serialVersionUID = 5668872498785675048L;

    public void validate(SrcValidatorData srcValidatorData) {
        String negotiateType;
        String tendency = srcValidatorData.getBillObj().getString("project.tendency");
        if (null == tendency || "".equals(tendency) || "3".equals(tendency)) {
            srcValidatorData.setSucced(true);
            return;
        }
        if ("src_negotiatebill".equals(srcValidatorData.getBizObject()) && (null == (negotiateType = srcValidatorData.getBillObj().getString("negotiatetype")) || "".equals(negotiateType) || SrcNegotiatetypeEnums.ONLINE.getValue().equals(negotiateType) || SrcNegotiatetypeEnums.ONLINE_VIE.getValue().equals(negotiateType))) {
            srcValidatorData.setSucced(true);
            return;
        }
        String billId = String.valueOf(SrmCommonUtil.getPkValue((DynamicObject)srcValidatorData.getBillObj()));
        long projectId = SrmCommonUtil.getPkValue((DynamicObject)srcValidatorData.getBillObj().getDynamicObject("project"));
        String taxtype = srcValidatorData.getBillObj().getString("project.taxtype");
        boolean isDecisionByAmount = "2".equals(srcValidatorData.getBillObj().getString("project.decisiontype"));
        String selectFields = "purlistseq,materialnane,price,taxprice,purlist.id,turns,currency.priceprecision priceprecision,currency.amtprecision amtprecision,parentid,suppliertype,supplier.id,project.taxtype taxtype";
        QFilter qfilters = new QFilter("project", "=", (Object)projectId);
        qfilters.and("isdiscarded", "=", (Object)"0");
        qfilters.and(new QFilter("price", ">", (Object)BigDecimal.ZERO).or("taxprice", ">", (Object)BigDecimal.ZERO).or("amount", ">", (Object)BigDecimal.ZERO).or("taxamount", ">", (Object)BigDecimal.ZERO));
        if (!"src_negotiatebill".equals(srcValidatorData.getBizObject())) {
            long supplierId = SrmCommonUtil.getPkValue((DynamicObject)srcValidatorData.getBillObj().getDynamicObject("supplier"));
            qfilters = qfilters.and("supplier", "=", (Object)supplierId);
        }
        DynamicObjectCollection purlists = QueryServiceHelper.query((String)"src_purlistf7", (String)selectFields, (QFilter[])qfilters.toArray(), (String)"purlistseq");
        List currPurlist = purlists.stream().filter(row -> row.getString("parentid").equals(billId)).collect(Collectors.toList());
        List hisPurlist = purlists.stream().filter(row -> !row.getString("parentid").equals(billId)).collect(Collectors.toList());
        if (currPurlist == null || currPurlist.size() == 0 || hisPurlist == null || hisPurlist.size() == 0) {
            srcValidatorData.setSucced(true);
            return;
        }
        HashMap<String, BigDecimal> priceMap = new HashMap<String, BigDecimal>();
        for (DynamicObject obj : hisPurlist) {
            StringBuilder key = new StringBuilder();
            key.append(obj.getString("supplier.id"));
            key.append('|');
            key.append(obj.getString("purlist.id"));
            BigDecimal price = BigDecimal.ZERO;
            price = "2".equals(taxtype) ? (isDecisionByAmount ? obj.getBigDecimal("amount") : obj.getBigDecimal("price")) : (isDecisionByAmount ? obj.getBigDecimal("taxamount") : obj.getBigDecimal("taxprice"));
            BigDecimal hisPrice = (BigDecimal)priceMap.get(key.toString());
            if (hisPrice == null || hisPrice.compareTo(BigDecimal.ZERO) == 0) {
                priceMap.put(key.toString(), price);
                continue;
            }
            if ("1".equals(tendency)) {
                if (price.compareTo(hisPrice) >= 0) continue;
                priceMap.put(key.toString(), price);
                continue;
            }
            if (price.compareTo(hisPrice) <= 0) continue;
            priceMap.put(key.toString(), price);
        }
        StringBuilder sb = new StringBuilder();
        for (DynamicObject obj : currPurlist) {
            BigDecimal hisPrice;
            StringBuilder key = new StringBuilder();
            key.append(obj.getString("supplier.id"));
            key.append('|');
            key.append(obj.getString("purlist.id"));
            int priceprecision = obj.getInt("priceprecision");
            BigDecimal price = BigDecimal.ZERO;
            if ("2".equals(taxtype)) {
                price = isDecisionByAmount ? obj.getBigDecimal("amount") : obj.getBigDecimal("price");
            } else {
                BigDecimal bigDecimal = price = isDecisionByAmount ? obj.getBigDecimal("taxamount") : obj.getBigDecimal("taxprice");
            }
            if ((hisPrice = (BigDecimal)priceMap.get(key.toString())) == null || hisPrice.compareTo(BigDecimal.ZERO) == 0) continue;
            sb = PdsVieHelper.verifyTendency((StringBuilder)sb, (String)taxtype, (String)tendency, (DynamicObject)obj, (BigDecimal)hisPrice, (BigDecimal)price, (int)priceprecision);
        }
        if (sb.length() > 0) {
            srcValidatorData.setSucced(false);
            if ("1".equals(tendency)) {
                srcValidatorData.setMessage(String.format(ResManager.loadKDString((String)"\u672c\u8f6e\u62a5\u4ef7\u4e0d\u80fd\u9ad8\u4e8e\u524d\u4e00\u8f6e\u62a5\u4ef7\uff1a%1$s", (String)"TndQuoteTendencyValidator_0", (String)"scm-tnd-opplugin", (Object[])new Object[0]), sb));
            } else {
                srcValidatorData.setMessage(String.format(ResManager.loadKDString((String)"\u672c\u8f6e\u62a5\u4ef7\u4e0d\u80fd\u4f4e\u4e8e\u524d\u4e00\u8f6e\u62a5\u4ef7\uff1a%1$s", (String)"TndQuoteTendencyValidator_1", (String)"scm-tnd-opplugin", (Object[])new Object[0]), sb));
            }
            return;
        }
        srcValidatorData.setSucced(true);
    }
}

