/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.opplugin.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.SrmCommonUtil;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.validator.ISrcValidator;
import kd.scm.pds.common.validator.SrcValidatorData;

public class TndStopBidDateValidator
implements ISrcValidator {
    private static final long serialVersionUID = 1L;

    public void validate(SrcValidatorData srcValidatorData) {
        DynamicObject billObj = srcValidatorData.getBillObj();
        long projectId = 0L;
        projectId = PdsCommonUtils.isNotProjectBill((String)billObj.getDataEntityType().getName()) ? SrmCommonUtil.getPkValue((DynamicObject)billObj.getDynamicObject("project")) : SrmCommonUtil.getPkValue((DynamicObject)billObj);
        QFilter qfilter = new QFilter("id", "=", (Object)projectId);
        if (null == (billObj = QueryServiceHelper.queryOne((String)"src_project", (String)"stopbiddate", (QFilter[])qfilter.toArray()))) {
            return;
        }
        Date stopBidDate = billObj.getDate("stopbiddate");
        if (Objects.isNull(stopBidDate)) {
            return;
        }
        if (stopBidDate.before(TimeServiceHelper.now())) {
            srcValidatorData.setSucced(false);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            srcValidatorData.setMessage(String.format(ResManager.loadKDString((String)"\u6295\u6807\u622a\u6b62\u65f6\u95f4(%1$s)\u5df2\u8fc7\uff0c\u4e0d\u5141\u8bb8\u7ee7\u7eed\u6295\u6807\u62a5\u540d\u3002", (String)"TndStopBidDateValidator_0", (String)"scm-tnd-opplugin", (Object[])new Object[0]), sdf.format(stopBidDate)));
            return;
        }
    }
}

