/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.webapi.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.suplinkman.PdsLinkManFacade;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.tnd.common.util.TndApplyUtils;
import kd.scm.tnd.webapi.model.TndEnrollDetailModel;
import kd.scm.tnd.webapi.model.TndEnrollStatusModel;

@ApiController(value="tnd", desc="\u6295\u6807\u62a5\u540d")
@ApiMapping(value="tnd_apply")
public class TndApplyController
implements Serializable {
    private static final long serialVersionUID = 2886983413304359313L;

    @ApiGetMapping(value="getEntrollInfo")
    public CustomApiResult<TndEnrollDetailModel> getEntrollInfo(@ApiParam(value="\u5355\u636eid", required=true) @ApiParam(value="\u5355\u636eid", required=true) Long billId) {
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"tnd_apply");
        if (Objects.isNull(billObj)) {
            return CustomApiResult.fail((String)"400", (String)ResManager.loadKDString((String)"\u53d6\u4e0d\u5230\u5355\u636e\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"TndApplyController_0", (String)"scm-tnd-webapi", (Object[])new Object[0]));
        }
        DynamicObject projectObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"tnd_project", (String)"id,managetype");
        TndEnrollDetailModel enrollModel = new TndEnrollDetailModel();
        enrollModel.setManageType(projectObj.getString("managetype"));
        enrollModel.setEndDate(billObj.getDate("stopbiddate"));
        Date replyDate = billObj.getDate("replydate");
        if (null == replyDate) {
            replyDate = TndApplyUtils.getDateByOffsetDay((Date)TimeServiceHelper.now(), (int)30);
        }
        enrollModel.setReplyDate(replyDate);
        long projectId = billId;
        long supId = this.getEnrollSupplierId(projectId);
        enrollModel.setSupId(supId);
        this.setEnrollInfo(enrollModel, projectId, supId);
        this.setEnrollStatus(enrollModel, projectId, supId);
        this.setpackageIds(enrollModel, projectId, supId);
        return CustomApiResult.success((Object)((Object)enrollModel));
    }

    @ApiGetMapping(value="getEntrollStatus")
    public CustomApiResult<List<TndEnrollStatusModel>> getEntrollStatus(@ApiParam(value="\u5355\u636eid", required=true) @ApiParam(value="\u5355\u636eid", required=true) List<Long> billIdList) {
        List<Long> projectIds = billIdList;
        QFilter filter = new QFilter("id", "in", projectIds);
        DynamicObject[] billObjs = BusinessDataServiceHelper.load((String)"tnd_apply", (String)"id,bizstatus,replydate,stopbiddate", (QFilter[])filter.toArray());
        if (billObjs.length == 0) {
            return CustomApiResult.fail((String)"400", (String)ResManager.loadKDString((String)"\u53d6\u4e0d\u5230\u5355\u636e\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"TndApplyController_0", (String)"scm-tnd-webapi", (Object[])new Object[0]));
        }
        List supplierIds = PdsCommonUtils.getSupplierByUserOfBizPartner();
        Set enrollIds = TndApplyUtils.getEnrollIds((List)supplierIds, projectIds);
        Set inviteIds = TndApplyUtils.getInviteIds((List)supplierIds, projectIds);
        ArrayList<TndEnrollStatusModel> enrollStatusList = new ArrayList<TndEnrollStatusModel>(billIdList.size());
        for (DynamicObject billObj : billObjs) {
            TndEnrollStatusModel statusModel = new TndEnrollStatusModel();
            statusModel.setBillId(billObj.getLong("id"));
            String enrollstatus = TndApplyUtils.getEnrollStatus((DynamicObject)billObj, (Set)enrollIds, (Set)inviteIds, (Date)billObj.getDate("replydate"), (Date)billObj.getDate("stopbiddate"));
            statusModel.setEnrollstatus(enrollstatus);
            enrollStatusList.add(statusModel);
        }
        return CustomApiResult.success(enrollStatusList);
    }

    private long getEnrollSupplierId(long projectId) {
        long supplierId = 0L;
        List supplierIds = PdsCommonUtils.getSupplierByUserOfBizPartner();
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId);
        qFilter.and("supplier", "in", (Object)supplierIds);
        DynamicObject enrollObj = QueryServiceHelper.queryOne((String)"src_enrollsupplier", (String)"suppliertype,supplier.id", (QFilter[])new QFilter[]{qFilter});
        if (enrollObj != null) {
            supplierId = enrollObj.getLong("supplier.id");
        } else if (supplierIds.size() > 0) {
            supplierId = (Long)supplierIds.get(0);
        }
        return supplierId;
    }

    public void setEnrollInfo(TndEnrollDetailModel enrollModel, long projectId, long supplierId) {
        String selectFields = "linkman,duty,phone,email,address,remark";
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId).and("supplier", "=", (Object)supplierId);
        DynamicObject enrollObj = QueryServiceHelper.queryOne((String)"src_enrollsupplier", (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (enrollObj != null) {
            enrollModel.setLinkman(enrollObj.getString("linkman"));
            enrollModel.setDuty(enrollObj.getString("duty"));
            enrollModel.setPhone(enrollObj.getString("phone"));
            enrollModel.setAddress(enrollObj.getString("address"));
            enrollModel.setEmail(enrollObj.getString("email"));
            enrollModel.setRemark(enrollObj.getString("remark"));
        } else {
            HashMap lingkerMap = new HashMap(8);
            Object supplierType = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"suppliertype");
            lingkerMap = supplierType == null || "".equals(supplierType) || "bd_supplier".equals(supplierType.toString()) ? PdsLinkManFacade.getSupplierLinkMan((Object)enrollModel.getSupId()) : PdsLinkManFacade.getRegSupplierLinkMan((Object)enrollModel.getSupId());
            enrollModel.setLinkman((String)lingkerMap.get("linkman"));
            enrollModel.setDuty((String)lingkerMap.get("duty"));
            enrollModel.setPhone((String)lingkerMap.get("phone"));
            enrollModel.setAddress((String)lingkerMap.get("address"));
            enrollModel.setEmail((String)lingkerMap.get("email"));
            enrollModel.setRemark((String)lingkerMap.get("remark"));
        }
    }

    public void setEnrollStatus(TndEnrollDetailModel enrollModel, long projectId, long supplierId) {
        ArrayList<Long> supplierIds = new ArrayList<Long>();
        supplierIds.add(supplierId);
        ArrayList<Long> projectIds = new ArrayList<Long>();
        projectIds.add(projectId);
        Set enrollIds = TndApplyUtils.getEnrollIds(supplierIds, projectIds);
        Set inviteIds = TndApplyUtils.getInviteIds(supplierIds, projectIds);
        if (projectId != 0L) {
            String enrollstatus = TndApplyUtils.getEnrollStatus((DynamicObject)BusinessDataServiceHelper.loadSingle((Object)projectId, (String)"tnd_apply"), (Set)enrollIds, (Set)inviteIds, (Date)enrollModel.getReplyDate(), (Date)enrollModel.getEndDate());
            enrollModel.setEnrollstatus(enrollstatus);
        }
    }

    private void setpackageIds(TndEnrollDetailModel enrollModel, long projectId, long supplierId) {
        HashSet<Long> packageIds = new HashSet<Long>();
        QFilter qFilter = new QFilter("billid", "=", (Object)projectId).and("supplier", "=", (Object)supplierId);
        DynamicObjectCollection packageObjs = QueryServiceHelper.query((String)"src_enrollsupplier", (String)"package.id", (QFilter[])qFilter.toArray());
        if (packageObjs.size() == 0) {
            packageObjs = QueryServiceHelper.query((String)"src_packagef7", (String)"package.id", (QFilter[])new QFilter[]{new QFilter("project.id", "=", (Object)projectId)});
        }
        for (DynamicObject packageObj : packageObjs) {
            packageIds.add(packageObj.getLong("package.id"));
        }
        enrollModel.setPackageSet(packageIds.toArray(new Long[0]));
    }
}

