/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.webapi.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scm.pds.common.function.IGetValFunction;
import kd.scm.pds.common.util.PdsCompConfigUtil;
import kd.scm.tnd.webapi.model.TndCompConfigEntryModel;
import kd.scm.tnd.webapi.model.TndCompConfigModel;

@ApiController(value="tnd", desc="\u9875\u9762\u914d\u7f6e")
@ApiMapping(value="tnd_compconfig")
public class TndCompConfigController
implements Serializable {
    private static final long serialVersionUID = 2886983413304359313L;

    @ApiGetMapping(value="getCompConfig")
    public CustomApiResult<TndCompConfigModel> getCompConfig(@ApiParam(value="\u5355\u636eid", required=true) @ApiParam(value="\u5355\u636eid", required=true) Long billId, @ApiParam(value="\u5355\u636e\u6807\u8bc6", required=true) @ApiParam(value="\u5355\u636e\u6807\u8bc6", required=true) String entityKey, @ApiParam(value="\u7ec4\u4ef6\u6807\u8bc6", required=true) @ApiParam(value="\u7ec4\u4ef6\u6807\u8bc6", required=true) String compKey) {
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityKey);
        if (Objects.isNull(billObj)) {
            return CustomApiResult.fail((String)"400", (String)ResManager.loadKDString((String)"\u53d6\u4e0d\u5230\u5355\u636e\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"TndCompConfigController_1", (String)"scm-tnd-webapi", (Object[])new Object[0]));
        }
        TndCompConfigModel configModel = new TndCompConfigModel();
        DynamicObject compConfig = PdsCompConfigUtil.getCompConfig((DynamicObject)billObj, (String)compKey, (List)PdsCompConfigUtil.getGroupKeys(), (IGetValFunction)PdsCompConfigUtil.getFunction((Set)PdsCompConfigUtil.getSpecialFields(), (Set)PdsCompConfigUtil.getSpecialBills()));
        if (Objects.nonNull(compConfig)) {
            configModel.setComconfigId(compConfig.getLong("id"));
            configModel.setNumber(compConfig.getString("number"));
            ArrayList<TndCompConfigEntryModel> entryList = new ArrayList<TndCompConfigEntryModel>();
            DynamicObjectCollection cols = compConfig.getDynamicObjectCollection("entryentity");
            for (DynamicObject col : cols) {
                TndCompConfigEntryModel entry = new TndCompConfigEntryModel();
                entry.setFieldKey(col.getString("fieldid"));
                entry.setVisiable(col.getBoolean("isvisible"));
                entry.setEditable(col.getBoolean("iseditable"));
                entry.setMustInput(col.getBoolean("ismustinput"));
                entryList.add(entry);
            }
            configModel.setConfigEntry(entryList);
        }
        return CustomApiResult.success((Object)((Object)configModel));
    }
}

