/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.webapi.controller;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.BizLog;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiGetMapping;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.scm.common.util.ParamUtil;
import kd.scm.pds.common.extfilter.SchemeFilterUtils;
import kd.scm.pds.common.nodestatus.SrcNodeStatusContext;
import kd.scm.pds.common.nodestatus.SrcNodeStatusData;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandler;
import kd.scm.pds.common.nodestatus.SrcNodeStatusHandlerFactory;
import kd.scm.pds.common.util.PdsCommonUtils;
import kd.scm.pds.common.util.SupplierUtil;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.tnd.webapi.model.TndNodeStatusDataModel;
import org.apache.commons.beanutils.BeanUtils;

@ApiController(value="tnd", desc="\u6211\u7684\u4efb\u52a1")
@ApiMapping(value="tnd_project_task")
public class TndProjectTaskController
implements Serializable {
    private static final long serialVersionUID = 2886983413304359313L;

    @ApiGetMapping(value="getTask")
    public CustomApiResult<List<TndNodeStatusDataModel>> getTask(@ApiParam(value="\u5355\u636eid", required=true) @ApiParam(value="\u5355\u636eid", required=true) Long billId, @ApiParam(value="\u4f9b\u5e94\u5546id") @ApiParam(value="\u4f9b\u5e94\u5546id") List<Long> supIdList) {
        DynamicObject billObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"tnd_project");
        if (Objects.isNull(billObj)) {
            return CustomApiResult.fail((String)"400", (String)ResManager.loadKDString((String)"\u53d6\u4e0d\u5230\u5355\u636e\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u53c2\u6570\u662f\u5426\u6b63\u786e\u3002", (String)"TndProjectTaskController_0", (String)"scm-tnd-webapi", (Object[])new Object[0]));
        }
        this.setSourceType(billObj);
        this.setTemplate(billObj);
        List<TndNodeStatusDataModel> dataList = this.getTask(billObj, supIdList);
        return CustomApiResult.success(dataList);
    }

    private void setSourceType(DynamicObject obj) {
        if (obj.getDynamicObject("srctype") == null) {
            QFilter srctypeFilter;
            DynamicObject flowConfigObj;
            QFilter projectFilter = new QFilter("id", "=", (Object)Long.parseLong(obj.getPkValue().toString()));
            DynamicObject projectObj = QueryServiceHelper.queryOne((String)"src_project", (String)"sourcetype,tendertype", (QFilter[])new QFilter[]{projectFilter});
            if (projectObj == null) {
                return;
            }
            String tendertype = projectObj.getString("tendertype");
            if (tendertype == null || tendertype.trim().equals("")) {
                tendertype = "1";
            }
            if ((flowConfigObj = QueryServiceHelper.queryOne((String)"pds_flowconfig", (String)"id", (QFilter[])new QFilter[]{srctypeFilter = new QFilter("issupplier", "=", (Object)Character.valueOf('1')).and("tendertype", "=", (Object)tendertype)})) != null) {
                flowConfigObj = BusinessDataServiceHelper.loadSingle((Object)flowConfigObj.get("id"), (String)"pds_flowconfig");
                obj.set("srctype", (Object)flowConfigObj);
            }
        }
    }

    private void setTemplate(DynamicObject obj) {
        if (obj.getDynamicObject("template") == null) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("biznodebizobject", "tnd_project");
            paramMap.put("sourcetype", obj.getLong("sourcetype.id"));
            long templateId = SchemeFilterUtils.getFirstSchemeId((DynamicObject)obj, (String)"pds_tplconfig_filter", paramMap);
            if (templateId > 0L) {
                DynamicObject templateObj = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"pds_tplconfig");
                obj.set("template", (Object)templateObj);
                DynamicObject purListObj = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"src_purlist");
                TemplateUtil.createTplEntryData((DynamicObject)purListObj, (DynamicObject)obj, (boolean)true);
            }
        }
    }

    private List<TndNodeStatusDataModel> getTask(DynamicObject billObj, List<Long> supIdList) {
        DynamicObjectCollection bizNodes = billObj.getDynamicObject("srctype").getDynamicObjectCollection("entrynode");
        QFilter idFilter = new QFilter("id", "=", billObj.getPkValue());
        DynamicObject obj = QueryServiceHelper.queryOne((String)"src_project", (String)"id,srctype.isneedinvite isneedinvite", (QFilter[])idFilter.toArray());
        boolean isNeedInvite = obj.getBoolean("isneedinvite");
        if (!isNeedInvite) {
            for (int i = 0; i < bizNodes.size(); ++i) {
                if (!Objects.equals(((DynamicObject)bizNodes.get(i)).getString("biznode.number"), "34")) continue;
                bizNodes.remove(i);
            }
        }
        if (supIdList.size() == 0) {
            supIdList = PdsCommonUtils.getSupplierByUserOfBizPartner();
        }
        long projectId = PdsCommonUtils.object2Long((Object)billObj.getPkValue());
        SrcNodeStatusContext context = new SrcNodeStatusContext();
        context.setProjectId(projectId);
        context.setSupplierList(supIdList);
        context.setNodeList(new ArrayList());
        Object supplierType = ParamUtil.getParamObj((String)"0DUM2+6E41IA", (String)"suppliertype");
        if (supplierType == null || "".equals(supplierType) || "bd_supplier".equals(supplierType.toString())) {
            context.setSupplierType("bd_supplier");
        } else {
            context.setSupplierType("src_supplier");
        }
        context.setConfirm(this.isConfirm(projectId, supIdList));
        int index = 0;
        for (DynamicObject bizNode : bizNodes) {
            context.setNodeObj(bizNode);
            context.setNodeSeq(index);
            SrcNodeStatusHandler nodeHandler = SrcNodeStatusHandlerFactory.getStrategyInstance((SrcNodeStatusContext)context);
            if (nodeHandler != null) {
                nodeHandler.nodeStatusHandle(context);
            }
            ++index;
        }
        ArrayList<TndNodeStatusDataModel> dataList = new ArrayList<TndNodeStatusDataModel>(context.getNodeList().size());
        for (int i = context.getNodeList().size() - 1; i >= 0; --i) {
            dataList.add(this.nodeStatusDataConvertModel((SrcNodeStatusData)context.getNodeList().get(i)));
        }
        return dataList;
    }

    private boolean isConfirm(Object projectId, List<Long> supplierList) {
        QFilter filter = new QFilter("billid", "=", projectId).and("isconfirm", "=", (Object)Boolean.TRUE);
        String supType = SupplierUtil.getSupType(null);
        String filterSupPro = SupplierUtil.getSupProBySupType((String)supType);
        filter.and(filterSupPro, "in", supplierList);
        return QueryServiceHelper.exists((String)"src_bidopensupplier", (QFilter[])new QFilter[]{filter});
    }

    private TndNodeStatusDataModel nodeStatusDataConvertModel(SrcNodeStatusData nodeData) {
        TndNodeStatusDataModel statusData = new TndNodeStatusDataModel();
        try {
            BeanUtils.copyProperties((Object)((Object)statusData), (Object)nodeData);
        }
        catch (IllegalAccessException e) {
            BizLog.log((String)("tranfer exception:" + e.getMessage()));
        }
        catch (InvocationTargetException e) {
            BizLog.log((String)("tranfer exception:" + e.getMessage()));
        }
        return statusData;
    }
}

