/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.webapi.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.BizLog;
import kd.bos.openapi.action.util.DataMappingUtil;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.api.params.ApiQueyParam;
import kd.bos.openapi.base.model.ApiModel;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.openapi.common.util.ComparatorUtil;
import kd.bos.openapi.handle.PropertyHandleUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.scm.common.util.LowTimer;
import kd.scm.pds.common.extplugin.ExtPluginFactory;
import kd.scm.pds.common.extplugin.openapi.IQueryList;
import kd.scm.pds.common.extplugin.openapi.QueryContext;
import kd.scm.tnd.webapi.args.TndQueryArgs;
import kd.scm.tnd.webapi.model.QueryParamModel;
import kd.scm.tnd.webapi.model.QueryResultModel;

@ApiController(value="tnd", desc="\u67e5\u8be2\u63a5\u53e3")
@ApiMapping(value="tnd_query")
public class TndQueryServiceController
implements Serializable {
    private static final long serialVersionUID = 4490178613009516598L;

    @ApiPostMapping(value="getList")
    public CustomApiResult<QueryResultModel> getList(@ApiParam(value="\u67e5\u8be2\u53c2\u6570") @ApiParam(value="\u67e5\u8be2\u53c2\u6570") QueryParamModel paramModel) {
        QueryResultModel result = this.doQuery(paramModel);
        return CustomApiResult.success((Object)((Object)result));
    }

    private QueryResultModel doQuery(QueryParamModel param) {
        TndQueryArgs queryArgs = this.buildArgs(param);
        QFilter qfilter = queryArgs.getqFilter();
        Set<String> selectSet = queryArgs.getSelectSet();
        String orderBys = queryArgs.getOrderBys();
        ApiModel api = queryArgs.getApiModel();
        Set newSelectSet = ComparatorUtil.getSelect(selectSet);
        LowTimer timer = new LowTimer();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)param.getFormId(), (String)String.join((CharSequence)",", newSelectSet), (QFilter[])qfilter.toArray(), (String)orderBys, (int)(param.getPageNo() - 1), (int)param.getPageSize());
        if (null != queryArgs.getQueryListPlugin()) {
            dynamicObjects = queryArgs.getQueryListPlugin().handleQueryData(queryArgs.getContext(), dynamicObjects);
        }
        List<Object> rows = new ArrayList();
        Map<String, Set<String>> prefixMap = this.getPrefixMap(newSelectSet);
        rows = PropertyHandleUtil.toMapListRoot((String)param.getFormId(), (String)"$", (DynamicObject[])dynamicObjects, prefixMap);
        if (rows == null) {
            rows = Collections.emptyList();
        }
        List<Object> resultList = rows;
        resultList = null != api ? DataMappingUtil.mappingResult(rows, (List)api.getResponseList()) : this.mappingResult(rows);
        QueryResultModel result = new QueryResultModel();
        result.setFilter(qfilter.toString());
        result.setRows(resultList);
        try {
            int totalCount = 0;
            boolean lastPage = false;
            if (rows.isEmpty()) {
                lastPage = true;
            } else {
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)param.getFormId(), (String)"id", (QFilter[])qfilter.toArray(), null);){
                    totalCount = dataSet.count("id", true);
                    lastPage = result.getRows().size() < param.getPageSize() || param.getPageNo() * param.getPageSize() >= totalCount;
                }
            }
            result.setTotalCount(totalCount);
            result.setLastPage(lastPage);
        }
        catch (Exception e) {
            result.setLastPage(result.getRows().size() < param.getPageSize());
            BizLog.log((String)("###TndQueryServiceController queryexception:" + e.getMessage()));
        }
        result.setPageNo(param.getPageNo());
        result.setPageSize(param.getPageSize());
        BizLog.log((String)("###TndQueryServiceController query costtime:" + timer.msValue()));
        return result;
    }

    private TndQueryArgs buildArgs(QueryParamModel param) {
        TndQueryArgs queryArgs = new TndQueryArgs();
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(4);
        ApiModel api = this.tryGetApiModel(param);
        queryArgs.setApiModel(api);
        String extNumber = String.format("IQueryList-%s", param.getFormId());
        IQueryList queryList = (IQueryList)ExtPluginFactory.getInstance().getExtPluginInstance(extNumber);
        QueryContext context = new QueryContext();
        if (null != api) {
            context.setFilterByParams(false);
        } else {
            context.setFilterByParams(true);
        }
        if (null != queryList) {
            queryArgs.setQueryListPlugin(queryList);
            context.setEntityId(param.getFormId());
            context.setParamMap(param.getQueryParams());
            QFilter billFilter = queryList.getFilter(context);
            if (null != billFilter) {
                filterList.add(billFilter);
            }
            queryArgs.setContext(context);
        }
        if (null != api) {
            queryArgs.setSelectSet(api.getSelectSet());
            queryArgs.setOrderBys(api.getOrderBy());
            Map<String, Object> params = param.getQueryParams();
            HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>(1);
            data.put("data", params);
            ApiQueyParam apiParam = new ApiQueyParam(new OpenApiRequest());
            apiParam.getRequest().setData(data);
        } else {
            QFilter orgFilter = this.getOrgFilter(param);
            if (Objects.nonNull(orgFilter)) {
                filterList.add(orgFilter);
            }
            if (null != queryList) {
                queryArgs.setSelectSet(queryList.getSelectSet(context));
                queryArgs.setOrderBys(queryList.getOrderBys(context));
            }
        }
        queryArgs.setqFilter(this.builderQfilter(filterList));
        return queryArgs;
    }

    private ApiModel tryGetApiModel(QueryParamModel param) {
        ApiModel apiModel = null;
        return apiModel;
    }

    private QFilter builderQfilter(List<QFilter> filterList) {
        if (filterList.size() == 0) {
            throw new KDBizException("query filter isempty.");
        }
        QFilter queryFilter = null;
        for (QFilter filter : filterList) {
            if (null == queryFilter) {
                queryFilter = filter;
                continue;
            }
            queryFilter.and(filter);
        }
        return queryFilter;
    }

    private QFilter getOrgFilter(QueryParamModel param) {
        QFilter orgFilter = null;
        HasPermOrgResult orgResult = PermissionServiceHelper.getAllPermOrgs((Long)RequestContext.get().getCurrUserId(), null, (String)param.getFormId(), (String)"47150e89000000ac");
        if (!orgResult.hasAllOrgPerm()) {
            orgFilter = new QFilter("org", "in", (Object)orgResult.getHasPermOrgs());
        }
        return orgFilter;
    }

    private Map<String, Set<String>> getPrefixMap(Set<String> newSelectSet) {
        return newSelectSet.stream().sorted(ComparatorUtil.getStringComparator()).collect(Collectors.groupingBy(it -> {
            int endIndex = it.lastIndexOf(".");
            if (endIndex != -1) {
                return it.substring(0, endIndex);
            }
            return "$";
        }, LinkedHashMap::new, Collectors.mapping(it -> {
            int indexOf = it.lastIndexOf(".");
            if (indexOf != -1) {
                return it.substring(indexOf + 1);
            }
            return it;
        }, Collectors.toCollection(LinkedHashSet::new))));
    }

    private List<Map<String, Object>> mappingResult(List<Map<String, Object>> rows) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(rows.size());
        for (Map<String, Object> row : rows) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>(row.size());
            this.mappingValResult(linkedHashMap, row, null);
            resultList.add(linkedHashMap);
        }
        return resultList;
    }

    private void mappingValResult(Map<String, Object> linkedHashMap, Map<String, Object> row, String parent) {
        for (Map.Entry<String, Object> rowEntry : row.entrySet()) {
            Object value = rowEntry.getValue();
            String valKey = rowEntry.getKey();
            if (null != parent) {
                valKey = parent + "_" + valKey;
            }
            if (value instanceof List) {
                linkedHashMap.put(valKey, rowEntry.getValue());
                continue;
            }
            if (value instanceof Map) {
                Map newValMap = (Map)value;
                this.mappingValResult(linkedHashMap, newValMap, rowEntry.getKey());
                continue;
            }
            linkedHashMap.put(valKey, rowEntry.getValue());
        }
    }
}

