/*
 * Decompiled with CFR 0.152.
 */
package kd.scm.tnd.webapi.controller;

import java.io.Serializable;
import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scm.common.util.cal.Cal4DynamicObj;
import kd.scm.pds.common.util.TemplateUtil;
import kd.scm.pds.common.util.TndQuoteUtil;
import kd.scm.tnd.webapi.model.TndQuoteModelV2;
import kd.scm.tnd.webapi.util.TndPurListUtil;

@ApiController(value="tnd", desc="\u62a5\u4ef7\u5355")
@ApiMapping(value="tnd_quotebill")
public class TndQuoteBillControllerV2
implements Serializable {
    private static final long serialVersionUID = 515772134612936900L;

    @ApiPostMapping(value="save/v2")
    public CustomApiResult<String> save(@ApiParam(value="\u62a5\u4ef7\u5355\u6a21\u578b") @ApiParam(value="\u62a5\u4ef7\u5355\u6a21\u578b") TndQuoteModelV2 quoteModel) {
        return this.doOperation(quoteModel, "save");
    }

    @ApiPostMapping(value="quote/v2")
    public CustomApiResult<String> quote(@ApiParam(value="\u62a5\u4ef7\u5355\u6a21\u578b") @ApiParam(value="\u62a5\u4ef7\u5355\u6a21\u578b") TndQuoteModelV2 quoteModel) {
        return this.doOperation(quoteModel, "audit");
    }

    private CustomApiResult<String> doOperation(TndQuoteModelV2 quoteModel, String operation) {
        StringBuilder msgBuilder = new StringBuilder();
        TndPurListUtil.validateData(quoteModel.getId(), "tnd_quotebill", msgBuilder);
        if (msgBuilder.length() > 0) {
            return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
        }
        Long quoteId = quoteModel.getId();
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.add(quoteId);
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((Object)quoteId, (String)"tnd_quotebill");
        TndPurListUtil.validateConfirm(obj, msgBuilder);
        if (msgBuilder.length() > 0) {
            return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
        }
        DynamicObject compObj = TemplateUtil.getCompData((DynamicObject)obj, (String)"src_purlist_stand");
        TndPurListUtil.updateComponentV2(obj, compObj, quoteModel.getEntry(), msgBuilder);
        if (msgBuilder.length() > 0) {
            return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
        }
        Cal4DynamicObj.calByQty((DynamicObject)compObj, (String)"entryentity");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{compObj});
        switch (operation) {
            case "save": {
                break;
            }
            case "audit": {
                TndPurListUtil.validateCompConfig(obj, compObj, msgBuilder);
                if (msgBuilder.length() <= 0) break;
                return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
            }
        }
        TndQuoteUtil.calcTotalAmount((String)"tnd_quotebill", (long)quoteId);
        TndPurListUtil.invokeOp(idList, "tnd_quotebill", operation, msgBuilder);
        if (msgBuilder.length() > 0) {
            return CustomApiResult.fail((String)"400", (String)msgBuilder.toString());
        }
        return CustomApiResult.success((Object)ResManager.loadKDString((String)"\u6267\u884c\u6210\u529f", (String)"TndQuoteBillControllerV2_0", (String)"scm-tnd-webapi", (Object[])new Object[0]));
    }
}

