/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.custom.ext.bizextplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.scmc.conm.business.helper.XContractHelper;
import kd.scmc.conm.enums.BizCloseStatusEnum;
import kd.scmc.conm.enums.ChangeTypeEnum;
import kd.scmc.conm.enums.ExcuteControlEnum;
import kd.sdk.scmc.conm.extpoint.IXContractPlugin;

public class XContractSynContractStatusImpl
implements IXContractPlugin {
    private static final Log logger = LogFactory.getLog(XContractSynContractStatusImpl.class);

    public boolean activeSynContractStatus(DynamicObject[] srcBills, DynamicObject[] xBills) {
        if (srcBills == null || srcBills.length <= 0 || xBills == null || xBills.length <= 0) {
            return false;
        }
        HashMap<Long, DynamicObject> xBillEntryMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> hasNewRowBill = new HashSet<Long>(16);
        for (DynamicObject xBill : xBills) {
            DynamicObjectCollection xBillEntrys = xBill.getDynamicObjectCollection("billentry");
            if (xBillEntrys == null || xBillEntrys.isEmpty()) continue;
            for (DynamicObject xBillEntry : xBillEntrys) {
                Long srcBillEntryId = xBillEntry.getLong("billentrysrcid");
                if (srcBillEntryId == null || srcBillEntryId.equals(0L)) {
                    Long sourceBillId = xBill.getLong("sourcebillid");
                    if (sourceBillId == null || sourceBillId.equals(0L)) continue;
                    hasNewRowBill.add(sourceBillId);
                    continue;
                }
                xBillEntryMap.put(srcBillEntryId, xBillEntry);
            }
        }
        for (DynamicObject srcBill : srcBills) {
            DynamicObject type = srcBill.getDynamicObject("type");
            String contCtrl = type.getString("excutecontrol");
            DynamicObjectCollection billEntry = srcBill.getDynamicObjectCollection("billentry");
            if (!ExcuteControlEnum.QTY.getValue().equals(contCtrl) && !ExcuteControlEnum.AMOUNT_QTY.getValue().equals(contCtrl) && !ExcuteControlEnum.AMOUNT_QTY_PRICE.getValue().equals(contCtrl)) continue;
            boolean billClose = true;
            if (billEntry != null && !billEntry.isEmpty()) {
                int size = billEntry.size();
                for (int i = 0; i < size; ++i) {
                    DynamicObject row = (DynamicObject)billEntry.get(i);
                    DynamicObject xRow = (DynamicObject)xBillEntryMap.get((Long)row.getPkValue());
                    if (xRow == null) continue;
                    String changeType = xRow.getString("billentrychangetype");
                    Boolean rowCancel = XContractHelper.isRowCancel(xBills[0].getDataEntityType().getName());
                    if (ChangeTypeEnum.CANCEL.getValue().equals(changeType) && (!ChangeTypeEnum.CANCEL.getValue().equals(changeType) || !rowCancel.booleanValue())) continue;
                    BigDecimal xBaseQty = xRow.getBigDecimal("baseqty");
                    BigDecimal orderBaseQty = row.getBigDecimal("orderbaseqty");
                    BigDecimal baseQty = row.getBigDecimal("baseqty");
                    if (orderBaseQty == null || baseQty == null || xBaseQty == null) continue;
                    if (orderBaseQty.compareTo(xBaseQty) >= 0) {
                        row.set("rowclosestatus", (Object)BizCloseStatusEnum.CLOSE.getValue());
                        continue;
                    }
                    String rowCloseStatus = row.getString("rowclosestatus");
                    if (BizCloseStatusEnum.UNCLOSE.getValue().equals(rowCloseStatus)) {
                        row.set("rowclosestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
                        billClose = false;
                        continue;
                    }
                    if (orderBaseQty.compareTo(baseQty) >= 0) {
                        row.set("rowclosestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
                        billClose = false;
                        continue;
                    }
                    row.set("rowclosestatus", (Object)BizCloseStatusEnum.CLOSE.getValue());
                }
            }
            if (billClose && !hasNewRowBill.contains((Long)srcBill.getPkValue())) {
                srcBill.set("closestatus", (Object)BizCloseStatusEnum.CLOSE.getValue());
                srcBill.set("closer", (Object)UserServiceHelper.getCurrentUserId());
                srcBill.set("closedate", (Object)TimeServiceHelper.now());
                continue;
            }
            srcBill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
            srcBill.set("closer", null);
            srcBill.set("closedate", null);
        }
        return true;
    }
}

