/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.io.IOException;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.AttachmentDto;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.util.StringUtils;

public class AttachmentsHelper {
    private static final Log log = LogFactory.getLog(AttachmentsHelper.class);

    public static void removeAttachments(String targetFormId, Object targetPkId, String tarAttachKey) {
        if (StringUtils.isEmpty((String)targetFormId) || targetPkId == null || StringUtils.isEmpty((String)tarAttachKey)) {
            return;
        }
        List tgtAttachments = AttachmentServiceHelper.getAttachments((String)targetFormId, (Object)targetPkId, (String)tarAttachKey);
        if (tgtAttachments == null || tgtAttachments.isEmpty()) {
            return;
        }
        for (Map attachItem : tgtAttachments) {
            AttachmentServiceHelper.remove((String)targetFormId, (Object)targetPkId, attachItem.get("uid"));
        }
    }

    public static void copyAttachments(String srcFormId, Object srcPkId, String srcAttachKey, String targetFormId, Object targetPkId, String tarAttachKey) {
        if (StringUtils.isEmpty((String)srcFormId) || srcPkId == null || StringUtils.isEmpty((String)srcAttachKey) || StringUtils.isEmpty((String)targetFormId) || targetPkId == null || StringUtils.isEmpty((String)tarAttachKey)) {
            return;
        }
        InputStream inputStream = null;
        log.info("AttachmentsHelper:\u5f00\u59cb\u62f7\u8d1d\u9644\u4ef6");
        try {
            List attachments = AttachmentServiceHelper.getAttachments((String)srcFormId, (Object)srcPkId, (String)srcAttachKey);
            if (attachments == null || attachments.isEmpty()) {
                return;
            }
            long[] uidList = DB.genLongIds((String)"bos_attachment", (int)attachments.size());
            int count = 0;
            for (Map attachItem : attachments) {
                String name;
                MainEntityType dataEntityType;
                String appId;
                DynamicObject obj = AttachmentServiceHelper.getAttCreatorByUID((String)((String)attachItem.get("uid")));
                AttachmentDto attachmentDto = AttachmentServiceHelper.getAttachmentInfoByAttPk((Object)obj.getPkValue());
                String resourcePath = attachmentDto.getResourcePath();
                TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                FileService fs = FileServiceFactory.getAttachmentFileService();
                inputStream = fs.getInputStream(resourcePath);
                String tempUrl = cache.saveAsUrl((String)attachItem.get("name"), inputStream, 7200);
                if (StringUtils.isEmpty((String)tempUrl)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u5b58\u50a8\u7f13\u5b58\u5931\u8d25\u3002", (String)"AttachmentsHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]));
                }
                String path = AttachmentServiceHelper.saveTempToFileService((String)(tempUrl = EncreptSessionUtils.encryptSession((String)tempUrl)), (String)(appId = (dataEntityType = MetadataServiceHelper.getDataEntityType((String)targetFormId)).getAppId()), (String)targetFormId, (Object)targetPkId, (String)(name = (String)attachItem.get("name")));
                if (StringUtils.isEmpty((String)path)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\u5931\u8d25\u3002", (String)"AttachmentsHelper_1", (String)"scmc-conm-business", (Object[])new Object[0]));
                }
                attachItem.put("uid", "rc-upload-" + uidList[count++]);
                attachItem.put("url", path);
                attachItem.put("lastModified", AttachmentsHelper.getTime());
            }
            AttachmentServiceHelper.upload((String)targetFormId, (Object)targetPkId, (String)tarAttachKey, (List)attachments);
            log.info("AttachmentsHelper:\u7ef4\u62a4\u9644\u4ef6\u548c\u6587\u4ef6\u7684\u5173\u7cfb\uff0c\u9644\u4ef6\u62f7\u8d1d\u5b8c\u6bd5");
        }
        catch (Exception e) {
            log.error("AttachmentsHelper:\u62f7\u8d1d\u6587\u4ef6\u9519\u8bef\uff1a" + e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)"\u9644\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668\u5931\u8d25\u3002", (String)"AttachmentsHelper_1", (String)"scmc-conm-business", (Object[])new Object[0]));
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error("AttachmentsHelper:\u8f93\u5165\u6d41\u5173\u95ed\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
        }
    }

    private static long getTime() {
        return new Date().getTime();
    }
}

