/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.org.model.OrgRelationParam;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.mpscmm.msbd.business.helper.AmountPlanHelper;
import kd.mpscmm.msbd.common.context.CommonContext;
import kd.scmc.conm.business.helper.AmountHelper;
import kd.scmc.conm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.conm.business.helper.BillTypeParameterHelper;
import kd.scmc.conm.business.helper.CurrencyHelper;
import kd.scmc.conm.business.helper.CustomerHelper;
import kd.scmc.conm.business.helper.SupplierHelper;
import kd.scmc.conm.enums.BizReviewStatusEnum;
import kd.scmc.conm.enums.BizSignStatusEnum;
import kd.scmc.conm.enums.EnableStatusEnum;
import kd.scmc.conm.enums.FilingStatusEnum;

public class BillBotpHelper {
    @Deprecated
    public static void purContractDefValue(List<DynamicObject> bills) {
        if (bills == null || bills.isEmpty()) {
            return;
        }
        CommonContext context = AmountHelper.getContext();
        bills.forEach(bill -> {
            BillBotpHelper.contractHeadDefValue(bill);
            BillBotpHelper.setPurConparties(bill);
            BillBotpHelper.setSupplierInfo(bill);
            BillBotpHelper.setSettletype(bill, "supplier");
            BillBotpHelper.setOperatorGrp(bill, "CGZ");
            BillBotpHelper.setDept(bill);
            BillBotpHelper.setEntry(bill);
            DynamicObject type = bill.getDynamicObject("type");
            DynamicObjectCollection payentrys = bill.getDynamicObjectCollection("payentry");
            for (DynamicObject entry : payentrys) {
                Boolean isprepay = entry.getBoolean("isprepay");
                String pretimepoint = entry.getString("pretimepoint");
                if (isprepay != null && isprepay.booleanValue()) {
                    if (!StringUtils.isEmpty((String)pretimepoint) || type == null || StringUtils.isEmpty((String)type.getString("pretimepoint"))) continue;
                    entry.set("pretimepoint", (Object)type.getString("pretimepoint"));
                    continue;
                }
                entry.set("pretimepoint", (Object)"");
            }
            AmountPlanHelper.calAmountPlanForDynamicObject((CommonContext)context, (DynamicObject)bill);
        });
    }

    @Deprecated
    public static void salContractDefValue(List<DynamicObject> bills) {
        if (bills == null || bills.isEmpty()) {
            return;
        }
        CommonContext context = AmountHelper.getContext();
        bills.forEach(bill -> {
            BillBotpHelper.contractHeadDefValue(bill);
            BillBotpHelper.setSalConparties(bill);
            BillBotpHelper.setCustomerInfo(bill);
            BillBotpHelper.setSettletype(bill, "customer");
            BillBotpHelper.setOperatorGrp(bill, "XSZ");
            BillBotpHelper.setDept(bill);
            BillBotpHelper.setEntry(bill);
            BillBotpHelper.setSalEntry(bill);
            AmountPlanHelper.calAmountPlanForDynamicObject((CommonContext)context, (DynamicObject)bill);
        });
    }

    private static void setOperatorGrp(DynamicObject bill, String grptype) {
        QFilter qFilter04;
        QFilter qFilter03;
        QFilter qFilter02;
        QFilter qFilter01;
        DynamicObject[] operators;
        QFilter qFilter3;
        QFilter qFilter2;
        DynamicObject operator = bill.getDynamicObject("operator");
        DynamicObject operatorGroup = bill.getDynamicObject("operatorgroup");
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null || operator != null && operatorGroup != null) {
            return;
        }
        QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)"bd_operatorgroup", (Long)((Long)org.getPkValue()));
        Map operatorGroupDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"bd_operatorgroup", (QFilter[])new QFilter[]{qFilter1, qFilter2 = new QFilter("operatorgrouptype", "=", (Object)grptype), qFilter3 = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue())});
        if (operatorGroupDynamicObjectMap != null && operatorGroupDynamicObjectMap.size() > 0 && (operators = BusinessDataServiceHelper.load((String)"bd_operator", (String)"operatorid,operatornumber,operatorname,operatorgrpid,opergrpnumber,opergrpname,opergrptype,invalid", (QFilter[])new QFilter[]{qFilter01 = new QFilter("operatorgrpid", "in", operatorGroupDynamicObjectMap.keySet()), qFilter02 = new QFilter("opergrptype", "=", (Object)grptype), qFilter03 = new QFilter("operatorid", "=", (Object)UserServiceHelper.getCurrentUserId()), qFilter04 = new QFilter("invalid", "=", (Object)Boolean.FALSE)})) != null && operators.length > 0 && operators[0] != null) {
            bill.set("operator", (Object)operators[0]);
            bill.set("operatorgroup", operatorGroupDynamicObjectMap.get(operators[0].get("operatorgrpid")));
        }
    }

    private static void setDept(DynamicObject bill) {
        DynamicObject dept = bill.getDynamicObject("dept");
        DynamicObject operator = bill.getDynamicObject("operator");
        if (dept != null) {
            return;
        }
        if (operator == null) {
            return;
        }
        DynamicObject user = (DynamicObject)operator.get("operatorid");
        if (user == null) {
            return;
        }
        Long deptId = UserServiceHelper.getUserMainOrgId((long)((Long)user.getPkValue()));
        dept = BusinessDataServiceHelper.loadSingle((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)deptId)});
        bill.set("dept", (Object)dept);
    }

    private static void contractHeadDefValue(DynamicObject bill) {
        Date biztime;
        QFilter enableQF;
        QFilter isdefaultQF;
        QFilter contcategoryQF;
        Map contType;
        Optional type;
        MainEntityType entityType = (MainEntityType)bill.getDataEntityType();
        Long billTypeID = (Long)bill.get("billtype.id");
        DynamicObject category = null;
        if (bill.getDynamicObject("category") == null) {
            category = (DynamicObject)BillTypeParameterHelper.getBillTypeParameterValue(entityType, billTypeID, "category");
            bill.set("category", (Object)category);
        }
        if (bill.getDynamicObject("type") == null && category != null && (type = (contType = BusinessDataServiceHelper.loadFromCache((String)"conm_type", (String)"conmprop,activesign,activereview,activearchive,pretimepoint", (QFilter[])new QFilter[]{contcategoryQF = new QFilter("contcategory", "=", category.getPkValue()), isdefaultQF = new QFilter("isdefault", "=", (Object)Boolean.TRUE), enableQF = new QFilter("enable", "=", (Object)"1")})).values().stream().findFirst()).isPresent()) {
            bill.set("type", type.get());
            bill.set("conmprop", (Object)((DynamicObject)type.get()).getString("conmprop"));
        }
        Map<String, Object> res4P = CurrencyHelper.get4P(bill);
        bill.set("currency", res4P.get("currency"));
        bill.set("settlecurrency", res4P.get("settlecurrency"));
        bill.set("exratetable", res4P.get("exratetable"));
        bill.set("exratedate", res4P.get("exratedate"));
        bill.set("exchangerate", res4P.get("exchangerate"));
        bill.set("exchangetype", res4P.get("exchangetype"));
        BillBotpHelper.setConmType(bill);
        DynamicObject type2 = bill.getDynamicObject("type");
        if (type2 != null) {
            bill.set("conmprop", (Object)type2.getString("conmprop"));
        }
        if ((biztime = bill.getDate("biztime")) == null) {
            bill.set("biztime", (Object)TimeServiceHelper.now());
        }
    }

    private static void setConmType(DynamicObject bill) {
        DynamicObject type = bill.getDynamicObject("type");
        if (type != null) {
            bill.set("signstatus", (Object)(type.getBoolean("activesign") ? BizSignStatusEnum.UNSIGN.getValue() : BizSignStatusEnum.INACTIVE.getValue()));
            bill.set("reviewstatus", (Object)(type.getBoolean("activereview") ? BizReviewStatusEnum.UNREVIEW.getValue() : BizReviewStatusEnum.INACTIVE.getValue()));
            bill.set("filingstatus", (Object)(type.getBoolean("activearchive") ? FilingStatusEnum.UNFILED.getValue() : FilingStatusEnum.INACTIVE.getValue()));
        }
    }

    private static void setSupplierInfo(DynamicObject bill) {
        DynamicObject supplier = bill.getDynamicObject("supplier");
        if (supplier == null) {
            return;
        }
        DynamicObject providerSupplier = bill.getDynamicObject("providersupplier");
        if (providerSupplier == null) {
            bill.set("providersupplier", (Object)SupplierHelper.getSupplierOriginal(supplier, "deliversupplierid"));
        }
        if ((providerSupplier = bill.getDynamicObject("providersupplier")) != null) {
            if (StringUtils.isEmpty((String)bill.getString("providerlinkman"))) {
                bill.set("providerlinkman", (Object)SupplierHelper.getLinkmanObject(providerSupplier));
            }
            if (StringUtils.isEmpty((String)bill.getString("provideraddress"))) {
                bill.set("provideraddress", (Object)SupplierHelper.getAddress(providerSupplier));
            }
        }
        if (bill.getDynamicObject("invoicesupplier") == null) {
            bill.set("invoicesupplier", (Object)SupplierHelper.getSupplierOriginal(supplier, "invoicesupplierid"));
        }
        if (bill.getDynamicObject("receivesupplier") == null) {
            bill.set("receivesupplier", (Object)SupplierHelper.getSupplierOriginal(supplier, "receivingsupplierid"));
        }
        if (bill.getString("party2nd") == null || StringUtils.isEmpty((String)bill.getString("party2nd"))) {
            String party2nd = supplier.getLocaleString("name").getLocaleValue();
            bill.set("party2nd", (Object)party2nd);
        }
        if (bill.getString("contactperson2nd") == null || StringUtils.isEmpty((String)bill.getString("contactperson2nd"))) {
            String linkman = supplier.getLocaleString("linkman").getLocaleValue();
            bill.set("contactperson2nd", (Object)linkman);
        }
        if (bill.getString("phone2nd") == null || StringUtils.isEmpty((String)bill.getString("phone2nd"))) {
            String bizpartner_phone = supplier.getString("bizpartner_phone");
            bill.set("phone2nd", (Object)bizpartner_phone);
        }
    }

    private static void setCustomerInfo(DynamicObject bill) {
        DynamicObject customer = bill.getDynamicObject("customer");
        if (customer == null) {
            return;
        }
        DynamicObject reccustomer = bill.getDynamicObject("reccustomer");
        if (reccustomer == null) {
            bill.set("reccustomer", (Object)CustomerHelper.getCustomerOriginal(customer, "delivercustomerid"));
        }
        if ((reccustomer = bill.getDynamicObject("reccustomer")) != null) {
            if (StringUtils.isEmpty((String)bill.getString("reclinkman"))) {
                bill.set("reclinkman", (Object)CustomerHelper.getLinkmanObject(reccustomer));
            }
            if (StringUtils.isEmpty((String)bill.getString("receiveaddress"))) {
                bill.set("receiveaddress", (Object)CustomerHelper.getAddress(reccustomer));
            }
        }
        if (bill.getDynamicObject("payingcustomer") == null) {
            bill.set("payingcustomer", (Object)CustomerHelper.getCustomerOriginal(customer, "paymentcustomerid"));
        }
        if (bill.getDynamicObject("settlecustomer") == null) {
            bill.set("settlecustomer", (Object)CustomerHelper.getCustomerOriginal(customer, "invoicecustomerid"));
        }
        if (bill.getString("party1st") == null || StringUtils.isEmpty((String)bill.getString("party1st"))) {
            bill.set("party1st", (Object)customer.getLocaleString("name"));
        }
        if (bill.getString("contactperson1st") == null || StringUtils.isEmpty((String)bill.getString("contactperson1st"))) {
            bill.set("contactperson1st", (Object)customer.getString("linkman"));
        }
        if (bill.getString("phone1st") == null || StringUtils.isEmpty((String)bill.getString("phone1st"))) {
            bill.set("phone1st", customer.get("bizpartner_phone"));
        }
    }

    private static void setSettletype(DynamicObject bill, String clientType) {
        if (bill.getDynamicObject("settletype") == null) {
            bill.set("settletype", (Object)CurrencyHelper.getSettletype(bill.getDynamicObject(clientType)));
        }
    }

    private static void setPurConparties(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject contParties = bill.getDynamicObject("contparties");
        if (contParties == null) {
            contParties = BillBotpHelper.loadContParties(org);
            if (contParties == null) {
                return;
            }
            bill.set("contparties", (Object)contParties);
        }
        if (StringUtils.isEmpty((String)bill.getString("party1st")) || bill.getString("party1st") == null) {
            String party1st = contParties.getLocaleString("name").getLocaleValue();
            bill.set("party1st", (Object)party1st);
        }
        if (StringUtils.isEmpty((String)bill.getString("contactperson1st")) || bill.getString("contactperson1st") == null) {
            String contacts = contParties.getString("contacts");
            bill.set("contactperson1st", (Object)contacts);
        }
        if (StringUtils.isEmpty((String)bill.getString("phone1st")) || bill.getString("phone1st") == null) {
            String phone = contParties.getString("phone");
            bill.set("phone1st", (Object)phone);
        }
    }

    private static void setSalConparties(DynamicObject bill) {
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return;
        }
        DynamicObject contParties = bill.getDynamicObject("contparties");
        if (contParties == null) {
            contParties = BillBotpHelper.loadContParties(org);
            if (contParties == null) {
                return;
            }
            bill.set("contparties", (Object)contParties);
        }
        if (StringUtils.isEmpty((String)bill.getString("party2nd")) || bill.getString("party2nd") == null) {
            String party1st = contParties.getLocaleString("name").getLocaleValue();
            bill.set("party2nd", (Object)party1st);
        }
        if (StringUtils.isEmpty((String)bill.getString("contactperson2nd")) || bill.getString("contactperson2nd") == null) {
            String contacts = contParties.getString("contacts");
            bill.set("contactperson2nd", (Object)contacts);
        }
        if (StringUtils.isEmpty((String)bill.getString("phone2nd")) || bill.getString("phone2nd") == null) {
            String phone = contParties.getString("phone");
            bill.set("phone2nd", (Object)phone);
        }
    }

    private static void setSalEntry(DynamicObject bill) {
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject row : entry) {
            DynamicObject material;
            if (row.getDynamicObject("productline") != null || (material = row.getDynamicObject("material")) == null || material.getDynamicObject("masterid") == null) continue;
            DynamicObject productLine = material.getDynamicObject("masterid").getDynamicObject("productline");
            row.set("productline", (Object)productLine);
        }
    }

    private static void setEntry(DynamicObject bill) {
        BigDecimal allAmount = BigDecimal.ZERO;
        BigDecimal allAmountAndTax = BigDecimal.ZERO;
        BigDecimal allTaxAmount = BigDecimal.ZERO;
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject row : entry) {
            DynamicObject material = row.getDynamicObject("material");
            DynamicObject masterMaterial = row.getDynamicObject("materialmasterid");
            if (masterMaterial == null) {
                DynamicObject masterid = (DynamicObject)BillBotpHelper.getMatPropValue(material, "masterid");
                row.set("materialmasterid", (Object)masterid);
            }
            Map<String, BigDecimal> amountMap = AmountHelper.getAmount(bill, row);
            BigDecimal amount = amountMap.get("amount");
            BigDecimal taxAmount = amountMap.get("taxamount");
            BigDecimal amountAndTax = amountMap.get("amountandtax");
            allAmount = allAmount.add(amount);
            allAmountAndTax = allAmountAndTax.add(amountAndTax);
            allTaxAmount = allTaxAmount.add(taxAmount);
            BillBotpHelper.setEntryRow(bill, row, amountMap);
        }
        Boolean isEntrySumAmt = bill.getBoolean("isentrysumamt");
        if (isEntrySumAmt.booleanValue()) {
            bill.set("totalallamount", (Object)allAmountAndTax);
            bill.set("totalamount", (Object)allAmount);
            bill.set("totaltaxamount", (Object)allTaxAmount);
        }
    }

    private static void setEntryRow(DynamicObject bill, DynamicObject row, Map<String, BigDecimal> amountMap) {
        DynamicObject entryreqorg;
        DynamicProperty entryReqOrgProp;
        DynamicObject entryinvorg;
        DynamicObject settleOrg;
        DynamicObject materialInfo;
        BigDecimal baseQty;
        BigDecimal amount = amountMap.get("amount");
        BigDecimal taxAmount = amountMap.get("taxamount");
        BigDecimal amountAndTax = amountMap.get("amountandtax");
        row.set("amount", (Object)amount);
        row.set("taxamount", (Object)taxAmount);
        row.set("amountandtax", (Object)amountAndTax);
        row.set("price", (Object)amountMap.get("price"));
        row.set("priceandtax", (Object)amountMap.get("priceandtax"));
        row.set("discountamount", (Object)amountMap.get("discountamount"));
        row.set("curamount", (Object)amountMap.get("curamount"));
        row.set("curtaxamount", (Object)amountMap.get("curtaxamount"));
        row.set("curamountandtax", (Object)amountMap.get("curamountandtax"));
        DynamicObject baseUnit = row.getDynamicObject("baseunit");
        if (baseUnit == null) {
            baseUnit = row.getDynamicObject("material.masterid.baseunit");
            row.set("baseunit", (Object)baseUnit);
        }
        if ((baseQty = row.getBigDecimal("baseqty")) == null || baseQty.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal qty = row.getBigDecimal("qty");
            DynamicObject unit = row.getDynamicObject("unit");
            DynamicObject masterid = row.getDynamicObject("material.masterid");
            baseQty = BillQtyAndUnitHelper.getDesQtyConv(masterid, unit, qty, baseUnit);
            row.set("baseqty", (Object)baseQty);
        }
        if ((materialInfo = row.getDynamicObject("material")) != null) {
            DynamicObject auxUnit;
            if (row.get("auxunit") == null) {
                auxUnit = materialInfo.getDynamicObject("masterid.auxptyunit");
                row.set("auxunit", (Object)auxUnit);
            }
            if (row.getBigDecimal("auxqty").compareTo(BigDecimal.ZERO) == 0) {
                auxUnit = row.getDynamicObject("auxunit");
                row.set("auxqty", (Object)BillQtyAndUnitHelper.getAuxQty(materialInfo, auxUnit, baseUnit, baseQty));
            }
        }
        if ((settleOrg = row.getDynamicObject("entrysettleorg")) == null) {
            Long defaultOrgId = null;
            String entityName = bill.getDataEntityType().getName();
            DynamicObject org = bill.getDynamicObject("org");
            if ("conm_purcontract".equals(entityName)) {
                defaultOrgId = BillBotpHelper.getOrgRelationParam((Long)org.getPkValue(), "02", "10", "toorg");
            } else if ("conm_salcontract".equals(entityName)) {
                defaultOrgId = BillBotpHelper.getOrgRelationParam((Long)org.getPkValue(), "03", "10", "toorg");
            }
            if (defaultOrgId != null) {
                row.set("entrysettleorg", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)defaultOrgId, (String)"bos_org"));
            }
        }
        if ((entryinvorg = row.getDynamicObject("entryinvorg")) == null) {
            Long entryinvorgId = null;
            String entityName = bill.getDataEntityType().getName();
            DynamicObject org = bill.getDynamicObject("org");
            if ("conm_purcontract".equals(entityName)) {
                entryinvorgId = BillBotpHelper.getOrgRelationParam((Long)org.getPkValue(), "02", "05", "toorg");
            } else if ("conm_salcontract".equals(entityName)) {
                entryinvorgId = BillBotpHelper.getOrgRelationParam((Long)org.getPkValue(), "03", "05", "toorg");
            }
            if (entryinvorgId != null) {
                row.set("entryinvorg", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)entryinvorgId, (String)"bos_org"));
            }
        }
        if ((entryReqOrgProp = row.getDynamicObjectType().getProperty("entryreqorg")) != null && (entryreqorg = row.getDynamicObject("entryreqorg")) == null) {
            Long entryreqorgId = null;
            String entityName = bill.getDataEntityType().getName();
            DynamicObject org = bill.getDynamicObject("org");
            if ("conm_purcontract".equals(entityName)) {
                entryreqorgId = BillBotpHelper.getOrgRelationParam((Long)org.getPkValue(), null, "02", "fromorg");
            } else if ("conm_salcontract".equals(entityName)) {
                entryreqorgId = BillBotpHelper.getOrgRelationParam((Long)org.getPkValue(), null, "03", "fromorg");
            }
            if (entryreqorgId != null) {
                row.set("entryreqorg", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)entryreqorgId, (String)"bos_org"));
            }
        }
    }

    private static DynamicObject getToOrg(String fromOrgType, String toOrgType, Long fromOrgId) {
        Long toOrgId = OrgUnitServiceHelper.getToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId);
        return BusinessDataServiceHelper.loadSingleFromCache((Object)toOrgId, (String)"bos_org");
    }

    public static Long getToOrg(String fromOrgType, String toOrgType, Long fromOrgId, boolean isIncludeFromOrgSelf) {
        Long toOrgId = OrgUnitServiceHelper.getToOrg((String)fromOrgType, (String)toOrgType, (Long)fromOrgId, (boolean)isIncludeFromOrgSelf);
        return toOrgId;
    }

    public static Long getOrgRelationParam(Long org, String fromViewType, String orgViewType, String directViewType) {
        OrgRelationParam param = new OrgRelationParam();
        param.setOrgId(org.longValue());
        param.setFromViewType(fromViewType);
        param.setToViewType(orgViewType);
        if ("fromorg".equals(directViewType)) {
            param.setDirectViewType("fromorg");
        } else if ("toorg".equals(directViewType)) {
            param.setDirectViewType("toorg");
        }
        return OrgUnitServiceHelper.getOrgForFormDefValue((OrgRelationParam)param);
    }

    private static DynamicObject getCompanyByOrg(DynamicObject org, Boolean isBizUnit, Boolean isSerrchUpward) {
        if (org == null || org.getPkValue() == null) {
            return null;
        }
        Map map = OrgUnitServiceHelper.getCompanyByOrg((Long)((Long)org.getPkValue()), (Boolean)isBizUnit, (Boolean)isSerrchUpward);
        if (map == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingleFromCache(map.get("id"), (String)"bos_org");
    }

    private static Object getMatPropValue(DynamicObject material, String key) {
        if (material == null) {
            return null;
        }
        String tyepName = material.getDataEntityType().getName();
        if ("masterid".equals(key)) {
            return "bd_material".equals(tyepName) ? material : material.get("masterid");
        }
        return "bd_material".equals(tyepName) ? material.get(key) : material.get("masterid." + key);
    }

    private static DynamicObject loadContParties(DynamicObject org) {
        if (org == null) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("org.id", "=", org.getPkValue()), new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"conm_contparties", (QFilter[])filters);
    }
}

