/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BillQtyAndUnitHelper {
    private static final String UNIT_PRECISION = "precision";
    private static final String UNIT_PRECISIONTYPE = "precisionaccount";
    private static final String UnitConvertDir_UINV_U2ND = "A";
    private static final String UnitConvertDir_U2ND_UINV = "B";
    private static final String UnitConvertDir_UINVANDU2ND = "C";
    private static final String UnitConvertDir_NONE = "D";

    @Deprecated
    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = null;
        if (materialId == null || srcUnitId == null || desUnitId == null) {
            unitRate = BigDecimal.ZERO;
        } else if (srcUnitId.longValue() == desUnitId.longValue()) {
            unitRate = BigDecimal.ONE;
        } else {
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
            if (muConv != null && muConv.getInt("numerator") != 0) {
                unitRate = new BigDecimal(muConv.getInt("numerator")).divide(new BigDecimal(muConv.getInt("denominator")), 10, 4);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ZERO;
        }
        return unitRate;
    }

    public static BigDecimal getDesQtyConv(DynamicObject material, DynamicObject srcUnit, BigDecimal srcQty, DynamicObject desUnit) {
        if (material != null && srcUnit != null && desUnit != null && srcQty != null && srcQty.compareTo(BigDecimal.ZERO) != 0) {
            if (srcUnit.getPkValue().equals(desUnit.getPkValue())) {
                return srcQty;
            }
            DynamicObject muConv = BaseDataServiceHelper.getMUConv((Long)((Long)material.getPkValue()), (Long)((Long)srcUnit.getPkValue()), (Long)((Long)desUnit.getPkValue()));
            if (muConv != null && muConv.getInt("denominator") != 0) {
                int precision = desUnit.getInt(UNIT_PRECISION);
                return srcQty.multiply(new BigDecimal(muConv.getInt("numerator"))).divide(new BigDecimal(muConv.getInt("denominator")), precision, BillQtyAndUnitHelper.getRoundMode(desUnit));
            }
        }
        return BigDecimal.ZERO;
    }

    public static int getRoundMode(DynamicObject unit) {
        String precisionaccount = unit.getString(UNIT_PRECISIONTYPE);
        int baseUnitPrecisionType = 4;
        if ("2".equals(precisionaccount)) {
            baseUnitPrecisionType = 1;
        } else if ("3".equals(precisionaccount)) {
            baseUnitPrecisionType = 0;
        }
        return baseUnitPrecisionType;
    }

    public static void setAuxBizQtyAndUnit(IDataModel bill, int rowIndex, String fieldName) {
        DynamicObject materialInfo = (DynamicObject)bill.getValue("material", rowIndex);
        if (materialInfo == null) {
            return;
        }
        DynamicObject auxptyUnit = (DynamicObject)bill.getValue("auxunit", rowIndex);
        if (auxptyUnit == null) {
            return;
        }
        BigDecimal baseQty = (BigDecimal)bill.getValue("baseqty", rowIndex);
        BigDecimal auxQty = (BigDecimal)bill.getValue("auxqty", rowIndex);
        DynamicObject unit = (DynamicObject)bill.getValue("unit", rowIndex);
        DynamicObject baseUnit = (DynamicObject)bill.getValue("baseunit", rowIndex);
        String unitConvertDir = materialInfo.getString("masterid.unitconvertdir");
        if (UnitConvertDir_NONE.equals(unitConvertDir)) {
            return;
        }
        switch (fieldName) {
            case "baseqty": {
                if (!UnitConvertDir_UINV_U2ND.equals(unitConvertDir) && !UnitConvertDir_UINVANDU2ND.equals(unitConvertDir)) break;
                bill.beginInit();
                auxQty = BillQtyAndUnitHelper.getDesQtyConv(materialInfo.getDynamicObject("masterid"), baseUnit, baseQty, auxptyUnit);
                bill.setValue("auxqty", (Object)auxQty, rowIndex);
                bill.endInit();
                break;
            }
            case "auxqty": {
                if (!UnitConvertDir_U2ND_UINV.equals(unitConvertDir) && !UnitConvertDir_UINVANDU2ND.equals(unitConvertDir)) break;
                baseQty = BillQtyAndUnitHelper.getDesQtyConv(materialInfo.getDynamicObject("masterid"), auxptyUnit, auxQty, baseUnit);
                BigDecimal qty = BillQtyAndUnitHelper.getDesQtyConv(materialInfo.getDynamicObject("masterid"), baseUnit, baseQty, unit);
                bill.beginInit();
                bill.setValue("baseqty", (Object)baseQty, rowIndex);
                bill.setValue("qty", (Object)qty, rowIndex);
                bill.endInit();
                break;
            }
        }
    }

    public static BigDecimal getAuxQty(DynamicObject materialInfo, DynamicObject auxptyUnit, DynamicObject baseUnit, BigDecimal baseQty) {
        if (materialInfo == null || auxptyUnit == null || baseUnit == null) {
            return null;
        }
        if (baseQty == null) {
            return BigDecimal.ZERO;
        }
        String unitConvertDir = materialInfo.getString("masterid.unitconvertdir");
        if (UnitConvertDir_NONE.equals(unitConvertDir)) {
            return null;
        }
        if (UnitConvertDir_UINV_U2ND.equals(unitConvertDir) || UnitConvertDir_UINVANDU2ND.equals(unitConvertDir)) {
            return BillQtyAndUnitHelper.getDesQtyConv(materialInfo.getDynamicObject("masterid"), baseUnit, baseQty, auxptyUnit);
        }
        return null;
    }
}

