/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mpscmm.msbd.business.helper.BillTypeHelper;
import kd.mpscmm.msbd.common.utils.BigDecimalUtil;
import kd.scmc.conm.business.helper.AmountHelper;
import kd.scmc.conm.business.helper.BillQtyAndUnitHelper;
import kd.scmc.conm.business.helper.BillTypeParameterHelper;
import kd.scmc.conm.business.helper.CurrencyHelper;
import kd.scmc.conm.enums.BizCancelStatusEnum;
import kd.scmc.conm.enums.BizCloseStatusEnum;
import kd.scmc.conm.enums.BizFreezeStatusEnum;
import kd.scmc.conm.enums.BizReviewStatusEnum;
import kd.scmc.conm.enums.BizRowTerminateStatusEnum;
import kd.scmc.conm.enums.BizSignStatusEnum;
import kd.scmc.conm.enums.BizTerminateStatusEnum;
import kd.scmc.conm.enums.BizValidStatusEnum;
import kd.scmc.conm.enums.ChangeTypeEnum;
import kd.scmc.conm.enums.ContractBizModeEnum;
import kd.scmc.conm.enums.ContractSuitScopeEnum;
import kd.scmc.conm.enums.DiscountTypeEnum;
import kd.scmc.conm.enums.EnableStatusEnum;
import kd.scmc.conm.enums.ExChangeTypeEnum;
import kd.scmc.conm.enums.FilingStatusEnum;
import kd.scmc.conm.enums.StatusEnum;
import kd.scmc.conm.utils.CommonUtils;

public class BillTplHelper {
    private static final Log log = LogFactory.getLog(BillTplHelper.class);
    private static final BigDecimal ZERO = BigDecimal.ZERO;
    private static final BigDecimal ONE = BigDecimal.ONE;
    private static final BigDecimal HUNDRED = new BigDecimal(100);
    private static final String VERSION = "1";
    private static final String UnitConvertDir_UINV_U2ND = "A";
    private static final String UnitConvertDir_U2ND_UINV = "B";
    private static final String UnitConvertDir_UINVANDU2ND = "C";

    public static List<DynamicObject> completeBillInfo(List<DynamicObject> bills) {
        if (CommonUtils.isNull(bills)) {
            return bills;
        }
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>(10);
        HashMap<String, Object> cacheMap = new HashMap<String, Object>(8);
        for (DynamicObject bill : bills) {
            DynamicObject org;
            if (bill == null || (org = bill.getDynamicObject("org")) == null) continue;
            DynamicObject billType = bill.getDynamicObject("billtype");
            if (billType == null) {
                String entityName = "";
                if ("conm_purcontract".equals(bill.getDataEntityType().getName())) {
                    entityName = "conm_purcontract";
                }
                if ("conm_salcontract".equals(bill.getDataEntityType().getName())) {
                    entityName = "conm_salcontract";
                }
                if ((billType = BillTypeHelper.getDefaultBillTypeObject((String)entityName)) == null) continue;
                bill.set("billtype", (Object)billType);
            }
            BillTplHelper.setDefaultHeadStatus(bill, cacheMap);
            BillTplHelper.setDefaultBaseInfo(bill, cacheMap);
            BillTplHelper.setDefaultFinancialInfo(bill);
            BillTplHelper.setDefaultFinanceInfo(bill);
            BillTplHelper.setBillentrys(bill);
            BillTplHelper.setBillTerms(bill);
            result.add(bill);
        }
        return result;
    }

    private static void setBillTerms(DynamicObject bill) {
        DynamicObjectCollection termEntrys = bill.getDynamicObjectCollection("termentry");
        for (DynamicObject entry : termEntrys) {
            DynamicObject termGroup;
            DynamicObject term = entry.getDynamicObject("term");
            if (term == null) continue;
            entry.set("termentrychangetype", (Object)ChangeTypeEnum.UPDATE.getValue());
            if (entry.getString("termcontent") == null || "".equals(entry.getString("termcontent"))) {
                String termcontent = term.getString("termcontent");
                entry.set("termcontent", (Object)termcontent);
            }
            if ((termGroup = entry.getDynamicObject("termgroup")) != null) continue;
            entry.set("termgroup", (Object)term.getDynamicObject("group"));
        }
    }

    private static void setDefaultBaseInfo(DynamicObject bill, Map<String, Object> cacheMap) {
        DynamicObject billtype;
        DynamicObject category;
        String bizMode;
        DynamicObject type;
        String billStatus = bill.getString("billstatus");
        MainEntityType entityType = (MainEntityType)bill.getDataEntityType();
        String version = bill.getString("version");
        if (version == null || StatusEnum.SAVE.getValue().equals(billStatus) || StatusEnum.SUBMIT.getValue().equals(billStatus)) {
            bill.set("version", (Object)VERSION);
        }
        if ((type = bill.getDynamicObject("type")) != null) {
            bill.set("conmprop", (Object)type.getString("conmprop"));
        }
        if (bill.get("ispayrate") == null) {
            bill.set("ispayrate", (Object)Boolean.FALSE);
        }
        if (CommonUtils.isNull((Object)(bizMode = bill.getString("bizmode")))) {
            bill.set("bizmode", (Object)ContractBizModeEnum.SEPARATENEGO_SUBSIGN.getValue());
        }
        if (ContractBizModeEnum.UNIFIEDNEGO_SUBSIGN.getValue().equals(bizMode) && bill.getString("suitscope") == null) {
            bill.set("suitscope", (Object)ContractSuitScopeEnum.ALLORG.getValue());
        } else if (ContractBizModeEnum.UNIFIEDNEGOANDSIGN.getValue().equals(bizMode) || ContractBizModeEnum.SEPARATENEGO_SUBSIGN.getValue().equals(bizMode)) {
            bill.set("suitscope", (Object)ContractSuitScopeEnum.CURRENTORG.getValue());
        }
        DynamicObjectCollection suitEntrys = bill.getDynamicObjectCollection("suitentry");
        if (!ContractSuitScopeEnum.CHOSENORG.getValue().equals(bill.getString("suitscope"))) {
            suitEntrys.clear();
        }
        if (bill.get("iselecsignature") == null) {
            bill.set("iselecsignature", (Object)Boolean.FALSE);
        }
        if (type != null && !type.getBoolean("activesign")) {
            bill.set("iselecsignature", (Object)Boolean.FALSE);
        }
        if ((category = bill.getDynamicObject("category")) == null && (billtype = bill.getDynamicObject("billtype")) != null) {
            DynamicObject categoryDyn = (DynamicObject)cacheMap.get("import_billtype_category" + billtype.getPkValue());
            if (categoryDyn != null) {
                bill.set("category", (Object)categoryDyn);
            } else {
                DynamicObject billTypeParam = BillTypeParameterHelper.getBillTypeParameter(entityType, (Long)billtype.getPkValue());
                if (billTypeParam != null && (category = billTypeParam.getDynamicObject("category")) != null) {
                    bill.set("category", (Object)category);
                    cacheMap.put("import_billtype_category" + billtype.getPkValue(), category);
                }
            }
        }
        DynamicObject contParties = bill.getDynamicObject("contparties");
        DynamicObject org = bill.getDynamicObject("org");
        if (contParties == null) {
            contParties = BillTplHelper.loadContParties(org);
            if (contParties == null) {
                return;
            }
            bill.set("contparties", (Object)contParties);
        }
    }

    private static void setDefaultFinanceInfo(DynamicObject bill) {
        if (bill.get("isentrysumamt") == null) {
            bill.set("isentrysumamt", (Object)Boolean.TRUE);
        }
    }

    public static void setDefaultHeadStatus(DynamicObject bill, Map<String, Object> cacheMap) {
        Date bizTime;
        DynamicObject currentUserDO = BusinessDataServiceHelper.loadSingleFromCache((Object)UserServiceHelper.getCurrentUserId(), (String)"bos_user");
        if (bill.getString("billstatus") == null) {
            bill.set("billstatus", (Object)StatusEnum.SAVE.getValue());
        }
        if (StatusEnum.SAVE.getValue().equals(bill.get("billstatus")) || StatusEnum.SUBMIT.getValue().equals(bill.get("billstatus"))) {
            bill.set("auditor", (Object)"");
            bill.set("auditdate", (Object)"");
        }
        if (StatusEnum.AUDIT.getValue().equals(bill.get("billstatus"))) {
            if (bill.get("auditor") == null) {
                bill.set("auditor", (Object)currentUserDO);
            }
            if (bill.get("auditdate") == null) {
                bill.set("auditdate", (Object)TimeServiceHelper.now());
            }
        }
        if (kd.mpscmm.msbd.common.utils.CommonUtils.isNull((Object)(bizTime = bill.getDate("biztime")))) {
            bill.set("biztime", (Object)new Date());
        }
        if (bill.getString("validstatus") == null) {
            bill.set("validstatus", (Object)BizValidStatusEnum.UNVALID.getValue());
        }
        if (BizValidStatusEnum.UNVALID.getValue().equals(bill.getString("validstatus"))) {
            bill.set("validdate", (Object)"");
            bill.set("valider", null);
            bill.set("terminatestatus", (Object)BizTerminateStatusEnum.UNTERMINATE.getValue());
            bill.set("terminator", null);
            bill.set("terminatedate", (Object)"");
            bill.set("cancelstatus", (Object)BizCancelStatusEnum.UNCANCEL.getValue());
            bill.set("canceler", null);
            bill.set("canceldate", (Object)"");
            bill.set("freezestatus", (Object)BizFreezeStatusEnum.UNFREEZE.getValue());
            bill.set("freezer", null);
            bill.set("freezedate", (Object)"");
            bill.set("closestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
            bill.set("closer", null);
            bill.set("closedate", (Object)"");
            bill.set("changestatus", (Object)ChangeTypeEnum.ADDNEW.getValue());
            bill.set("changer", null);
            bill.set("changedate", (Object)"");
        } else {
            if (BizTerminateStatusEnum.UNTERMINATE.getValue().equals(bill.get("terminatestatus"))) {
                bill.set("terminator", null);
                bill.set("terminatedate", (Object)"");
            }
            if (BizCancelStatusEnum.UNCANCEL.getValue().equals(bill.get("cancelstatus"))) {
                bill.set("canceler", null);
                bill.set("canceldate", (Object)"");
            }
            if (BizFreezeStatusEnum.UNFREEZE.getValue().equals(bill.get("freezestatus"))) {
                bill.set("freezer", null);
                bill.set("freezedate", (Object)"");
            }
            if (BizCloseStatusEnum.UNCLOSE.getValue().equals(bill.get("closestatus"))) {
                bill.set("closer", null);
                bill.set("closedate", (Object)"");
            }
            if (ChangeTypeEnum.ADDNEW.getValue().equals(bill.get("changestatus"))) {
                bill.set("changer", null);
                bill.set("changedate", (Object)"");
            }
        }
        DynamicObject type = bill.getDynamicObject("type");
        if (type != null) {
            DynamicObject conmType;
            Long pkValue = (Long)type.getPkValue();
            HashMap<Object, DynamicObject> typeMaps = (HashMap<Object, DynamicObject>)cacheMap.get("conm_types");
            if (typeMaps == null) {
                DynamicObject[] types = BusinessDataServiceHelper.load((String)"conm_type", (String)"activereview,activesign,activearchive,pretimepoint", null);
                typeMaps = new HashMap<Object, DynamicObject>(types.length);
                for (DynamicObject conm_type : types) {
                    typeMaps.put(conm_type.getPkValue(), conm_type);
                }
                cacheMap.put("conm_types", typeMaps);
            }
            if ((conmType = (DynamicObject)typeMaps.get(pkValue)) == null) {
                return;
            }
            boolean activereview = conmType.getBoolean("activereview");
            boolean activearchive = conmType.getBoolean("activearchive");
            boolean activeSign = conmType.getBoolean("activesign");
            if (!activereview) {
                bill.set("reviewstatus", (Object)BizReviewStatusEnum.INACTIVE.getValue());
            } else if (bill.getString("reviewstatus") == null) {
                bill.set("reviewstatus", (Object)BizReviewStatusEnum.UNREVIEW.getValue());
            }
            if (BizReviewStatusEnum.INACTIVE.getValue().equals(bill.getString("reviewstatus")) || BizReviewStatusEnum.UNREVIEW.getValue().equals(bill.getString("reviewstatus")) || BizReviewStatusEnum.INREVIEW.getValue().equals(bill.getString("reviewstatus"))) {
                bill.set("reviewdate", (Object)"");
            }
            if (!activeSign) {
                bill.set("signstatus", (Object)BizSignStatusEnum.INACTIVE.getValue());
                bill.set("iselecsignature", (Object)Boolean.FALSE);
            } else if (bill.getString("signstatus") == null) {
                bill.set("signstatus", (Object)BizSignStatusEnum.UNSIGN.getValue());
            }
            if (BizSignStatusEnum.UNSIGN.getValue().equals(bill.getString("signstatus")) || BizSignStatusEnum.INACTIVE.getValue().equals(bill.getString("signstatus")) || BizSignStatusEnum.UPLOADFINISH.getValue().equals(bill.getString("signstatus"))) {
                bill.set("signdate", (Object)"");
            }
            if (!activeSign || bill.getBoolean("iselecsignature") || !BizSignStatusEnum.SIGN.getValue().equals(bill.getString("signstatus"))) {
                bill.set("signer", null);
            }
            if (!activearchive) {
                bill.set("filingstatus", (Object)FilingStatusEnum.INACTIVE.getValue());
            } else if (bill.getString("filingstatus") == null) {
                bill.set("filingstatus", (Object)FilingStatusEnum.UNFILED.getValue());
            }
            if (FilingStatusEnum.UNFILED.getValue().equals(bill.getString("filingstatus")) || FilingStatusEnum.INACTIVE.getValue().equals(bill.getString("filingstatus"))) {
                bill.set("filinger", null);
                bill.set("filingdate", (Object)"");
            }
        }
    }

    private static void setDefaultFinancialInfo(DynamicObject bill) {
        DynamicObject settleCurrency;
        Map<String, Long> currencyMap;
        DynamicObject currency;
        DynamicObject exRateTable;
        DynamicObject org = bill.getDynamicObject("org");
        if (org == null) {
            return;
        }
        Date exratedate = bill.getDate("exratedate");
        if (exratedate == null) {
            bill.set("exratedate", (Object)bill.getDate("biztime"));
            exratedate = bill.getDate("exratedate");
        }
        if ((exRateTable = bill.getDynamicObject("exratetable")) == null) {
            exRateTable = kd.mpscmm.msbd.business.helper.CurrencyHelper.getExRateTable((Long)((Long)org.getPkValue()));
            bill.set("exratetable", (Object)exRateTable);
        }
        if ((currency = bill.getDynamicObject("currency")) == null && (currencyMap = CurrencyHelper.getCurrencyAndExRateTable((Long)org.getPkValue())) != null) {
            Long currencyId = currencyMap.get("baseCurrencyID");
            if (currencyId != null && currencyId != 0L) {
                currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currencyId, (String)"bd_currency");
            }
            bill.set("currency", (Object)currency);
        }
        if ((settleCurrency = bill.getDynamicObject("settlecurrency")) == null) {
            bill.set("settlecurrency", (Object)currency);
            bill.set("exchangerate", (Object)BigDecimal.ONE);
        }
        long settlecurrencyId = settleCurrency == null ? 0L : (Long)settleCurrency.getPkValue();
        long currencyId = currency == null ? 0L : (Long)currency.getPkValue();
        long exratetableId = exRateTable == null ? 0L : (Long)exRateTable.getPkValue();
        Map<String, Object> exchangeRateMap = CurrencyHelper.getExchangeRateMap(settlecurrencyId, currencyId, exratetableId, exratedate);
        if (exchangeRateMap != null && exchangeRateMap.size() > 0) {
            BigDecimal exChangeRate = bill.getBigDecimal("exchangerate");
            if (currencyId == settlecurrencyId && (exChangeRate == null || BigDecimal.ZERO.compareTo(exChangeRate) == 0)) {
                exChangeRate = BigDecimal.ONE;
                bill.set("exchangerate", (Object)exChangeRate);
            } else if (exChangeRate == null || BigDecimal.ZERO.compareTo(exChangeRate) == 0) {
                bill.set("exchangerate", exchangeRateMap.get("exchangeRate"));
            }
            String exchangeType = bill.getString("exchangetype");
            if (StringUtils.isEmpty((CharSequence)exchangeType)) {
                if (((Boolean)exchangeRateMap.get("quoteType")).booleanValue()) {
                    bill.set("exchangetype", (Object)ExChangeTypeEnum.INDIRECTRATE.getValue());
                } else {
                    bill.set("exchangetype", (Object)ExChangeTypeEnum.DIRECTRATE.getValue());
                }
            }
        }
    }

    private static DynamicObject loadContParties(DynamicObject org) {
        if (org == null) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("org.id", "=", org.getPkValue()), new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()), new QFilter("isdefault", "=", (Object)Boolean.TRUE)};
        return BusinessDataServiceHelper.loadSingleFromCache((String)"conm_contparties", (QFilter[])filters);
    }

    private static void setBillentrys(DynamicObject bill) {
        BigDecimal allAmount = BigDecimal.ZERO;
        BigDecimal allAmountAndTax = BigDecimal.ZERO;
        BigDecimal allTaxAmount = BigDecimal.ZERO;
        DynamicObject type = bill.getDynamicObject("type");
        DynamicObjectCollection billentrys = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject billentry : billentrys) {
            BasedataEntityType materialType;
            DynamicObject unit;
            DynamicObject material;
            if (billentry.getString("rowclosestatus") == null || BizValidStatusEnum.UNVALID.getValue().equals(bill.getString("validstatus"))) {
                billentry.set("rowclosestatus", (Object)BizCloseStatusEnum.UNCLOSE.getValue());
            }
            if (billentry.getString("rowterminatestatus") == null || BizValidStatusEnum.UNVALID.getValue().equals(bill.getString("validstatus"))) {
                billentry.set("rowterminatestatus", (Object)BizRowTerminateStatusEnum.UNTERMINATE.getValue());
            }
            if ((material = billentry.getDynamicObject("material")) == null || material.getDynamicObject("masterid") == null) continue;
            billentry.set("entrypurorg", (Object)bill.getDynamicObject("org"));
            DynamicObject masterid = material.getDynamicObject("masterid");
            billentry.set("materialmasterid", masterid.getPkValue());
            if (masterid.getBoolean("isdisposable")) {
                if (StringUtils.isEmpty((CharSequence)billentry.getString("materialname"))) {
                    billentry.set("materialname", (Object)masterid.getLocaleString("name").getLocaleValue());
                }
            } else {
                billentry.set("materialname", (Object)masterid.getLocaleString("name").getLocaleValue());
            }
            if ((unit = billentry.getDynamicObject("unit")) == null && material != null && (materialType = (BasedataEntityType)material.getDataEntityType()) != null) {
                DynamicObject baseUnit;
                int masteridType = materialType.getMasteridType();
                if (masteridType == 1 && (baseUnit = billentry.getDynamicObject("baseunit")) != null) {
                    billentry.set("unit", (Object)baseUnit);
                }
                if (masteridType == 2) {
                    String materialName = materialType.getName();
                    String unitForName = "";
                    if ("bd_materialpurchaseinfo".equals(materialName)) {
                        unitForName = "purchaseunit";
                    }
                    if ("bd_materialsalinfo".equals(materialName)) {
                        unitForName = "salesunit";
                    }
                    if (StringUtils.isNotBlank((CharSequence)unitForName)) {
                        unit = material.getDynamicObject(unitForName);
                        billentry.set("unit", (Object)unit);
                    }
                }
            }
            BillTplHelper.setAuxBizQtyAndUnit(billentry, masterid);
            AmountInfo amountInfo = new AmountInfo();
            DynamicObject taxRateId = billentry.getDynamicObject("taxrateid");
            if (taxRateId == null) {
                DynamicObject defaultTaxRate = null;
                if ("conm_purcontract".equals(bill.getDataEntityType().getName())) {
                    DynamicObject supplier = bill.getDynamicObject("supplier");
                    defaultTaxRate = BillTplHelper.getDefaultTaxRate(supplier, material);
                }
                if ("conm_salcontract".equals(bill.getDataEntityType().getName())) {
                    DynamicObject customer = bill.getDynamicObject("customer");
                    defaultTaxRate = BillTplHelper.getDefaultTaxRate(customer, material);
                }
                if (defaultTaxRate != null) {
                    amountInfo.setTaxRate(defaultTaxRate.getBigDecimal("taxrate"));
                    billentry.set("taxrateid", (Object)defaultTaxRate);
                    billentry.set("taxrate", (Object)defaultTaxRate.getBigDecimal("taxrate"));
                }
            } else {
                BigDecimal taxRate = taxRateId.getBigDecimal("taxrate");
                amountInfo.setTaxRate(taxRate);
                billentry.set("taxrate", (Object)taxRate);
            }
            if (bill.get("istax") == null) {
                amountInfo.setTax(true);
            } else {
                amountInfo.setTax(bill.getBoolean("istax"));
            }
            amountInfo.setQty(billentry.getBigDecimal("qty"));
            amountInfo.setPrice(billentry.getBigDecimal("price"));
            amountInfo.setPriceAndTax(billentry.getBigDecimal("priceandtax"));
            amountInfo.setAmount(billentry.getBigDecimal("amount"));
            amountInfo.setTaxAmount(billentry.getBigDecimal("taxamount"));
            amountInfo.setDiscountType(billentry.getString("discounttype"));
            amountInfo.setDiscountRate(billentry.getBigDecimal("discountrate"));
            amountInfo.setExChangeRate(bill.getBigDecimal("exchangerate"));
            amountInfo.setSettleAmtPrecision(bill.getDynamicObject("settlecurrency") == null ? 10 : bill.getDynamicObject("settlecurrency").getInt("amtprecision"));
            amountInfo.setSettlePricePrecision(10);
            amountInfo.setCurrencyAmtPrecision(bill.getDynamicObject("currency") == null ? 10 : bill.getDynamicObject("currency").getInt("amtprecision"));
            amountInfo.setExchangetype(bill.getString("exchangetype"));
            amountInfo = BillTplHelper.getAmount(amountInfo);
            billentry.set("price", (Object)amountInfo.getPrice());
            billentry.set("priceandtax", (Object)amountInfo.getPriceAndTax());
            billentry.set("discountamount", (Object)amountInfo.getDiscountAmount());
            billentry.set("taxamount", (Object)amountInfo.getTaxAmount());
            billentry.set("amount", (Object)amountInfo.getAmount());
            billentry.set("amountandtax", (Object)amountInfo.getAmountAndTax());
            billentry.set("curtaxamount", (Object)amountInfo.getCurTaxAmount());
            billentry.set("curamount", (Object)amountInfo.getCurAmount());
            billentry.set("curamountandtax", (Object)amountInfo.getCurAmountAndTax());
            allAmountAndTax = billentry.getBigDecimal("amountandtax").add(allAmountAndTax);
            allAmount = billentry.getBigDecimal("amount").add(allAmount);
            allTaxAmount = billentry.getBigDecimal("taxamount").add(allTaxAmount);
        }
        Boolean isEntrySumAmt = bill.getBoolean("isentrysumamt");
        if (isEntrySumAmt.booleanValue()) {
            bill.set("totalallamount", (Object)allAmountAndTax);
            bill.set("totalamount", (Object)allAmount);
            bill.set("totaltaxamount", (Object)allTaxAmount);
        } else {
            bill.set("totalallamount", (Object)bill.getBigDecimal("totalallamount"));
            bill.set("totalamount", (Object)bill.getBigDecimal("totalamount"));
            bill.set("totaltaxamount", (Object)bill.getBigDecimal("totaltaxamount"));
        }
    }

    public static DynamicObject getDefaultTaxRate(DynamicObject dyn, DynamicObject material) {
        DynamicObject master;
        DynamicObject taxRate = null;
        if (material != null && (master = material.getDynamicObject("masterid")) != null && master.getDynamicObject("taxrate") != null) {
            taxRate = master.getDynamicObject("taxrate");
        }
        if (taxRate == null && dyn != null) {
            taxRate = dyn.getDynamicObject("taxrate");
        }
        if (taxRate != null) {
            Long taxRateId = (Long)taxRate.getPkValue();
            taxRate = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_taxrate", (String)"id, taxrate,activedate,expdate", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)taxRateId)});
        }
        return taxRate;
    }

    public static void setAuxBizQtyAndUnit(DynamicObject entry, DynamicObject masterid) {
        DynamicObject materialInfo = entry.getDynamicObject("material");
        if (materialInfo == null || masterid == null) {
            return;
        }
        entry.set("baseunit", (Object)masterid.getDynamicObject("baseunit"));
        entry.set("auxunit", (Object)masterid.getDynamicObject("auxptyunit"));
        BigDecimal qty = entry.getBigDecimal("qty");
        DynamicObject unit = entry.getDynamicObject("unit");
        DynamicObject baseUnit = entry.getDynamicObject("baseunit");
        DynamicObject auxptyUnit = entry.getDynamicObject("auxunit");
        BigDecimal baseQty = entry.getBigDecimal("baseqty");
        BigDecimal auxQty = entry.getBigDecimal("auxqty");
        String unitConvertDir = materialInfo.getString("masterid.unitconvertdir");
        if (unit != null && baseUnit != null) {
            baseQty = unit.getPkValue().equals(baseUnit.getPkValue()) ? qty : BillQtyAndUnitHelper.getDesQtyConv(masterid, unit, qty, baseUnit);
        }
        if (auxptyUnit == null) {
            auxQty = BigDecimal.ZERO;
        } else {
            if (UnitConvertDir_U2ND_UINV.equals(unitConvertDir) && BigDecimalUtil.isBlank((BigDecimal)qty)) {
                baseQty = BillQtyAndUnitHelper.getDesQtyConv(materialInfo.getDynamicObject("masterid"), auxptyUnit, auxQty, baseUnit);
                qty = BillQtyAndUnitHelper.getDesQtyConv(materialInfo.getDynamicObject("masterid"), baseUnit, baseQty, unit);
            }
            if (UnitConvertDir_UINV_U2ND.equals(unitConvertDir) && BigDecimalUtil.isBlank((BigDecimal)auxQty)) {
                auxQty = BillQtyAndUnitHelper.getDesQtyConv(materialInfo.getDynamicObject("masterid"), baseUnit, baseQty, auxptyUnit);
            }
            if (UnitConvertDir_UINVANDU2ND.equals(unitConvertDir)) {
                if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isBlank((BigDecimal)auxQty)) {
                    qty = BigDecimal.ZERO;
                    baseQty = BigDecimal.ZERO;
                    auxQty = BigDecimal.ZERO;
                }
                if (BigDecimalUtil.isNotBlank((BigDecimal)qty) && BigDecimalUtil.isBlank((BigDecimal)auxQty)) {
                    auxQty = BillQtyAndUnitHelper.getDesQtyConv(materialInfo.getDynamicObject("masterid"), baseUnit, baseQty, auxptyUnit);
                }
                if (BigDecimalUtil.isBlank((BigDecimal)qty) && BigDecimalUtil.isNotBlank((BigDecimal)auxQty)) {
                    baseQty = BillQtyAndUnitHelper.getDesQtyConv(materialInfo.getDynamicObject("masterid"), auxptyUnit, auxQty, baseUnit);
                    qty = BillQtyAndUnitHelper.getDesQtyConv(materialInfo.getDynamicObject("masterid"), baseUnit, baseQty, unit);
                }
            }
        }
        entry.set("qty", (Object)qty);
        entry.set("baseqty", (Object)baseQty);
        entry.set("auxqty", (Object)auxQty);
    }

    public static AmountInfo getAmount(AmountInfo amountInfo) {
        boolean isTax = amountInfo.isTax();
        BigDecimal qty = amountInfo.getQty();
        BigDecimal price = amountInfo.getPrice();
        BigDecimal priceAndTax = amountInfo.getPriceAndTax();
        BigDecimal taxRate = amountInfo.getTaxRate().divide(HUNDRED, RoundingMode.HALF_UP);
        String discountType = amountInfo.getDiscountType();
        BigDecimal discountRate = amountInfo.getDiscountRate();
        int settleAmtPrecision = amountInfo.getSettleAmtPrecision();
        int settlePricePrecision = amountInfo.getSettlePricePrecision();
        int currencyAmtPrecision = amountInfo.getCurrencyAmtPrecision();
        BigDecimal exChangeRate = amountInfo.getExChangeRate();
        String exchangetype = amountInfo.getExchangetype();
        BigDecimal amount = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal discountAmount = ZERO;
        BigDecimal amountAndTax = ZERO;
        if (qty != null && qty.compareTo(ZERO) != 0) {
            if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
                price = priceAndTax.divide(ONE.add(taxRate), 10, RoundingMode.HALF_UP);
                if (discountRate == null || StringUtils.isBlank((CharSequence)discountType) || discountType.equals(DiscountTypeEnum.NULL.getValue()) || discountRate.compareTo(ZERO) == 0) {
                    amountAndTax = qty.multiply(priceAndTax).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    discountRate = discountRate.divide(HUNDRED);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    amountAndTax = qty.multiply(priceAndTax).subtract(discountAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    amountAndTax = qty.multiply(priceAndTax).subtract(discountAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                }
                taxAmount = amountAndTax.divide(ONE.add(taxRate), 10, 4).multiply(taxRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                amount = amountAndTax.subtract(taxAmount).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            } else if (!isTax && price != null && price.compareTo(ZERO) != 0) {
                priceAndTax = price.multiply(ONE.add(taxRate)).setScale(10, RoundingMode.HALF_UP);
                if (discountRate == null || StringUtils.isBlank((CharSequence)discountType) || discountType.equals(DiscountTypeEnum.NULL.getValue()) || discountRate.compareTo(ZERO) == 0) {
                    amount = qty.multiply(price).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.DISRATE.getValue().equals(discountType)) {
                    discountRate = discountRate.divide(HUNDRED, RoundingMode.HALF_UP);
                    discountAmount = qty.multiply(priceAndTax).multiply(discountRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price).multiply(ONE.subtract(discountRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                } else if (DiscountTypeEnum.UNITDIS.getValue().equals(discountType) || DiscountTypeEnum.FIXEDDIS.getValue().equals(discountType)) {
                    discountAmount = qty.multiply(discountRate).multiply(ONE.add(taxRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                    amount = qty.multiply(price.subtract(discountRate)).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                }
                taxAmount = amount.multiply(taxRate).setScale(settleAmtPrecision, RoundingMode.HALF_UP);
                amountAndTax = amount.add(taxAmount);
                amountAndTax = amountAndTax.setScale(settleAmtPrecision, RoundingMode.HALF_UP);
            } else {
                priceAndTax = ZERO;
                price = ZERO;
            }
            if (exChangeRate != null && exChangeRate.compareTo(ZERO) != 0) {
                BigDecimal curAmount = ZERO;
                BigDecimal curTaxAmount = ZERO;
                BigDecimal curAmountAndTax = ZERO;
                curTaxAmount = AmountHelper.getCurAmountByRate(taxAmount, exChangeRate, currencyAmtPrecision, exchangetype);
                if (isTax) {
                    curAmountAndTax = AmountHelper.getCurAmountByRate(amountAndTax, exChangeRate, currencyAmtPrecision, exchangetype);
                    curAmount = curAmountAndTax.subtract(curTaxAmount);
                } else {
                    curAmount = AmountHelper.getCurAmountByRate(amount, exChangeRate, currencyAmtPrecision, exchangetype);
                    curAmountAndTax = curAmount.add(curTaxAmount);
                }
                amountInfo.setCurAmount(curAmount);
                amountInfo.setCurTaxAmount(curTaxAmount);
                amountInfo.setCurAmountAndTax(curAmountAndTax);
            }
        } else if (isTax && priceAndTax != null && priceAndTax.compareTo(ZERO) != 0) {
            priceAndTax = priceAndTax.setScale(settlePricePrecision, RoundingMode.HALF_UP);
            price = priceAndTax.divide(ONE.add(taxRate), settlePricePrecision, RoundingMode.HALF_UP);
        } else if (!isTax && price != null && price.compareTo(ZERO) != 0) {
            price = price.setScale(settlePricePrecision, RoundingMode.HALF_UP);
            priceAndTax = price.multiply(ONE.add(taxRate)).setScale(settlePricePrecision, RoundingMode.HALF_UP);
        } else {
            priceAndTax = ZERO;
            price = ZERO;
        }
        amountInfo.setPrice(price);
        amountInfo.setPriceAndTax(priceAndTax);
        amountInfo.setAmount(amount);
        amountInfo.setDiscountAmount(discountAmount);
        amountInfo.setTaxAmount(taxAmount);
        amountInfo.setAmountAndTax(amountAndTax);
        return amountInfo;
    }

    public static class AmountInfo {
        private boolean isTax = true;
        private BigDecimal qty = BigDecimal.ZERO;
        private BigDecimal price = BigDecimal.ZERO;
        private BigDecimal priceAndTax = BigDecimal.ZERO;
        private BigDecimal taxRate = BigDecimal.ZERO;
        private String discountType = "";
        private BigDecimal discountRate = BigDecimal.ZERO;
        private int settleAmtPrecision = 10;
        private int settlePricePrecision = 10;
        private int currencyAmtPrecision = 10;
        private BigDecimal exChangeRate = BigDecimal.ZERO;
        private String exchangetype = "";
        private BigDecimal amount = BigDecimal.ZERO;
        private BigDecimal taxAmount = BigDecimal.ZERO;
        private BigDecimal discountAmount = BigDecimal.ZERO;
        private BigDecimal amountAndTax = BigDecimal.ZERO;
        private BigDecimal curAmount = BigDecimal.ZERO;
        private BigDecimal curTaxAmount = BigDecimal.ZERO;
        private BigDecimal curAmountAndTax = BigDecimal.ZERO;

        public boolean isTax() {
            return this.isTax;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public BigDecimal getPrice() {
            return this.price;
        }

        public BigDecimal getPriceAndTax() {
            return this.priceAndTax;
        }

        public BigDecimal getTaxRate() {
            return this.taxRate;
        }

        public String getDiscountType() {
            return this.discountType;
        }

        public BigDecimal getDiscountRate() {
            return this.discountRate;
        }

        public int getSettleAmtPrecision() {
            return this.settleAmtPrecision;
        }

        public int getSettlePricePrecision() {
            return this.settlePricePrecision;
        }

        public int getCurrencyAmtPrecision() {
            return this.currencyAmtPrecision;
        }

        public BigDecimal getExChangeRate() {
            return this.exChangeRate;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public BigDecimal getTaxAmount() {
            return this.taxAmount;
        }

        public BigDecimal getDiscountAmount() {
            return this.discountAmount;
        }

        public BigDecimal getAmountAndTax() {
            return this.amountAndTax;
        }

        public BigDecimal getCurAmount() {
            return this.curAmount;
        }

        public BigDecimal getCurTaxAmount() {
            return this.curTaxAmount;
        }

        public BigDecimal getCurAmountAndTax() {
            return this.curAmountAndTax;
        }

        public void setTax(boolean isTax) {
            this.isTax = isTax;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public void setPrice(BigDecimal price) {
            this.price = price;
        }

        public void setPriceAndTax(BigDecimal priceAndTax) {
            this.priceAndTax = priceAndTax;
        }

        public void setTaxRate(BigDecimal taxRate) {
            this.taxRate = taxRate;
        }

        public void setDiscountType(String discountType) {
            this.discountType = discountType;
        }

        public void setDiscountRate(BigDecimal discountRate) {
            this.discountRate = discountRate;
        }

        public void setSettleAmtPrecision(int settleAmtPrecision) {
            this.settleAmtPrecision = settleAmtPrecision;
        }

        public void setSettlePricePrecision(int settlePricePrecision) {
            this.settlePricePrecision = settlePricePrecision;
        }

        public void setCurrencyAmtPrecision(int currencyAmtPrecision) {
            this.currencyAmtPrecision = currencyAmtPrecision;
        }

        public void setExChangeRate(BigDecimal exChangeRate) {
            this.exChangeRate = exChangeRate;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public void setTaxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
        }

        public void setDiscountAmount(BigDecimal discountAmount) {
            this.discountAmount = discountAmount;
        }

        public void setAmountAndTax(BigDecimal amountAndTax) {
            this.amountAndTax = amountAndTax;
        }

        public void setCurAmount(BigDecimal curAmount) {
            this.curAmount = curAmount;
        }

        public void setCurTaxAmount(BigDecimal curTaxAmount) {
            this.curTaxAmount = curTaxAmount;
        }

        public void setCurAmountAndTax(BigDecimal curAmountAndTax) {
            this.curAmountAndTax = curAmountAndTax;
        }

        public String getExchangetype() {
            return this.exchangetype;
        }

        public void setExchangetype(String exchangetype) {
            this.exchangetype = exchangetype;
        }
    }
}

