/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.util.StringUtils;

public class BotpPushHelper {
    public static Map<String, Object> push(List<DynamicObject> objs, String sourceEntityNumber, String targetEntityNumber) {
        return BotpPushHelper.push(objs, sourceEntityNumber, null, targetEntityNumber, null);
    }

    public static Map<String, Object> push(List<DynamicObject> objs, String sourceEntityNumber, String sourceEntryEntity, String targetEntityNumber, String ruleId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<Object, String> errorMsg = new HashMap<Object, String>();
        PushArgs botp = BotpPushHelper.buildPushArgs(objs, sourceEntityNumber, sourceEntryEntity, targetEntityNumber, ruleId);
        ConvertOperationResult result = BotpPushHelper.push(botp);
        if (!result.isSuccess()) {
            for (SourceBillReport billReport : result.getBillReports()) {
                String failMessage = billReport.getFailMessage();
                errorMsg.put(billReport.getBillId(), failMessage);
            }
            map.put("errorMsg", errorMsg);
            map.put("success", Boolean.FALSE);
            return map;
        }
        map.put("success", Boolean.TRUE);
        List<DynamicObject> targetOrder = BotpPushHelper.getTargetObjectWithRefence(result);
        map.put("targetObjects", targetOrder);
        return map;
    }

    public static ConvertOperationResult push(PushArgs pushArgs) {
        return ConvertServiceHelper.push((PushArgs)pushArgs);
    }

    public static List<DynamicObject> getTargetObjectWithRefence(ConvertOperationResult result) {
        if (!result.isSuccess()) {
            return null;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)result.getTargetEntityNumber());
        List targetOrder = result.loadTargetDataObjects((paramArrayOfObject, paramIDataEntityType) -> BusinessDataServiceHelper.loadRefence((Object[])paramArrayOfObject, (IDataEntityType)paramIDataEntityType), mainType);
        return targetOrder;
    }

    public static PushArgs buildPushArgs(List<DynamicObject> objs, String sourceEntityNymber, String filedKey, String targetEntityNumber, String ruleId) {
        PushArgs botp = new PushArgs();
        if (StringUtils.isNotEmpty((String)filedKey)) {
            ArrayList<ListSelectedRow> sourceBill = new ArrayList<ListSelectedRow>(16);
            for (DynamicObject obj : objs) {
                DynamicObjectCollection eids = obj.getDynamicObjectCollection(filedKey);
                for (DynamicObject eid : eids) {
                    ListSelectedRow row = new ListSelectedRow(obj.getPkValue(), Boolean.TRUE);
                    row.setEntryEntityKey(filedKey);
                    row.setEntryPrimaryKeyValue(eid.get("id"));
                    sourceBill.add(row);
                }
            }
            botp.setSelectedRows(sourceBill);
        } else {
            ArrayList<ListSelectedRow> sourceBill = new ArrayList<ListSelectedRow>(16);
            for (DynamicObject obj : objs) {
                ListSelectedRow row = new ListSelectedRow(obj.getPkValue(), Boolean.TRUE);
                sourceBill.add(row);
            }
            botp.setSelectedRows(sourceBill);
        }
        botp.setSourceEntityNumber(sourceEntityNymber);
        botp.setTargetEntityNumber(targetEntityNumber);
        botp.setRuleId(ruleId);
        return botp;
    }
}

