/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.scmc.conm.enums.EnableStatusEnum;
import kd.scmc.conm.enums.ExChangeTypeEnum;

public class CurrencyHelper {
    private static final Log LOGGER = LogFactory.getLog(CurrencyHelper.class);

    public static Map<String, Object> get4P(DynamicObject bill) {
        Boolean quoteType;
        Map<String, Object> exchangeRateMap;
        Map<String, Long> cur;
        Long orgID = (Long)bill.get("org.id");
        BigDecimal exrateRate = bill.getBigDecimal("exchangerate");
        Date exrateDate = bill.getDate("exratedate");
        DynamicObject currency = bill.getDynamicObject("currency");
        DynamicObject settleCurrency = bill.getDynamicObject("settlecurrency");
        DynamicObject exratetable = bill.getDynamicObject("exratetable");
        String exchangeType = bill.getString("exchangetype");
        if (currency == null && (cur = CurrencyHelper.getCurrencyAndExRateTable(orgID)) != null) {
            currency = BusinessDataServiceHelper.loadSingleFromCache((Object)cur.get("baseCurrencyID"), (String)"bd_currency");
        }
        if (exratetable == null && (cur = CurrencyHelper.getCurrencyAndExRateTable(orgID)) != null) {
            exratetable = BusinessDataServiceHelper.loadSingleFromCache((Object)cur.get("exchangeRateTableID"), (String)"bd_exratetable");
        }
        if (settleCurrency == null) {
            settleCurrency = currency;
        }
        if (exrateDate == null) {
            exrateDate = TimeServiceHelper.now();
        }
        if ((exrateRate == null || exrateRate.compareTo(BigDecimal.ZERO) == 0) && settleCurrency != null && currency != null && exratetable != null && exrateDate != null) {
            if (exchangeType != null) {
                exrateRate = CurrencyHelper.getExRate((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exratetable.getPkValue(), exrateDate, exchangeType);
            } else {
                exchangeRateMap = CurrencyHelper.getExchangeRateMap((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exratetable.getPkValue(), exrateDate);
                if (exchangeRateMap != null && exchangeRateMap.size() > 0) {
                    exrateRate = (BigDecimal)exchangeRateMap.get("exchangeRate");
                    quoteType = (Boolean)exchangeRateMap.get("quoteType");
                    exchangeType = quoteType != null && quoteType == false ? ExChangeTypeEnum.DIRECTRATE.getValue() : ExChangeTypeEnum.INDIRECTRATE.getValue();
                }
            }
        }
        if ((exchangeType == null || exchangeType.equals("")) && settleCurrency != null && currency != null && exratetable != null && exrateDate != null && (exchangeRateMap = CurrencyHelper.getExchangeRateMap((Long)settleCurrency.getPkValue(), (Long)currency.getPkValue(), (Long)exratetable.getPkValue(), exrateDate)) != null && exchangeRateMap.size() > 0) {
            quoteType = (Boolean)exchangeRateMap.get("quoteType");
            exchangeType = quoteType != null && quoteType == false ? ExChangeTypeEnum.DIRECTRATE.getValue() : ExChangeTypeEnum.INDIRECTRATE.getValue();
        }
        HashMap<String, Object> res4P = new HashMap<String, Object>();
        res4P.put("currency", currency);
        res4P.put("settlecurrency", settleCurrency);
        res4P.put("exratedate", exrateDate);
        res4P.put("exchangerate", exrateRate);
        res4P.put("exratetable", exratetable);
        res4P.put("exchangetype", exchangeType);
        return res4P;
    }

    public static Map<String, Long> getCurrencyAndExRateTable(Long orgId) {
        Map mapOrg;
        if (orgId != null && (mapOrg = OrgUnitServiceHelper.getCompanyByOrg((Long)orgId, (Boolean)Boolean.FALSE, (Boolean)Boolean.TRUE)) != null && mapOrg.get("id") != null) {
            LOGGER.info(ResManager.loadKDString((String)"\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u9700\u6c42\u7ec4\u7ec7\u7684\u6838\u7b97\u4e3b\u4f53\uff1a", (String)"CurrencyHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]) + mapOrg);
            Map map = BaseDataServiceHelper.getBaseAccountingInfo((Long)((Long)mapOrg.get("id")));
            if (map != null && map.size() != 0) {
                LOGGER.info(ResManager.loadKDString((String)"\u901a\u8fc7\u63a5\u53e3\u83b7\u53d6\u6838\u7b97\u4e3b\u4f53\u7684\u672c\u4f4d\u5e01\u548c\u6c47\u7387\u8868\uff1a", (String)"CurrencyHelper_1", (String)"scmc-conm-business", (Object[])new Object[0]) + map);
                return map;
            }
        }
        return null;
    }

    public static Map<String, Object> getExchangeRateMap(Long settleCurrency, Long currency, Long exRateTable, Date bizTime) {
        if (settleCurrency == null || currency == null || exRateTable == null) {
            return null;
        }
        return BaseDataServiceHelper.getExchangeRateMap((Long)settleCurrency, (Long)currency, (Long)exRateTable, (Date)bizTime);
    }

    public static BigDecimal getExChangeRate(Long srcCurId, Long targCurId, Long exRateTableId, Date date) {
        BigDecimal exChangeRate = BigDecimal.ZERO;
        if (srcCurId.equals(targCurId)) {
            exChangeRate = BigDecimal.ONE;
        } else {
            Map exchangeRateMap = BaseDataServiceHelper.getExchangeRateMap((Long)srcCurId, (Long)targCurId, (Long)exRateTableId, (Date)date);
            if (exchangeRateMap != null && exchangeRateMap.size() > 0) {
                exChangeRate = (BigDecimal)exchangeRateMap.get("exchangeRate");
            }
        }
        return exChangeRate;
    }

    public static BigDecimal getExRate(Long srcCurId, Long tarCurId, Long exRateTableId, Date date, String exchangeType) {
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (srcCurId == null || tarCurId == null || exRateTableId == null || date == null || exchangeType == null) {
            return exchangeRate;
        }
        if (srcCurId.equals(tarCurId)) {
            exchangeRate = BigDecimal.ONE;
        } else {
            boolean isIndirect = false;
            if ("1".equals(exchangeType)) {
                isIndirect = true;
            }
            exchangeRate = BaseDataServiceHelper.getExchangeRateByQuoteType((Long)srcCurId, (Long)tarCurId, (Long)exRateTableId, (Date)date, (boolean)isIndirect);
        }
        return exchangeRate;
    }

    public static DynamicObject getSettletype(DynamicObject role) {
        if (role != null && role.getDynamicObject("settlementtypeid") != null) {
            return role.getDynamicObject("settlementtypeid");
        }
        QFilter isdefault = new QFilter("isdefault", "=", (Object)Boolean.TRUE);
        QFilter isenable = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        return BusinessDataServiceHelper.loadSingleFromCache((String)"bd_settlementtype", (QFilter[])new QFilter[]{isdefault, isenable});
    }
}

