/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.EncreptSessionUtils;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.HttpClientHelper;
import kd.scmc.conm.business.pojo.ElecHttpResult;

public class ElecSignHelper {
    private static Log logger = LogFactory.getLog(ElecSignHelper.class);
    private static String DEV_URL = "https://testpay.kingdee.com/kdcontractDev";
    private static String PRO_URL = "https://pay.kingdee.com/kdcontract";
    private static String DOWNLOAD_SIGN_URl = "/api/contract/refresh";

    public static ElecHttpResult downloadSignFile(String kdAppId, String uuid, String formid, String pkValue, String billno, String contractname) {
        if (StringUtils.isEmpty((String)kdAppId) || StringUtils.isEmpty((String)uuid) || StringUtils.isEmpty((String)billno) || StringUtils.isEmpty((String)formid) || StringUtils.isEmpty((String)pkValue)) {
            logger.error("\u83b7\u53d6\u7b7e\u7ae0\u6587\u4ef6\u5730\u5740\u53c2\u6570\u7f3a\u5931 kdappid=" + kdAppId + "; uuid=" + uuid + " ;billno=" + billno + " ;formid=" + formid + " ;pkid=" + pkValue);
            return ElecHttpResult.getErrorMsg();
        }
        ElecHttpResult signUrl = ElecSignHelper.getDownloadSignUrl(kdAppId, uuid, billno);
        logger.info("\u7535\u5b50\u7b7e\u7ae0\uff1a\u83b7\u53d6\u7b7e\u7ae0\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740" + JSON.toJSONString((Object)signUrl));
        if (signUrl != null && "0".equalsIgnoreCase(signUrl.getCode())) {
            JSONObject sealInfo;
            JSONObject data0;
            JSONArray data = (JSONArray)signUrl.getData();
            if (data != null && data.size() > 0 && (data0 = (JSONObject)data.get(0)) != null && data0.size() > 0 && (sealInfo = data0.getJSONObject("sealInfo")) != null) {
                String downloadUrl = sealInfo.getString("downloadUrl");
                logger.info("\u7535\u5b50\u7b7e\u7ae0\uff1a\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\uff1a" + downloadUrl);
                if (!StringUtils.isEmpty((String)downloadUrl)) {
                    try {
                        ElecHttpResult elecHttpResult = ElecSignHelper.replaceSignAttachment(downloadUrl, formid, pkValue, contractname);
                        if (elecHttpResult == null) {
                            logger.error("downloadSignFile\uff1a\u66ff\u6362\u7b7e\u7ae0\u9644\u4ef6\u5931\u8d25\uff0c\u8fd4\u56de\u6570\u636e\u4e3anull");
                            elecHttpResult = ElecHttpResult.getErrorMsg(ResManager.loadKDString((String)"\u670d\u52a1\u5668\u65e0\u54cd\u5e94", (String)"ElecSignHelper_4", (String)"scmc-conm-business", (Object[])new Object[0]));
                        }
                        return elecHttpResult;
                    }
                    catch (Exception e) {
                        logger.error("\u7ed1\u5b9a\u6587\u4ef6\u51fa\u9519\uff1a" + e.getMessage());
                        return ElecHttpResult.getErrorMsg(String.format(ResManager.loadKDString((String)"\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519\uff1a%s\u3002", (String)"ElecSignHelper_15", (String)"scmc-conm-business", (Object[])new Object[0]), e.getMessage()));
                    }
                }
            }
        } else if (signUrl != null) {
            logger.error("\u9519\u8befcode:" + signUrl.getCode() + "\u6570\u636e\u5185\u5bb9\uff1a" + JSON.toJSONString((Object)signUrl));
            String downloadUrl = signUrl.getMsg();
            return ElecHttpResult.getErrorMsg(downloadUrl);
        }
        logger.error("\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u51fa\u9519 signurl=" + JSON.toJSONString((Object)signUrl));
        return ElecHttpResult.getErrorMsg(ResManager.loadKDString((String)"\u83b7\u53d6\u6587\u4ef6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\u3002", (String)"ElecSignHelper_16", (String)"scmc-conm-business", (Object[])new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ElecHttpResult replaceSignAttachment(String url, String formId, String pkValue, String fileName) {
        if (StringUtils.isEmpty((String)url) || StringUtils.isEmpty((String)formId) || StringUtils.isEmpty((String)pkValue)) {
            logger.error("\u66ff\u6362\u7b7e\u7ae0\u6587\u4ef6\u53c2\u6570\u7f3a\u5931\uff0cformid: " + formId + " , pkValue= " + pkValue + " , url=" + url);
            return ElecHttpResult.getErrorMsg(ResManager.loadKDString((String)"\u66ff\u6362\u7b7e\u7ae0\u6587\u4ef6\u5931\u8d25\uff0c\u53c2\u6570\u7f3a\u5931\u3002", (String)"ElecSignHelper_18", (String)"scmc-conm-business", (Object[])new Object[0]));
        }
        InputStream inputStream = HttpClientHelper.getInputStreamByWebUrl(url);
        if (inputStream == null) {
            logger.error("\u83b7\u53d6\u5230\u7684inputstream\u4e3a\u7a7a");
            return ElecHttpResult.getErrorMsg(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u3002\u670d\u52a1\u5668\u7f51\u7edc\u72b6\u6001\u4e0d\u4f73\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ElecSignHelper_3", (String)"scmc-conm-business", (Object[])new Object[0]));
        }
        try {
            DynamicObject[] load;
            int size = 261120;
            TempFileCache fileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            fileName = StringUtils.isEmpty((String)fileName) ? String.format(ResManager.loadKDString((String)"\u91d1\u8776\u4e91\u82cd\u7a79\u5408\u540c%s.pdf", (String)"ElecSignHelper_19", (String)"scmc-conm-business", (Object[])new Object[0]), pkValue) : fileName + ".pdf";
            String asUrl = fileCache.saveAsUrl(fileName, inputStream, 20000);
            asUrl = EncreptSessionUtils.encryptSession((String)asUrl);
            logger.info("\u9644\u4ef6\u4fdd\u5b58redis");
            String xdurl = AttachmentServiceHelper.saveTempToFileService((String)asUrl, (String)"conm", (String)formId, (Object)pkValue, (String)fileName, (boolean)true, (boolean)true);
            if (StringUtils.isEmpty((String)xdurl)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0a\u4f20\u9644\u4ef6\u670d\u52a1\u5668\u5931\u8d25", (String)"ElecSignHelper_20", (String)"scmc-conm-business", (Object[])new Object[0]));
            }
            ArrayList data = new ArrayList();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", fileName);
            map.put("url", xdurl);
            map.put("size", size);
            QFilter finterid = new QFilter("finterid", "=", (Object)pkValue);
            QFilter key = new QFilter("fattachmentpanel", "=", (Object)"signattachment");
            String uid = "conm-sign-" + DB.genLongId((String)"bos_attachment");
            for (DynamicObject object : load = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"id", (QFilter[])finterid.and(key).toArray())) {
                String ui = String.valueOf(object.getPkValue());
                if (StringUtils.isEmpty((String)ui) || !ui.contains("conm-sign")) continue;
                uid = ui;
                break;
            }
            map.put("uid", uid);
            data.add(map);
            logger.info("\u9644\u4ef6\u4e0a\u4f20\u670d\u52a1\u5668");
            AttachmentServiceHelper.upload((String)formId, (Object)pkValue, (String)"signattachment", data);
            ElecHttpResult elecHttpResult = ElecHttpResult.getOkMsg(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5b8c\u6210\uff0c\u8bf7\u5728\u7b7e\u7ae0\u9644\u4ef6\u4e2d\u67e5\u770b\u3002", (String)"ElecSignHelper_21", (String)"scmc-conm-business", (Object[])new Object[0]));
            return elecHttpResult;
        }
        catch (Exception e) {
            logger.error("\u66ff\u6362\u6587\u4ef6\u9519\u8bef\uff1a" + e.getMessage());
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    logger.error("\u8f93\u51fa\u6d41\u5173\u95ed\u5f02\u5e38\uff1a" + e.getMessage());
                }
            }
        }
        return ElecHttpResult.getErrorMsg(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25", (String)"ElecSignHelper_22", (String)"scmc-conm-business", (Object[])new Object[0]));
    }

    private static ElecHttpResult getDownloadSignUrl(String kdAppId, String uuid, String contractNo) {
        ElecHttpResult result;
        String nonce = UUID.randomUUID().toString().replace("-", "");
        if (StringUtils.isEmpty((String)kdAppId) || StringUtils.isEmpty((String)uuid) || StringUtils.isEmpty((String)contractNo)) {
            logger.error("\u83b7\u53d6\u7b7e\u7ae0\u6587\u4ef6\u5730\u5740\u53c2\u6570\u7f3a\u5931 kdappid=" + kdAppId + "; uuid=" + uuid + " ;contractNo=" + contractNo);
            return ElecHttpResult.getErrorMsg();
        }
        String url = ElecSignHelper.getFinalUrl(DOWNLOAD_SIGN_URl, kdAppId, nonce);
        HashMap<String, String> handSignData = new HashMap<String, String>();
        handSignData.put("contractNo", contractNo);
        String sign = ElecSignHelper.getSign(uuid, nonce, handSignData);
        if (sign == null) {
            logger.error("\u83b7\u53d6\u7b7e\u7ae0\u6587\u4ef6\u5730\u5740\u65f6\uff0c\u83b7\u53d6\u6570\u5b57\u7b7e\u540d\u5931\u8d25");
            return ElecHttpResult.getErrorMsg(ResManager.loadKDString((String)"\u8bf7\u6c42\u52a0\u5bc6\u5931\u8d25", (String)"ElecSignHelper_23", (String)"scmc-conm-business", (Object[])new Object[0]));
        }
        try {
            StringBuilder finalUrl = new StringBuilder(url).append("&sign=").append(sign);
            result = HttpClientHelper.get(finalUrl.toString(), null);
            if (result == null) {
                logger.error("getDownloadSignUrl\uff1a\u83b7\u53d6\u7b7e\u7ae0\u5730\u5740get\u8fd4\u56de\u6570\u636e\u4e3anull");
                result = ElecHttpResult.getErrorMsg(ResManager.loadKDString((String)"\u670d\u52a1\u5668\u65e0\u54cd\u5e94", (String)"ElecSignHelper_4", (String)"scmc-conm-business", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            result = ElecHttpResult.getErrorMsg(ResManager.loadKDString((String)"\u4e0b\u8f7d\u5931\u8d25", (String)"ElecSignHelper_22", (String)"scmc-conm-business", (Object[])new Object[0]));
            logger.error("\u83b7\u53d6\u4e0b\u8f7d\u5730\u5740\u5931\u8d25\uff1a" + e.getMessage());
        }
        return result;
    }

    public static String getFinalUrl(String url, String kdAppId, String nonce) {
        String envType = System.getProperty("env.type");
        StringBuilder sb = new StringBuilder();
        if ("prod".equalsIgnoreCase(envType)) {
            sb = sb.append(PRO_URL).append(url);
        } else if ("test".equalsIgnoreCase(envType) || "dev".equalsIgnoreCase(envType)) {
            sb = sb.append(DEV_URL).append(url);
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u83b7\u53d6\u4e0d\u5230\u8be5\u64cd\u4f5c\u5bf9\u5e94\u5f53\u524d\u73af\u5883\u7684url\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u73af\u5883\u53c2\u6570\u6216\u5347\u7ea7MC\u3002", (String)"ElecSignHelper_25", (String)"scmc-conm-business", (Object[])new Object[0]));
        }
        sb.append("?kdAppId=").append(kdAppId).append("&nonce=").append(nonce).append("&signType=AES");
        return sb.toString();
    }

    public static String getSign(String uuid, String nonce, Object data) {
        HashMap<String, Object> biz = new HashMap<String, Object>();
        biz.put("nonce", nonce);
        biz.put("version", "1.0");
        biz.put("data", data);
        return HttpClientHelper.encryptAES(uuid, JSON.toJSONString(biz));
    }
}

