/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import com.alibaba.fastjson.JSONObject;
import java.io.InputStream;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Base64;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.AESUtils;
import kd.scmc.conm.business.pojo.ElecHttpResult;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class HttpClientHelper {
    private static Log logger = LogFactory.getLog(HttpClientHelper.class);
    private static RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(180000).setConnectTimeout(5000).build();

    public static String encryptAES(String key, String data) {
        try {
            String encode = AESUtils.encrypt((String)data, (String)Base64.getEncoder().encodeToString(key.getBytes("utf-8")));
            encode = URLEncoder.encode(encode, "utf-8");
            logger.info("\u52a0\u5bc6\u540e\uff1a" + encode);
            return encode;
        }
        catch (Exception er) {
            logger.error("AES\u52a0\u5bc6\u5931\u8d25", (Throwable)er);
            return null;
        }
    }

    public static String decryptAES(String key, String data) {
        try {
            String data1 = URLDecoder.decode(data, "utf-8");
            String decode = AESUtils.decrypt((String)data1, (String)Base64.getEncoder().encodeToString(key.getBytes("utf-8")));
            logger.info("\u89e3\u5bc6\u540e\uff1a" + decode);
            return decode;
        }
        catch (Exception e) {
            logger.error("AES\u89e3\u5bc6\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElecHttpResult get(String url, Map<String, String> headers) {
        String content = null;
        HttpClient client = HttpClientHelper.createHttpClient();
        HttpGet request = new HttpGet();
        request.setConfig(requestConfig);
        if (headers != null && headers.size() != 0) {
            for (Map.Entry<String, String> next : headers.entrySet()) {
                request.setHeader(next.getKey(), next.getValue());
            }
        }
        try {
            request.setURI(new URI(url));
            HttpResponse response = client.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            content = EntityUtils.toString((HttpEntity)entity);
            logger.info("get-1 \u6210\u529fcontent:" + content);
        }
        catch (Exception var19) {
            logger.error("get-2 \u53d1\u9001get\u8bf7\u6c42\u9519\u8bef ", (Throwable)var19);
            ElecHttpResult elecHttpResult = ElecHttpResult.getErrorMsg(ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u670d\u52a1\u5668\u7f51\u7edc\u72b6\u6001\u4e0d\u4f73\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", (String)"HttpClientHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]));
            return elecHttpResult;
        }
        finally {
            request.releaseConnection();
        }
        return (ElecHttpResult)JSONObject.parseObject((String)content, ElecHttpResult.class);
    }

    public static InputStream getInputStreamByWebUrl(String url) {
        HttpClient client = HttpClientHelper.createHttpClient();
        InputStream is = null;
        try {
            URIBuilder builder = new URIBuilder(url);
            HttpGet httpGet = new HttpGet(builder.build());
            httpGet.setConfig(requestConfig);
            HttpResponse respone = client.execute((HttpUriRequest)httpGet);
            if (respone.getStatusLine().getStatusCode() != 200) {
                logger.error("getInputStreamByWebUrl-1 code:" + respone.getStatusLine().getStatusCode());
                return null;
            }
            HttpEntity entity = respone.getEntity();
            if (entity != null) {
                logger.info("getInputStreamByWebUrl-2 entity\u4e0d\u4e3a\u7a7a");
                is = entity.getContent();
                return is;
            }
        }
        catch (Exception e) {
            logger.error("getInputStreamByWebUrl-3  msg:" + e.getMessage());
            return null;
        }
        logger.error("getInputStreamByWebUrl-4");
        return null;
    }

    private static HttpClient createHttpClient() {
        CloseableHttpClient client = HttpClientBuilder.create().build();
        return client;
    }
}

