/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.helper;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.scmc.conm.business.pojo.ReturnResultInfo;

public class OperateExecuteHelper {
    public static ReturnResultInfo executeSave4Rollback(String entity, DynamicObject[] bills, OperateOption option, Boolean isAllRollback) {
        ReturnResultInfo result = new ReturnResultInfo();
        StringBuilder message = new StringBuilder();
        StringBuilder detailMessage = new StringBuilder();
        if (bills == null || StringUtils.isBlank((CharSequence)entity) || bills.length == 0) {
            message.append(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65b9\u6cd5\u53c2\u6570\u540e\u518d\u6b21\u8c03\u7528\u3002", (String)"OperateExecuteHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]));
            detailMessage.append(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65b9\u6cd5\u53c2\u6570\u540e\u518d\u6b21\u8c03\u7528\u3002", (String)"OperateExecuteHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]));
            result.setSuccess(false);
            result.setMessage(message.toString());
            result.setDetailMessage(detailMessage.toString());
            return result;
        }
        option = OperateExecuteHelper.getOperateOption(option);
        OperationResult saveResult = null;
        try {
            saveResult = SaveServiceHelper.saveOperate((String)entity, (DynamicObject[])bills, (OperateOption)option);
        }
        catch (Exception e) {
            message = message.append(entity).append(ResManager.loadKDString((String)"\u4fdd\u5b58\u64cd\u4f5c\u5f02\u5e38\u3002", (String)"OperateExecuteHelper_1", (String)"scmc-conm-business", (Object[])new Object[0])).append(e.getMessage());
            detailMessage = detailMessage.append(entity).append(ResManager.loadKDString((String)"\u4fdd\u5b58\u64cd\u4f5c\u5f02\u5e38\u3002", (String)"OperateExecuteHelper_1", (String)"scmc-conm-business", (Object[])new Object[0])).append(e.getMessage());
            result.setSuccess(false);
            result.setMessage(message.toString());
            result.setDetailMessage(detailMessage.toString());
            return result;
        }
        if (saveResult != null) {
            List saveSuccessPkIds = saveResult.getSuccessPkIds();
            if (saveSuccessPkIds != null && saveResult.isSuccess() && saveSuccessPkIds.size() > 0) {
                result.setSuccess(true);
                result.setSuccessList(saveSuccessPkIds);
            } else {
                List allErrorOrValidateInfo = saveResult.getAllErrorOrValidateInfo();
                for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                    message.append(iOperateInfo.getMessage());
                    detailMessage.append(iOperateInfo.getMessage());
                }
                result.setSuccess(false);
                result.setMessage(message.toString());
                result.setDetailMessage(detailMessage.toString());
                if (saveSuccessPkIds != null && isAllRollback.booleanValue() && !saveSuccessPkIds.isEmpty()) {
                    detailMessage = OperateExecuteHelper.executeRollback4Save(entity, saveSuccessPkIds.toArray(), option, detailMessage);
                    result.setDetailMessage(detailMessage.toString());
                }
            }
        }
        return result;
    }

    public static ReturnResultInfo executeSubmit4Rollback(String entity, Object[] ids, OperateOption option, Boolean isAllRollback) {
        ReturnResultInfo result = new ReturnResultInfo();
        StringBuilder message = new StringBuilder();
        StringBuilder detailMessage = new StringBuilder();
        if (ids == null || StringUtils.isBlank((CharSequence)entity) || ids.length == 0) {
            message.append(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65b9\u6cd5\u53c2\u6570\u540e\u518d\u6b21\u8c03\u7528\u3002", (String)"OperateExecuteHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]));
            detailMessage.append(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65b9\u6cd5\u53c2\u6570\u540e\u518d\u6b21\u8c03\u7528\u3002", (String)"OperateExecuteHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]));
            result.setSuccess(false);
            result.setMessage(message.toString());
            result.setDetailMessage(detailMessage.toString());
            return result;
        }
        List<Object> asList = Arrays.asList(ids);
        option = OperateExecuteHelper.getOperateOption(option);
        OperationResult submitResult = null;
        try {
            submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)entity, (Object[])ids, (OperateOption)option);
        }
        catch (Exception e) {
            message = message.append(entity).append(ResManager.loadKDString((String)"\u63d0\u4ea4\u6267\u884c\u5f02\u5e38\u3002", (String)"OperateExecuteHelper_2", (String)"scmc-conm-business", (Object[])new Object[0])).append(e.getMessage());
            detailMessage = detailMessage.append(entity).append(ResManager.loadKDString((String)"\u63d0\u4ea4\u6267\u884c\u5f02\u5e38\u3002", (String)"OperateExecuteHelper_2", (String)"scmc-conm-business", (Object[])new Object[0])).append(e.getMessage());
            result.setSuccess(false);
            result.setMessage(message.toString());
            result.setDetailMessage(detailMessage.toString());
            detailMessage = OperateExecuteHelper.executeRollback4Submit(entity, ids, option, detailMessage);
            result.setDetailMessage(detailMessage.toString());
            return result;
        }
        if (submitResult != null) {
            List submitSuccessPkIds = submitResult.getSuccessPkIds();
            if (submitSuccessPkIds != null && submitResult.isSuccess() && submitSuccessPkIds.size() > 0) {
                result.setSuccess(true);
                result.setSuccessList(submitSuccessPkIds);
            } else {
                List allErrorOrValidateInfo = submitResult.getAllErrorOrValidateInfo();
                for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                    message.append(iOperateInfo.getMessage());
                    detailMessage.append(iOperateInfo.getMessage());
                }
                if (asList != null && submitSuccessPkIds != null) {
                    asList.removeAll(submitSuccessPkIds);
                }
                result.setSuccess(false);
                result.setMessage(message.toString());
                result.setDetailMessage(detailMessage.toString());
                if (isAllRollback.booleanValue()) {
                    detailMessage = OperateExecuteHelper.executeRollback4Submit(entity, ids, option, detailMessage);
                    result.setDetailMessage(detailMessage.toString());
                } else if (asList != null && !asList.isEmpty()) {
                    detailMessage = OperateExecuteHelper.executeRollback4Submit(entity, asList.toArray(), option, detailMessage);
                    result.setDetailMessage(detailMessage.toString());
                }
            }
        }
        return result;
    }

    public static ReturnResultInfo executeAudit4Rollback(String entity, Object[] ids, OperateOption option, Boolean isAllRollback) {
        ReturnResultInfo result = new ReturnResultInfo();
        StringBuilder message = new StringBuilder();
        StringBuilder detailMessage = new StringBuilder();
        if (ids == null || StringUtils.isBlank((CharSequence)entity) || ids.length == 0) {
            message.append(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65b9\u6cd5\u53c2\u6570\u540e\u518d\u6b21\u8c03\u7528\u3002", (String)"OperateExecuteHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]));
            detailMessage.append(ResManager.loadKDString((String)"\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u65b9\u6cd5\u53c2\u6570\u540e\u518d\u6b21\u8c03\u7528\u3002", (String)"OperateExecuteHelper_0", (String)"scmc-conm-business", (Object[])new Object[0]));
            result.setSuccess(false);
            result.setMessage(message.toString());
            result.setDetailMessage(detailMessage.toString());
            return result;
        }
        List<Object> asList = Arrays.asList(ids);
        option = OperateExecuteHelper.getOperateOption(option);
        OperationResult auditResult = null;
        try {
            auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)entity, (Object[])ids, (OperateOption)option);
        }
        catch (Exception e) {
            message = message.append(entity).append(ResManager.loadKDString((String)"\u5ba1\u6838\u64cd\u4f5c\u5f02\u5e38\u3002", (String)"OperateExecuteHelper_3", (String)"scmc-conm-business", (Object[])new Object[0])).append(e.getMessage());
            detailMessage = detailMessage.append(entity).append(ResManager.loadKDString((String)"\u5ba1\u6838\u64cd\u4f5c\u5f02\u5e38\u3002", (String)"OperateExecuteHelper_3", (String)"scmc-conm-business", (Object[])new Object[0])).append(e.getMessage());
            result.setSuccess(false);
            result.setMessage(message.toString());
            result.setDetailMessage(detailMessage.toString());
            detailMessage = OperateExecuteHelper.executeRollback4Audit(entity, ids, option, detailMessage);
            result.setDetailMessage(detailMessage.toString());
            return result;
        }
        if (auditResult != null) {
            List auditSuccessPkIds = auditResult.getSuccessPkIds();
            if (auditSuccessPkIds != null && auditResult.isSuccess() && auditSuccessPkIds.size() > 0) {
                result.setSuccess(true);
                result.setSuccessList(auditSuccessPkIds);
            } else {
                List allErrorOrValidateInfo = auditResult.getAllErrorOrValidateInfo();
                for (IOperateInfo iOperateInfo : allErrorOrValidateInfo) {
                    message.append(iOperateInfo.getMessage());
                    detailMessage.append(iOperateInfo.getMessage());
                }
                if (asList != null && auditSuccessPkIds != null) {
                    asList.removeAll(auditSuccessPkIds);
                }
                result.setSuccess(false);
                result.setMessage(message.toString());
                result.setDetailMessage(detailMessage.toString());
                if (isAllRollback.booleanValue()) {
                    detailMessage = OperateExecuteHelper.executeRollback4Audit(entity, ids, option, detailMessage);
                    result.setDetailMessage(detailMessage.toString());
                } else if (asList != null && !asList.isEmpty()) {
                    detailMessage = OperateExecuteHelper.executeRollback4Audit(entity, asList.toArray(), option, detailMessage);
                    result.setDetailMessage(detailMessage.toString());
                }
            }
        }
        return result;
    }

    private static StringBuilder executeRollback4Save(String entity, Object[] ids, OperateOption option, StringBuilder detailMessage) {
        try {
            OperationServiceHelper.executeOperate((String)"delete", (String)entity, (Object[])ids, (OperateOption)option);
        }
        catch (Exception e2) {
            detailMessage = detailMessage.append(entity).append(ResManager.loadKDString((String)"\u4fdd\u5b58\u64cd\u4f5c\u5931\u8d25\u65f6\uff0c\u6267\u884c\u56de\u6eda\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38\u3002", (String)"OperateExecuteHelper_4", (String)"scmc-conm-business", (Object[])new Object[0])).append(e2.getMessage());
            return detailMessage;
        }
        return detailMessage;
    }

    private static StringBuilder executeRollback4Submit(String entity, Object[] ids, OperateOption option, StringBuilder detailMessage) {
        try {
            OperationServiceHelper.executeOperate((String)"unsubmit", (String)entity, (Object[])ids, (OperateOption)option);
            OperationServiceHelper.executeOperate((String)"delete", (String)entity, (Object[])ids, (OperateOption)option);
        }
        catch (Exception e2) {
            detailMessage = detailMessage.append(entity).append(ResManager.loadKDString((String)"\u63d0\u4ea4\u64cd\u4f5c\u5931\u8d25\u65f6\uff0c\u6267\u884c\u56de\u6eda\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38\u3002", (String)"OperateExecuteHelper_5", (String)"scmc-conm-business", (Object[])new Object[0])).append(e2.getMessage());
            return detailMessage;
        }
        return detailMessage;
    }

    private static StringBuilder executeRollback4Audit(String entity, Object[] ids, OperateOption option, StringBuilder detailMessage) {
        try {
            OperationServiceHelper.executeOperate((String)"unaudit", (String)entity, (Object[])ids, (OperateOption)option);
            OperationServiceHelper.executeOperate((String)"unsubmit", (String)entity, (Object[])ids, (OperateOption)option);
            OperationServiceHelper.executeOperate((String)"delete", (String)entity, (Object[])ids, (OperateOption)option);
        }
        catch (Exception e2) {
            detailMessage = detailMessage.append(entity).append(ResManager.loadKDString((String)"\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25\u65f6\uff0c\u6267\u884c\u56de\u6eda\u64cd\u4f5c\u53d1\u751f\u5f02\u5e38\u3002", (String)"OperateExecuteHelper_6", (String)"scmc-conm-business", (Object[])new Object[0])).append(e2.getMessage());
            return detailMessage;
        }
        return detailMessage;
    }

    private static OperateOption getOperateOption(OperateOption option) {
        if (option == null) {
            option = OperateOption.create();
        }
        option.setVariableValue("WF", String.valueOf(false));
        option.setVariableValue("ishasright", String.valueOf(Boolean.TRUE));
        option.setVariableValue("isStrict", String.valueOf(Boolean.FALSE));
        option.setVariableValue("ignoreValidation", String.valueOf(Boolean.TRUE));
        option.setVariableValue("ignoreconfirm", String.valueOf(Boolean.TRUE));
        return option;
    }
}

