/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.cooperate.impl.core.subscriber;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.scmc.conm.business.service.cooperate.impl.core.router.IRouter;
import kd.scmc.conm.business.service.cooperate.impl.core.router.MicroServiceRouter;
import kd.scmc.conm.business.service.cooperate.impl.core.subscriber.BaseTopicSubscriber;
import kd.scmc.conm.business.service.cooperate.pojo.CooperateRequest;
import kd.scmc.conm.business.service.cooperate.pojo.CooperateResponse;

public class AttachTopicSubscriber
extends BaseTopicSubscriber {
    private static final HashMap<String, String> entityMap = new HashMap(10);

    public AttachTopicSubscriber(String name, IRouter router) {
        this.name = name;
        this.router = router;
    }

    @Override
    public CooperateResponse invoke(CooperateRequest request) {
        return this.syncFile(request, this.router);
    }

    public CooperateResponse syncFile(CooperateRequest request, IRouter router) {
        CooperateResponse response = new CooperateResponse();
        if (router instanceof MicroServiceRouter) {
            Map result = (Map)router.dispatch(this.wrapperSyncFileRequestArgs(request));
            String success = (String)result.get("success");
            if (!"true".equals(success)) {
                response.setSuccess(Boolean.FALSE);
            }
            response.setMsg((String)result.get("errmsg"));
        }
        return response;
    }

    private HashMap<String, Object> wrapperSyncFileRequestArgs(CooperateRequest request) {
        HashMap<String, Object> map = this.wrapperSyncRequestArgs(request);
        List<DynamicObject> bills = request.getBills();
        if (bills != null && bills.size() > 0) {
            map.put("pkId", bills.get(0).getPkValue());
            String entity = request.getEntity();
            if (!"conm_purcontract".equalsIgnoreCase(entity)) {
                map.put("billentity", entityMap.get(entity));
            }
        }
        return map;
    }

    private HashMap<String, Object> wrapperSyncRequestArgs(CooperateRequest request) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entity", request.getEntity());
        map.put("optype", request.getEvent());
        map.put("operator", request.getOperator());
        map.put("time", request.getTime());
        map.put("bills", request.getBills());
        map.put("fileInfo", request.getData());
        return map;
    }

    static {
        entityMap.put("conm_purcontract", "scc_purchase");
        entityMap.put("conm_xpurcontract", "scc_change");
        entityMap.put("conm_pursupagrt", "scc_supplement");
        entityMap.put("conm_purendagrt", "scc_termination");
    }
}

