/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.writeback.service.pur;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.service.writeback.pojo.TrackData;
import kd.scmc.conm.business.service.writeback.service.pur.AbstractPurWriteService;

public class PurPrePayActualWriteService
extends AbstractPurWriteService {
    @Override
    public boolean match(Map<String, Object> data) {
        String settleRelation = (String)data.get("settleRelation");
        String payBillStatus = (String)data.get("payBillStatus");
        String bizType = (String)data.get("bizType");
        String payMainBillEntity = (String)data.get("payMainBillEntity");
        String srcBillEntity = (String)data.get("srcBillEntity");
        String mainBillEntity = (String)data.get("mainBillEntity");
        String accessType = (String)data.get("accessType");
        if ("AP".equals(accessType) && "payrecsettle".equals(settleRelation) && "202".equals(bizType) && ("F".equals(payBillStatus) || "I".equals(payBillStatus)) && "conm_purcontract".equals(payMainBillEntity) && !"conm_purcontract".equals(srcBillEntity)) {
            return true;
        }
        if ("AP".equals(accessType) && StringUtils.isEmpty((String)settleRelation) && ("conm_purcontract".equals(srcBillEntity) || "pm_purorderbill".equals(srcBillEntity)) && "conm_purcontract".equals(mainBillEntity)) {
            return true;
        }
        return "PAY".equals(accessType) && ("conm_purcontract".equals(srcBillEntity) || "pm_purorderbill".equals(srcBillEntity)) && "conm_purcontract".equals(mainBillEntity);
    }

    @Override
    public void update(DynamicObject bill, List<TrackData> nodes) {
        DynamicObjectCollection payEntry = bill.getDynamicObjectCollection("payentry");
        Map<Object, DynamicObject> entryMap = payEntry.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        Long settleOrgId = 0L;
        if (billentry != null && billentry.size() > 0) {
            settleOrgId = ((DynamicObject)billentry.get(0)).getLong("entrysettleorg.id");
        }
        for (TrackData node : nodes) {
            Long curEntryId = node.getCurEntryId();
            Map leafData = (Map)node.getData();
            BigDecimal paidallamount = bill.getBigDecimal("paidallamount");
            BigDecimal paidpreallamount = bill.getBigDecimal("paidpreallamount");
            BigDecimal settleAmount = (BigDecimal)leafData.get("amount");
            Long arSettleOrgID = (Long)leafData.get("settleOrgID");
            String accessType = (String)leafData.get("accessType");
            if (settleAmount == null) continue;
            BigDecimal newPaidAllAmount = paidallamount.add(settleAmount);
            BigDecimal newPaidPreAllAmount = paidpreallamount.add(settleAmount);
            if (!"PAY".equals(accessType) && !this.directWb(leafData) && (settleAmount == null || settleOrgId == null || arSettleOrgID.compareTo(settleOrgId) != 0)) continue;
            DynamicObject entry = entryMap.get(curEntryId);
            if (curEntryId != null && curEntryId != 0L && entry != null) {
                BigDecimal paidamount = entry.getBigDecimal("paidamount");
                BigDecimal newPaidAmount = paidamount.add(settleAmount);
                entry.set("paidamount", (Object)newPaidAmount);
                trackLog.info("paidamount:{ billno:" + bill.getString("billno") + ",seq:" + entry.getString("seq") + ", oldValue:" + paidamount.toPlainString() + ",newValue:" + newPaidAmount.toPlainString() + "}");
                bill.set("paidallamount", (Object)newPaidAllAmount);
                trackLog.info("paidallamount:{ billno:" + bill.getString("billno") + ",seq:" + entry.getString("seq") + ", oldValue:" + paidallamount.toPlainString() + ",newValue:" + newPaidAllAmount.toPlainString() + "}");
                bill.set("paidpreallamount", (Object)newPaidPreAllAmount);
                trackLog.info("paidpreallamount:{ billno:" + bill.getString("billno") + ",seq:" + entry.getString("seq") + ", oldValue:" + paidpreallamount.toPlainString() + ",newValue:" + newPaidPreAllAmount.toPlainString() + "}");
                continue;
            }
            bill.set("paidallamount", (Object)newPaidAllAmount);
            trackLog.info("paidallamount:{ billno:" + bill.getString("billno") + ", oldValue:" + paidallamount.toPlainString() + ",newValue:" + newPaidAllAmount.toPlainString() + "}");
            bill.set("paidpreallamount", (Object)newPaidPreAllAmount);
            trackLog.info("paidpreallamount:{ billno:" + bill.getString("billno") + ", oldValue:" + paidpreallamount.toPlainString() + ",newValue:" + newPaidPreAllAmount.toPlainString() + "}");
        }
    }

    private boolean directWb(Map<String, Object> data) {
        String settleRelation = (String)data.get("settleRelation");
        String srcBillEntity = (String)data.get("srcBillEntity");
        String mainBillEntity = (String)data.get("mainBillEntity");
        String accessType = (String)data.get("accessType");
        return "AP".equals(accessType) && StringUtils.isEmpty((String)settleRelation) && ("conm_purcontract".equals(srcBillEntity) || "pm_purorderbill".equals(srcBillEntity)) && "conm_purcontract".equals(mainBillEntity);
    }
}

