/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.writeback.service.pur;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.conm.business.service.writeback.pojo.TrackData;
import kd.scmc.conm.business.service.writeback.service.pur.AbstractPurWriteService;

public class PurPrePayWriteService
extends AbstractPurWriteService {
    @Override
    public boolean match(Map<String, Object> data) {
        String settleRelation = (String)data.get("settleRelation");
        String payBillStatus = (String)data.get("payBillStatus");
        String payMainBillEntity = (String)data.get("payMainBillEntity");
        String bizType = (String)data.get("bizType");
        String srcBillEntity = (String)data.get("srcBillEntity");
        String accessType = (String)data.get("accessType");
        if ("AP".equals(accessType) && "payrecsettle".equals(settleRelation) && "202".equals(bizType) && !"F".equals(payBillStatus) && !"I".equals(payBillStatus) && "conm_purcontract".equals(payMainBillEntity)) {
            return true;
        }
        if ("AP".equals(accessType) && "payrecsettle".equals(settleRelation) && "202".equals(bizType) && ("F".equals(payBillStatus) || "I".equals(payBillStatus)) && "conm_purcontract".equals(payMainBillEntity) && "conm_purcontract".equals(srcBillEntity)) {
            return true;
        }
        return "AP".equals(accessType) && "payself".equals(settleRelation) && "202".equals(bizType) && "conm_purcontract".equals(payMainBillEntity);
    }

    @Override
    public void update(DynamicObject bill, List<TrackData> nodes) {
        Long supplier = bill.getLong("supplier.id");
        DynamicObjectCollection payentry = bill.getDynamicObjectCollection("payentry");
        Map<Object, DynamicObject> entryMap = payentry.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        for (TrackData node : nodes) {
            BigDecimal settleAmount;
            Long arSettleOrgID;
            BigDecimal paidallamount = bill.getBigDecimal("paidallamount");
            BigDecimal paidpreallamount = bill.getBigDecimal("paidpreallamount");
            Long curEntryId = node.getCurEntryId();
            Map leafData = (Map)node.getData();
            String accessType = (String)leafData.get("accessType");
            DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
            Long settleOrgId = 0L;
            if (billentry != null && billentry.size() > 0) {
                settleOrgId = ((DynamicObject)billentry.get(0)).getLong("entrysettleorg.id");
            }
            DynamicObject entry = entryMap.get(curEntryId);
            if (curEntryId != null && curEntryId != 0L && entry != null) {
                if (settleOrgId == null) continue;
                arSettleOrgID = (Long)leafData.get("settleOrgID");
                settleAmount = (BigDecimal)leafData.get("amount");
                BigDecimal joinpayamount = entry.getBigDecimal("joinpayamount");
                BigDecimal paidamount = entry.getBigDecimal("paidamount");
                if (!"PAY".equals(accessType) && (settleAmount == null || arSettleOrgID.compareTo(settleOrgId) != 0)) continue;
                BigDecimal newPaidAllAmount = paidallamount.add(settleAmount);
                bill.set("paidallamount", (Object)newPaidAllAmount);
                trackLog.info("paidallamount:{ billno:" + bill.getString("billno") + ",oldValue:" + paidallamount.toPlainString() + ",newValue:" + newPaidAllAmount.toPlainString() + "}");
                BigDecimal newPaidPreAllAmount = paidpreallamount.add(settleAmount);
                bill.set("paidpreallamount", (Object)newPaidPreAllAmount);
                trackLog.info("paidpreallamount:{ billno:" + bill.getString("billno") + ",oldValue:" + paidpreallamount.toPlainString() + ",newValue:" + newPaidPreAllAmount.toPlainString() + "} ");
                BigDecimal newJoinPayAmount = joinpayamount.add(settleAmount);
                entry.set("joinpayamount", (Object)newJoinPayAmount);
                trackLog.info("joinpayamount:{ billno:" + bill.getString("billno") + ",seq:" + entry.getString("seq") + ", oldValue:" + joinpayamount.toPlainString() + ",newValue:" + newJoinPayAmount.toPlainString() + "}");
                BigDecimal newPaidAmount = paidamount.add(settleAmount);
                entry.set("paidamount", (Object)newPaidAmount);
                trackLog.info("paidamount:{ billno:" + bill.getString("billno") + ",seq:" + entry.getString("seq") + ", oldValue:" + paidamount.toPlainString() + ",newValue:" + newPaidAmount.toPlainString() + "}");
                continue;
            }
            if (settleOrgId == null) continue;
            arSettleOrgID = (Long)leafData.get("settleOrgID");
            settleAmount = (BigDecimal)leafData.get("amount");
            if (settleAmount == null || !"PAY".equals(accessType) && arSettleOrgID.compareTo(settleOrgId) != 0) continue;
            BigDecimal newPaidAllAmount = paidallamount.add(settleAmount);
            bill.set("paidallamount", (Object)newPaidAllAmount);
            trackLog.info("paidallamount:{ billno:" + bill.getString("billno") + ",oldValue:" + paidallamount.toPlainString() + ",newValue:" + newPaidAllAmount.toPlainString() + "}");
            BigDecimal newPaidPreAllAmount = paidpreallamount.add(settleAmount);
            bill.set("paidpreallamount", (Object)newPaidPreAllAmount);
            trackLog.info("paidpreallamount:{ billno:" + bill.getString("billno") + ",oldValue:" + paidpreallamount.toPlainString() + ",newValue:" + newPaidPreAllAmount.toPlainString() + "}");
        }
    }
}

