/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.writeback.service.sal;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.conm.business.service.writeback.pojo.TrackData;
import kd.scmc.conm.business.service.writeback.service.sal.AbstractSalWriteService;

public class SalRecHeadWriteService
extends AbstractSalWriteService {
    @Override
    public boolean match(Map<String, Object> data) {
        String settleRelation = (String)data.get("settleRelation");
        String arMainBillEntity = (String)data.get("arMainBillEntity");
        Long arMainBillID = (Long)data.get("arMainBillID");
        String bizType = (String)data.get("bizType");
        String recMainBillEntity = (String)data.get("recMainBillEntity");
        boolean confirmLogo = data.get("confirmLogo") != null ? (Boolean)data.get("confirmLogo") : false;
        Long recMainBillID = (Long)data.get("recMainBillID");
        String accessType = (String)data.get("accessType");
        if ("AR".equals(accessType) && "recsettle".equals(settleRelation) && !"101".equals(bizType) && ("sm_salorder".equals(arMainBillEntity) || "conm_salcontract".equals(arMainBillEntity)) && arMainBillID != null && arMainBillID != 0L && !confirmLogo) {
            return true;
        }
        if ("AR".equals(accessType) && "arpaysettle".equals(settleRelation) && !"204".equals(bizType) && ("conm_salcontract".equals(arMainBillEntity) || "sm_salorder".equals(arMainBillEntity)) && arMainBillID != null && arMainBillID != 0L) {
            return true;
        }
        if ("AR".equals(accessType) && ("aparsettle".equals(settleRelation) || "arapsettle".equals(settleRelation) || "artransfer".equals(settleRelation) || "arliqsettle".equals(settleRelation) || "baddebtloss".equals(settleRelation)) && ("conm_salcontract".equals(arMainBillEntity) || "sm_salorder".equals(arMainBillEntity)) && arMainBillID != null && arMainBillID != 0L) {
            return true;
        }
        if ("AR".equals(accessType) && "recpaysettle".equals(settleRelation) && !"101".equals(bizType) && "sm_salorder".equals(recMainBillEntity) && recMainBillID != null && recMainBillID != 0L && confirmLogo) {
            return true;
        }
        if ("AR".equals(accessType) && "recself".equals(settleRelation) && !"101".equals(bizType) && "sm_salorder".equals(arMainBillEntity) && arMainBillID != null && arMainBillID != 0L && confirmLogo && (recMainBillID == null || recMainBillID == 0L)) {
            return true;
        }
        if ("AR".equals(accessType) && "recclearing".equals(settleRelation) && !"101".equals(bizType) && "sm_salorder".equals(recMainBillEntity) && recMainBillID != null && recMainBillID != 0L && confirmLogo) {
            return true;
        }
        return "REC".equals(accessType) && !"101".equals(bizType) && "sm_salorder".equals(recMainBillEntity) && confirmLogo && recMainBillID != null && recMainBillID != 0L;
    }

    @Override
    public void update(DynamicObject bill, List<TrackData> nodes) {
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        Map<Object, DynamicObject> entryMap = billentry.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        for (TrackData node : nodes) {
            DynamicObject entry;
            BigDecimal receiptallamount = bill.getBigDecimal("receiptallamount");
            Long curEntryId = node.getCurEntryId();
            Map leafData = (Map)node.getData();
            Long arSettleOrgID = (Long)leafData.get("settleOrgID");
            BigDecimal settleAmount = (BigDecimal)leafData.get("amount");
            String accessType = (String)leafData.get("accessType");
            if (settleAmount == null) continue;
            BigDecimal amount = receiptallamount.add(settleAmount);
            if ("REC".equals(accessType)) {
                bill.set("receiptallamount", (Object)amount);
                trackLog.info("receiptallamount:{ billno:" + bill.getString("billno") + " ,oldValue:" + receiptallamount.toPlainString() + ",newValue:" + amount.toPlainString() + "}");
                continue;
            }
            if (curEntryId == null || curEntryId == 0L || (entry = entryMap.get(curEntryId)) == null) continue;
            Long settleOrgId = entry.getLong("entrysettleorg.id");
            if (settleAmount == null || arSettleOrgID.compareTo(settleOrgId) != 0) continue;
            bill.set("receiptallamount", (Object)amount);
            trackLog.info("receiptallamount:{ billno:" + bill.getString("billno") + ",oldValue:" + receiptallamount.toPlainString() + ",newValue:" + amount.toPlainString() + "}");
        }
    }
}

