/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.business.service.writeback.service.sal;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.scmc.conm.business.service.writeback.pojo.TrackData;
import kd.scmc.conm.business.service.writeback.service.sal.AbstractSalWriteService;

public class SalRecPlanWriteService
extends AbstractSalWriteService {
    @Override
    public boolean match(Map<String, Object> data) {
        String settleRelation = (String)data.get("settleRelation");
        String bizType = (String)data.get("bizType");
        String recMainBillEntity = (String)data.get("recMainBillEntity");
        boolean confirmLogo = data.get("confirmLogo") != null ? (Boolean)data.get("confirmLogo") : false;
        Long recMainBillID = (Long)data.get("recMainBillID");
        String accessType = (String)data.get("accessType");
        String arMainBillEntity = (String)data.get("arMainBillEntity");
        Long arMainBillID = (Long)data.get("arMainBillID");
        if ("AR".equals(accessType) && "recpaysettle".equals(settleRelation) && !"101".equals(bizType) && "conm_salcontract".equals(recMainBillEntity) && recMainBillID != null && recMainBillID != 0L && confirmLogo) {
            return true;
        }
        if ("AR".equals(accessType) && "recself".equals(settleRelation) && !"101".equals(bizType) && "conm_salcontract".equals(arMainBillEntity) && arMainBillID != null && arMainBillID != 0L && confirmLogo && (recMainBillID == null || recMainBillID == 0L)) {
            return true;
        }
        if ("AR".equals(accessType) && "recclearing".equals(settleRelation) && !"101".equals(bizType) && "conm_salcontract".equals(recMainBillEntity) && recMainBillID != null && recMainBillID != 0L && confirmLogo) {
            return true;
        }
        return "REC".equals(accessType) && !"101".equals(bizType) && "conm_salcontract".equals(recMainBillEntity) && recMainBillID != null && recMainBillID != 0L && confirmLogo;
    }

    @Override
    public void update(DynamicObject bill, List<TrackData> nodes) {
        DynamicObjectCollection payentry = bill.getDynamicObjectCollection("payentry");
        Map<Object, DynamicObject> entryMap = payentry.stream().collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v));
        DynamicObjectCollection billentry = bill.getDynamicObjectCollection("billentry");
        Long firstEntrySettleOrgId = 0L;
        if (billentry != null && billentry.size() > 0) {
            firstEntrySettleOrgId = ((DynamicObject)billentry.get(0)).getLong("entrysettleorg.id");
        }
        for (TrackData node : nodes) {
            BigDecimal receiptallamount = bill.getBigDecimal("receiptallamount");
            Long curEntryId = node.getCurEntryId();
            Map leafData = (Map)node.getData();
            String accessType = (String)leafData.get("accessType");
            DynamicObject entry = entryMap.get(curEntryId);
            if (curEntryId != null && curEntryId != 0L && entry != null) {
                Long settleOrgId = entry.getLong("recentrysettleorg.id");
                if (settleOrgId == null) continue;
                Long arSettleOrgID = (Long)leafData.get("settleOrgID");
                BigDecimal settleAmount = (BigDecimal)leafData.get("amount");
                BigDecimal joinpayamount = entry.getBigDecimal("joinpayamount");
                BigDecimal paidamount = entry.getBigDecimal("paidamount");
                if (!"REC".equals(accessType) && (settleAmount == null || arSettleOrgID.compareTo(settleOrgId) != 0)) continue;
                BigDecimal newReceiptAllAmount = receiptallamount.add(settleAmount);
                bill.set("receiptallamount", (Object)newReceiptAllAmount);
                trackLog.info("receiptallamount:{ billno:" + bill.getString("billno") + ",oldValue:" + receiptallamount.toPlainString() + ",newValue:" + newReceiptAllAmount.toPlainString() + "}");
                BigDecimal newJoinPayAmount = joinpayamount.add(settleAmount);
                entry.set("joinpayamount", (Object)newJoinPayAmount);
                trackLog.info("joinpayamount:{ billno:" + bill.getString("billno") + ",seq:" + entry.getString("seq") + ", oldValue:" + joinpayamount.toPlainString() + ",newValue:" + newJoinPayAmount.toPlainString() + "}");
                BigDecimal newPaidAmount = paidamount.add(settleAmount);
                entry.set("paidamount", (Object)newPaidAmount);
                trackLog.info("paidamount:{ billno:" + bill.getString("billno") + ",seq:" + entry.getString("seq") + ", oldValue:" + paidamount.toPlainString() + ",newValue:" + newPaidAmount.toPlainString() + "}");
                continue;
            }
            if (firstEntrySettleOrgId == null) continue;
            Long arSettleOrgID = (Long)leafData.get("settleOrgID");
            BigDecimal settleAmount = (BigDecimal)leafData.get("amount");
            if (settleAmount == null || !"REC".equals(accessType) && arSettleOrgID.compareTo(firstEntrySettleOrgId) != 0) continue;
            BigDecimal newReceiptAllAmount = receiptallamount.add(settleAmount);
            bill.set("receiptallamount", (Object)newReceiptAllAmount);
            trackLog.info("receiptallamount:{ billno:" + bill.getString("billno") + ",oldValue:" + receiptallamount.toPlainString() + ",newValue:" + newReceiptAllAmount.toPlainString() + "}");
        }
    }
}

