/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.utils;

import com.google.common.hash.Hashing;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.DataEntitySerializerOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.exception.KDBizException;

public class CommonUtils {
    private CommonUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isNull(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof String && ((String)o).length() == 0) {
            return true;
        }
        if (o instanceof StringBuffer && ((StringBuffer)o).length() == 0) {
            return true;
        }
        if (o instanceof List && ((List)o).isEmpty()) {
            return true;
        }
        if (o instanceof Collection && ((Collection)o).isEmpty()) {
            return true;
        }
        if (o instanceof Object[] && ((Object[])o).length == 0) {
            return true;
        }
        return o instanceof Map && ((Map)o).size() == 0;
    }

    public static boolean isRealChanged(ChangeData changeSet) {
        if (changeSet == null) {
            return false;
        }
        Object oldObject = changeSet.getOldValue();
        Object newObject = changeSet.getNewValue();
        return CommonUtils.isRealChanged(oldObject, newObject);
    }

    public static boolean isRealChanged(Object oldObject, Object newObject) {
        if (oldObject == null && newObject == null) {
            return true;
        }
        if (oldObject == null) {
            return true;
        }
        if (newObject == null) {
            return true;
        }
        if (oldObject instanceof BigDecimal) {
            if (newObject instanceof BigDecimal && ((BigDecimal)oldObject).compareTo((BigDecimal)newObject) != 0) {
                return true;
            }
            if (newObject instanceof String && ((BigDecimal)oldObject).compareTo(new BigDecimal(newObject.toString())) != 0) {
                return true;
            }
        } else if (oldObject.getClass().isAssignableFrom(newObject.getClass())) {
            if (newObject instanceof DynamicObject) {
                if (!((DynamicObject)newObject).getPkValue().equals(((DynamicObject)oldObject).getPkValue())) {
                    return true;
                }
            } else if (newObject instanceof OrmLocaleValue) {
                if (!((OrmLocaleValue)oldObject).getLocaleValue().equals(((OrmLocaleValue)newObject).getLocaleValue())) {
                    return true;
                }
            } else {
                return !oldObject.equals(newObject);
            }
        }
        return false;
    }

    public static String serializerDynamicObjectList(List<DynamicObject> list, IDataEntityType dt) {
        if (CommonUtils.isNull(list)) {
            return null;
        }
        DataEntitySerializerOption option = new DataEntitySerializerOption();
        String[] ss = DataEntitySerializer.serializerToListString((IDataEntityType)dt, list, (DataEntitySerializerOption)option);
        return SerializationUtils.toJsonString((Object)ss);
    }

    public static List<DynamicObject> deserializerDynamicObjectList(List<DynamicObject> list, IDataEntityType dt, String s) {
        String[] ss = (String[])SerializationUtils.fromJsonString((String)s, String[].class);
        DataEntitySerializer.deserializerFromListString(list, (IDataEntityType)dt, (String[])ss);
        return list;
    }

    public static List<Long> getIdList(DynamicObjectCollection colls) {
        ArrayList<Long> idList = new ArrayList<Long>();
        for (DynamicObject obj : colls) {
            idList.add(obj.getLong("id"));
        }
        return idList;
    }

    public static String urlEncode(String url, String enc) {
        if (kd.bos.util.StringUtils.isEmpty((String)url)) {
            return "";
        }
        try {
            return URLEncoder.encode(url, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException("encode UnsupportedEncodingException:" + url + " " + e.getMessage());
        }
    }

    public static String urlDecode(String url, String enc) {
        if (kd.bos.util.StringUtils.isEmpty((String)url)) {
            return "";
        }
        try {
            return URLDecoder.decode(url, enc);
        }
        catch (UnsupportedEncodingException e) {
            throw new KDBizException("decode UnsupportedEncodingException :" + url + " " + e.getMessage());
        }
    }

    public static String getOpValidateMessage(String operateName, List<String> param) {
        String format = "";
        if (param.size() > 0) {
            String join = StringUtils.join((Object[])param.toArray(), (String)"\u3001");
            format = String.format(ResManager.loadKDString((String)"\u53ea\u6709%1$s\u7684\u6570\u636e\u624d\u5141\u8bb8\u201c%2$s\u201d\u3002", (String)"CommonUtils_0", (String)"scmc-conm-common", (Object[])new Object[0]), join, operateName);
        }
        return format;
    }

    public static String setToString(Set valueSet) {
        StringBuilder returnValue = new StringBuilder();
        returnValue.append('(');
        if (valueSet != null && valueSet.size() != 0) {
            Iterator it = valueSet.iterator();
            boolean flag = false;
            String tempValue = null;
            Object obj = null;
            while (it.hasNext()) {
                obj = it.next();
                tempValue = obj instanceof String ? (String)obj : obj.toString();
                if (tempValue == null || tempValue.trim().length() == 0) continue;
                if (flag) {
                    returnValue.append(',');
                }
                returnValue.append('\'');
                returnValue.append(tempValue);
                returnValue.append('\'');
                flag = true;
            }
        } else {
            returnValue.append("'null'");
        }
        returnValue.append(')');
        return returnValue.toString();
    }

    public static String sha256Base16(byte[] bytes) {
        return Hashing.sha256().hashBytes(bytes).toString();
    }
}

