/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.webapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Map;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.api.WebApiContext;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.conm.business.helper.ElecSignHelper;
import kd.scmc.conm.business.helper.HttpClientHelper;
import kd.scmc.conm.business.pojo.ElecHttpResult;

public class SignResultWebApiPlugin
implements IBillWebApiPlugin {
    private static Log logger = LogFactory.getLog(SignResultWebApiPlugin.class);
    private static String[] formIds = new String[]{"conm_purcontract", "conm_salcontract", "conm_pursupagrt", "conm_salsupagrt", "conm_purendagrt", "conm_salendagrt"};

    public String getVersion() {
        return "1.1";
    }

    public ApiResult doCustomService(WebApiContext ctx) {
        String requestURL = ctx.getRequestURL();
        Map queryString = ctx.getQueryString();
        Map data = ctx.getData();
        logger.info("\u8bf7\u6c42\u8def\u5f84\uff1a" + requestURL);
        logger.info("\u8bf7\u6c42queryString\uff1a" + JSON.toJSONString((Object)queryString));
        logger.info("\u8bf7\u6c42body\uff1a" + JSON.toJSONString((Object)data));
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ApiResult doCustomService(Map<String, Object> params) {
        String billno = null;
        logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1a\u7b7e\u7ae0\u56de\u8c03\u53c2\u6570\uff1a" + JSON.toJSONString(params));
        if (CollectionUtils.isEmpty(params)) {
            logger.warn("\u7535\u5b50\u7b7e\u7ae0\uff1abillno:" + billno + "; \u5f02\u6b65\u4fe1\u606f\u901a\u77e5\u4fe1\u606f\u4e3a\u7a7a");
            return ApiResult.fail((String)ResManager.loadKDString((String)"\u5f02\u6b65\u901a\u77e5\u5185\u5bb9\u4e3a\u7a7a", (String)"SignResultWebApiPlugin_10", (String)"scmc-conm-webapi", (Object[])new Object[0]), (String)"500");
        }
        try {
            DynamicObject contract;
            block23: {
                String pkid;
                String formId;
                String contractname;
                String signstatus;
                String party2nd;
                String name;
                String createTime;
                String contractNo;
                String uuid;
                String kdappid;
                block22: {
                    kdappid = params.get("kdAppId").toString();
                    QFilter kdappidFilter = new QFilter("kdappid", "=", (Object)kdappid);
                    QFilter resultcode = new QFilter("resultcode", "=", (Object)"1");
                    DynamicObject object = BusinessDataServiceHelper.loadSingle((String)"contractsubject", (String)"id,uuid,resultcode,resultdesc", (QFilter[])new QFilter[]{kdappidFilter.and(resultcode)});
                    if (object == null) {
                        logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1a\u83b7\u53d6kdappid\u4e3a:" + kdappid + "\u7684contractsubject\u5931\u8d25");
                        throw new KDException(new ErrorCode("sign notify error", String.format(ResManager.loadKDString((String)"\u83b7\u53d6uuid\u5931\u8d25,param:kdappid:%1$s", (String)"SignResultWebApiPlugin_0", (String)"scmc-conm-webapi", (Object[])new Object[0]), kdappid)), new Object[0]);
                    }
                    uuid = object.getString("uuid");
                    String sign = params.get("sign").toString();
                    if (StringUtils.isEmpty((String)uuid) || StringUtils.isEmpty((String)sign)) {
                        logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1a\u83b7\u53d6uuid\u5931\u8d25\uff1auuid=" + uuid);
                        throw new KDException(new ErrorCode("sign notify error", MessageFormat.format(ResManager.loadKDString((String)"\u83b7\u53d6uuid\u5931\u8d25,param:kdappid:{0}; uuid:{1}", (String)"SignResultWebApiPlugin_11", (String)"scmc-conm-webapi", (Object[])new Object[0]), kdappid, uuid)), new Object[0]);
                    }
                    String signStr = HttpClientHelper.decryptAES((String)uuid, (String)sign);
                    logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1a\u56de\u8c03\u7b7e\u7ae0\u53c2\u6570" + signStr);
                    if (StringUtils.isEmpty((String)signStr)) {
                        logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1a\u89e3\u5bc6\u5931\u8d25\uff1a" + JSON.toJSONString((Object)signStr));
                        throw new KDException(new ErrorCode("sign notify error", MessageFormat.format(ResManager.loadKDString((String)"AES\u89e3\u5bc6\u5931\u8d25,param:kdappid:{0}; uuid:{1}", (String)"SignResultWebApiPlugin_1", (String)"scmc-conm-webapi", (Object[])new Object[0]), kdappid, uuid)), new Object[0]);
                    }
                    JSONObject jsonObject = (JSONObject)JSON.parse((String)signStr);
                    JSONObject data = (JSONObject)jsonObject.get((Object)"data");
                    String resultCode = (String)data.get((Object)"resultCode");
                    billno = contractNo = data.get((Object)"contractNo").toString();
                    createTime = data.get((Object)"createTime").toString();
                    String userId = data.get((Object)"userId").toString();
                    if (!"1".equalsIgnoreCase(resultCode)) {
                        logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1a billno:" + billno + ";\u7b7e\u7f72\u8fd4\u56de\u72b6\u6001:\u5931\u8d25");
                        throw new KDException(new ErrorCode("sign notify error", String.format(ResManager.loadKDString((String)"\u7b7e\u7f72\u5931\u8d25billno:%s", (String)"SignResultWebApiPlugin_2", (String)"scmc-conm-webapi", (Object[])new Object[0]), contractNo)), new Object[0]);
                    }
                    QFilter filter = new QFilter("companyid", "=", (Object)userId);
                    name = null;
                    DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"contractsubject", (String)"id,fiorg.ffirmname,resultcode,resultdesc", (QFilter[])new QFilter[]{filter});
                    if (dynamicObjects == null || dynamicObjects.length <= 0) {
                        dynamicObjects = BusinessDataServiceHelper.load((String)"companyauth", (String)"id,bizpartner.name,resultcode,resultdesc", (QFilter[])new QFilter[]{filter});
                        if (dynamicObjects == null || dynamicObjects.length <= 0) {
                            logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1abillno:" + contractNo + "\u4e0d\u5b58\u5728companyid\u4e3a" + userId + "\u7684\u6570\u636e");
                            throw new KDException(new ErrorCode("sign notify error", MessageFormat.format(ResManager.loadKDString((String)"billno:{0}\u4e0d\u5b58\u5728companyid\u4e3a{1}\u7684\u6570\u636e", (String)"SignResultWebApiPlugin_3", (String)"scmc-conm-webapi", (Object[])new Object[0]), contractNo, userId)), new Object[0]);
                        }
                        if (dynamicObjects.length != 1) {
                            logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1abillno:" + contractNo + " ;\u5728companyauth\u627e\u5230\u591a\u4e2acompanyid\u4e3a" + userId + "\u7684\u6570\u636e");
                            throw new KDException(new ErrorCode("sign notify error", MessageFormat.format(ResManager.loadKDString((String)"billno:{0};\u5728companyauth\u627e\u5230\u591a\u4e2acompanyid\u4e3a{1}\u7684\u6570\u636e", (String)"SignResultWebApiPlugin_5", (String)"scmc-conm-webapi", (Object[])new Object[0]), contractNo, userId)), new Object[0]);
                        }
                        name = dynamicObjects[0].getString("bizpartner.name");
                    } else {
                        if (dynamicObjects.length != 1) {
                            logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1abillno:" + contractNo + "\u5b58\u5728\u591a\u4e2acompanyid\u4e3a" + userId + "\u7684\u6570\u636e");
                            return ApiResult.fail(null);
                        }
                        name = dynamicObjects[0].getString("fiorg.ffirmname");
                    }
                    if (StringUtils.isEmpty((String)name)) {
                        logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1abillno:" + contractNo + ";\u5728contractsubject\u6216companyauth\u4e2d\u627e\u5230\u4e86companyid\u4e3a" + userId + "\u7684\u6570\u636e\uff0c\u4f46\u540d\u79f0\u4e3a\u7a7a");
                        throw new KDException(new ErrorCode("sign notify error", MessageFormat.format(ResManager.loadKDString((String)"billno:{0};\u5728contractsubject\u6216companyauth\u4e2d\u627e\u5230\u4e86companyid\u4e3a{1}\u7684\u6570\u636e\uff0c\u4f46\u540d\u79f0\u4e3a\u7a7a", (String)"SignResultWebApiPlugin_6", (String)"scmc-conm-webapi", (Object[])new Object[0]), contractNo, userId)), new Object[0]);
                    }
                    QFilter billnoFilter = new QFilter("billno", "=", (Object)contractNo);
                    QFilter billstatus = new QFilter("billstatus", "=", (Object)"C");
                    QFilter party1stFilter = new QFilter("party1st", "=", (Object)name);
                    QFilter party2ndFilter = new QFilter("party2nd", "=", (Object)name);
                    QFilter and = billnoFilter.and(billstatus).and(party1stFilter.or(party2ndFilter));
                    contract = null;
                    for (String formId2 : formIds) {
                        DynamicObject[] contracts = BusinessDataServiceHelper.load((String)formId2, (String)"id,billname,signstatus,signer,signdate,party1st,party2nd", (QFilter[])new QFilter[]{and});
                        if (contracts == null || contracts.length <= 0) continue;
                        contract = contracts[0];
                        break;
                    }
                    if (contract == null) {
                        logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1abillno:" + contractNo + ";\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5408\u540c\u7f16\u7801\u7b49\u4e8e" + contractNo + "\u7532\u4e59\u65b9\u540d\u79f0\u7b49\u4e8e" + name + "\u7684\u6570\u636e");
                        throw new KDException(new ErrorCode("sign notify error", MessageFormat.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\u5408\u540c\u7f16\u7801\u7b49\u4e8e{0},\u7532\u4e59\u65b9\u540d\u79f0\u7b49\u4e8e{1}\u7684\u6570\u636e", (String)"SignResultWebApiPlugin_8", (String)"scmc-conm-webapi", (Object[])new Object[0]), contractNo, name)), new Object[0]);
                    }
                    String party1st = contract.getString("party1st");
                    party2nd = contract.getString("party2nd");
                    signstatus = contract.getString("signstatus");
                    contractname = contract.getString("billname");
                    formId = contract.getDataEntityType().getName();
                    Long pkValue = (Long)contract.getPkValue();
                    pkid = String.valueOf(pkValue);
                    if (!name.equalsIgnoreCase(party1st)) break block22;
                    if ("F".equalsIgnoreCase(signstatus)) {
                        contract.set("signstatus", (Object)"E");
                        contract.set("signdate", (Object)new Date(Long.parseLong(createTime)));
                        break block23;
                    } else if ("D".equalsIgnoreCase(signstatus)) {
                        contract.set("signstatus", (Object)"B");
                        contract.set("signdate", (Object)new Date(Long.parseLong(createTime)));
                        ElecHttpResult signFile = ElecSignHelper.downloadSignFile((String)kdappid, (String)uuid, (String)formId, (String)pkid, (String)contractNo, (String)contractname);
                        logger.info("\u7535\u5b50\u7b7e\u7ae0\uff1a\u4e0b\u8f7d\u7ed3\u679c:" + (signFile.getCode().equals("0") ? "\u6210\u529f" : "\u5931\u8d25") + "; msg:formid:" + formId + "; pkid:" + pkid + " ;billno:" + contractNo);
                    }
                    break block23;
                }
                if (name.equalsIgnoreCase(party2nd)) {
                    if ("F".equalsIgnoreCase(signstatus)) {
                        contract.set("signstatus", (Object)"D");
                        contract.set("signdate", (Object)new Date(Long.parseLong(createTime)));
                    } else if ("E".equalsIgnoreCase(signstatus)) {
                        contract.set("signstatus", (Object)"B");
                        contract.set("signdate", (Object)new Date(Long.parseLong(createTime)));
                        ElecHttpResult signFile = ElecSignHelper.downloadSignFile((String)kdappid, (String)uuid, (String)formId, (String)pkid, (String)contractNo, (String)contractname);
                        logger.info("\u7535\u5b50\u7b7e\u7ae0\uff1a\u4e0b\u8f7d\u7ed3\u679c:" + (signFile.getCode().equals("0") ? "\u6210\u529f" : "\u5931\u8d25") + "; msg:formid:" + formId + "; pkid:" + pkid + " ;billno:" + contractNo);
                    }
                }
            }
            logger.info("\u7535\u5b50\u7b7e\u7ae0\uff1a  \u4fdd\u5b58\u6210\u529f");
            SaveServiceHelper.update((DynamicObject)contract);
        }
        catch (Exception e) {
            logger.error("\u7535\u5b50\u7b7e\u7ae0\uff1abillno:" + billno + ";\u5f02\u6b65\u4fe1\u606f\u901a\u77e5\u5931\u8d25\uff1a" + e.getMessage());
            return ApiResult.ex((Throwable)e);
        }
        logger.info("\u7535\u5b50\u7b7e\u7ae0\uff1a \u56de\u8c03\u6210\u529fbillno:" + billno);
        return ApiResult.success(null);
    }
}

