/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;
import kd.scmc.conm.enums.FilingStatusEnum;
import kd.scmc.conm.validation.ContractFilingValidator;

public class ContractFilingApplyOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("srcbillentity");
        e.getFieldKeys().add("auditor");
        e.getFieldKeys().add("auditdate");
        e.getFieldKeys().add("lastupdateuser");
        e.getFieldKeys().add("lastupdatetime");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ContractFilingValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        DynamicObject user = UserServiceHelper.getCurrentUser((String)"id");
        Date now = TimeServiceHelper.now();
        for (DynamicObject bill : bills) {
            bill.set("lastupdateuser", (Object)user);
            bill.set("lastupdatetime", (Object)now);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        HashMap map = new HashMap();
        DynamicObject filinger = null;
        Date filingdate = null;
        for (DynamicObject entity : e.getDataEntities()) {
            String srcbillentity = entity.getString("srcbillentity");
            Long srcbillid = entity.getLong("srcbillid");
            filinger = entity.getDynamicObject("auditor");
            filingdate = entity.getDate("auditdate");
            if (StringUtils.isEmpty((String)srcbillentity) || srcbillid == null || srcbillid == 0L) {
                return;
            }
            ArrayList list = (ArrayList)map.get(srcbillentity);
            if (list != null) {
                list.add(entity.getLong("srcbillid"));
                map.put(srcbillentity, list);
                continue;
            }
            ArrayList<Long> list1 = new ArrayList<Long>();
            list1.add(entity.getLong("srcbillid"));
            map.put(srcbillentity, list1);
        }
        Set entrySet = map.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            DynamicObject[] contracts;
            String key = (String)iterator.next().getKey();
            ArrayList longs = (ArrayList)map.get(key);
            for (DynamicObject c : contracts = BusinessDataServiceHelper.load((Object[])longs.toArray(), (DynamicObjectType)BusinessDataServiceHelper.newDynamicObject((String)key).getDynamicObjectType())) {
                this.changeReviewStatus(e.getOperationKey(), c, filinger, filingdate);
            }
            SaveServiceHelper.save((DynamicObject[])contracts);
        }
    }

    private void changeReviewStatus(String operationKey, DynamicObject c, DynamicObject filinger, Date filingdate) {
        switch (operationKey) {
            case "audit": {
                c.set("filingstatus", (Object)FilingStatusEnum.FILED.getValue());
                c.set("filinger", (Object)filinger);
                c.set("filingdate", (Object)filingdate);
                break;
            }
            case "unaudit": {
                c.set("filingstatus", (Object)FilingStatusEnum.UNFILED.getValue());
                c.set("filinger", null);
                c.set("filingdate", null);
                break;
            }
        }
    }
}

