/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.agreement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.conm.business.helper.TaskHelper;
import kd.scmc.conm.validation.agreement.EndAgreementValidator;

public class EndAgreementValidOp
extends AbstractOperationServicePlugIn {
    private static final Log LOG = LogFactory.getLog(EndAgreementValidOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("biztimeend");
        e.getFieldKeys().add("srcbillid");
        e.getFieldKeys().add("srcbillentity");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new EndAgreementValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] srcBillsSal;
        DynamicObject[] srcBillsPur;
        super.endOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        if (bills.length == 0) {
            return;
        }
        ArrayList<Long> srcBillIdsPur = new ArrayList<Long>(bills.length);
        ArrayList<Long> srcBillIdsSal = new ArrayList<Long>(bills.length);
        for (DynamicObject dynamicObject : bills) {
            Long srcBillId = dynamicObject.getLong("srcbillid");
            if (srcBillId == null || srcBillId == 0L) continue;
            String srcEntityName = dynamicObject.getString("srcbillentity");
            String billName = dynamicObject.getDataEntityType().getName();
            if (Objects.equals("conm_purendagrt", billName) && Objects.equals("conm_purcontract", srcEntityName)) {
                srcBillIdsPur.add(srcBillId);
                continue;
            }
            if (!Objects.equals("conm_salendagrt", billName) || !Objects.equals("conm_salcontract", srcEntityName)) continue;
            srcBillIdsSal.add(srcBillId);
        }
        HashMap<Long, DynamicObject> srcBillsMapPur = new HashMap<Long, DynamicObject>(srcBillIdsPur.size());
        MainEntityType typePur = EntityMetadataCache.getDataEntityType((String)"conm_purcontract");
        for (DynamicObject srcBill : srcBillsPur = BusinessDataServiceHelper.load((Object[])srcBillIdsPur.toArray(), (DynamicObjectType)typePur)) {
            if (srcBill == null || srcBill.getPkValue() == null) continue;
            srcBillsMapPur.put((Long)srcBill.getPkValue(), srcBill);
        }
        HashMap<Long, DynamicObject> hashMap = new HashMap<Long, DynamicObject>(srcBillIdsSal.size());
        MainEntityType typeSal = EntityMetadataCache.getDataEntityType((String)"conm_salcontract");
        for (DynamicObject srcBill : srcBillsSal = BusinessDataServiceHelper.load((Object[])srcBillIdsSal.toArray(), (DynamicObjectType)typeSal)) {
            if (srcBill == null || srcBill.getPkValue() == null) continue;
            hashMap.put((Long)srcBill.getPkValue(), srcBill);
        }
        for (DynamicObject bill : bills) {
            DynamicObject salContract;
            long srcBillId = bill.getLong("srcbillid");
            String billno = bill.getString("billno");
            if (0L == srcBillId) {
                LOG.error(String.format(ResManager.loadKDString((String)"\u534f\u8bae\u7f16\u53f7\u201c%s\u201d\u6765\u6e90\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6765\u6e90\u4fe1\u606f\u662f\u5426\u5b8c\u6574\u3002", (String)"EndAgreementValidOp_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), billno));
                throw new KDBizException(ResManager.loadKDString((String)"\u6765\u6e90\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6765\u6e90\u4fe1\u606f\u662f\u5426\u5b8c\u6574\u3002 ", (String)"EndAgreementValidOp_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]));
            }
            String billName = bill.getDataEntityType().getName();
            String srcEntityName = bill.getString("srcbillentity");
            if (Objects.equals("conm_purendagrt", billName) && Objects.equals("conm_purcontract", srcEntityName)) {
                DynamicObject purContract = (DynamicObject)srcBillsMapPur.get(srcBillId);
                if (purContract == null) continue;
                TaskHelper.executeOpIgnoreTip((String)"bizterminate", (String)"conm_purcontract", (DynamicObject[])new DynamicObject[]{purContract});
                continue;
            }
            if (!Objects.equals("conm_salendagrt", billName) || !Objects.equals("conm_salcontract", srcEntityName) || (salContract = (DynamicObject)hashMap.get(srcBillId)) == null) continue;
            TaskHelper.executeOpIgnoreTip((String)"bizterminate", (String)"conm_salcontract", (DynamicObject[])new DynamicObject[]{salContract});
        }
    }
}

