/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.contract;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.mpscmm.msbd.business.helper.InvoiceBiztypeHelper;
import kd.scmc.conm.business.helper.SupplierHelper;
import kd.scmc.conm.validation.contract.ContractSettleOrgValidator;
import kd.scmc.conm.validation.contract.ContractSubmitValidator;
import kd.scmc.conm.validation.contract.PurContractBlockedValidator;
import kd.scmc.conm.validation.contract.PurContractInvoiceBizTypeValidator;
import kd.scmc.conm.validation.contract.PurContractSouceControlValidator;
import kd.scmc.conm.validation.tpl.ContractSuitOrgValidator;

public class PmContractSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("billno");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("supplier");
        e.getFieldKeys().add("providersupplier");
        e.getFieldKeys().add("providerlinkman");
        e.getFieldKeys().add("providerphone");
        e.getFieldKeys().add("provideraddress");
        e.getFieldKeys().add("invoicesupplier");
        e.getFieldKeys().add("receivesupplier");
        e.getFieldKeys().add("ecostcenter");
        e.getFieldKeys().add("entryreqorg");
        e.getFieldKeys().add("invoicebiztype");
        e.getFieldKeys().add("suitscope");
        e.getFieldKeys().add("suitorg");
        e.getFieldKeys().add("biztimebegin");
        e.getFieldKeys().add("biztimeend");
        e.getFieldKeys().add("framename");
        e.getFieldKeys().add("framenum");
        e.getFieldKeys().add("frameversion");
        e.getFieldKeys().add("isrenew");
        e.getFieldKeys().add("entrysettleorg");
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("payentry");
        e.getFieldKeys().add("billentry");
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("billentrychangetype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PurContractBlockedValidator());
        e.addValidator((AbstractValidator)new ContractSuitOrgValidator());
        e.addValidator((AbstractValidator)new ContractSubmitValidator());
        e.addValidator((AbstractValidator)new PurContractInvoiceBizTypeValidator());
        e.addValidator((AbstractValidator)new ContractSettleOrgValidator());
        e.addValidator((AbstractValidator)new PurContractSouceControlValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills;
        super.beginOperationTransaction(e);
        for (DynamicObject bill : bills = e.getDataEntities()) {
            DynamicObject supplier = bill.getDynamicObject("supplier");
            DynamicObject providerSupplier = bill.getDynamicObject("providersupplier");
            DynamicObject invoiceSupplier = bill.getDynamicObject("invoicesupplier");
            DynamicObject receiveSupplier = bill.getDynamicObject("receivesupplier");
            DynamicObject invoiceBizType = bill.getDynamicObject("invoicebiztype");
            if (providerSupplier == null) {
                bill.set("providersupplier", (Object)supplier);
                bill.set("providerlinkman", (Object)SupplierHelper.getLinkmanObject((DynamicObject)supplier));
                bill.set("provideraddress", (Object)SupplierHelper.getAddress((DynamicObject)supplier));
            }
            if (invoiceSupplier == null) {
                bill.set("invoicesupplier", (Object)supplier);
            }
            if (receiveSupplier == null) {
                bill.set("receivesupplier", (Object)supplier);
            }
            if (invoiceBizType != null || supplier == null) continue;
            DynamicObject invoicecategory = supplier.getDynamicObject("invoicecategory");
            Long invoicecategoryId = 0L;
            if (invoicecategory != null) {
                invoicecategoryId = (Long)invoicecategory.getPkValue();
            }
            if ((invoiceBizType = InvoiceBiztypeHelper.getInvoiceBizType((Long)invoicecategoryId, (String)this.billEntityType.getAppId())) == null) continue;
            bill.set("invoicebiztype", (Object)invoiceBizType);
        }
    }
}

