/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.dataupdate;

import java.util.ArrayList;
import java.util.Date;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class TemplateAttachmentDataUpdateOP
extends AbstractOperationServicePlugIn {
    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] templates = BusinessDataServiceHelper.load((String)"conm_template", (String)"id ,url , attachmententry.version , attachmententry.modifydate , attachmententry.filename , attachmententry.filemodifier, attachmententry.id ,attachmententry.fbasedataid  ,attachmententry.attachmentfile , attachmententry.rowenablestatus ,attachmententry.entrynum", (QFilter[])QFilter.isNotNull((String)"url").toArray());
        ArrayList<DynamicObject> attachments = new ArrayList<DynamicObject>();
        for (DynamicObject template : templates) {
            String url = template.getString("url");
            if (StringUtils.isEmpty((String)url)) continue;
            String filename = template.getPkValue() + ".doc";
            DynamicObject attachment = this.getBdAttachment(filename, url);
            attachments.add(attachment);
            this.setAttachmentFile(filename, template, attachment);
        }
        Object[] save = SaveServiceHelper.save((DynamicObject[])attachments.toArray(new DynamicObject[attachments.size()]));
        if (save != null) {
            SaveServiceHelper.save((DynamicObject[])templates);
        }
    }

    private DynamicObject getBdAttachment(String fileName, String url) {
        DynamicObject attachment = BusinessDataServiceHelper.newDynamicObject((String)"bd_attachment");
        long bd_attachment1 = DB.genLongId((String)"bd_attachment");
        attachment.set("id", (Object)bd_attachment1);
        attachment.set("name", (Object)fileName);
        attachment.set("uid", (Object)bd_attachment1);
        attachment.set("url", (Object)url);
        attachment.set("type", (Object)(fileName != null ? fileName.substring(fileName.lastIndexOf(46) + 1) : ""));
        attachment.set("creator", (Object)RequestContext.get().getUserId());
        attachment.set("createtime", (Object)new Date());
        attachment.set("tempfile", (Object)"1");
        attachment.set("number", (Object)UUID.randomUUID().toString());
        attachment.set("status", (Object)"B");
        attachment.set("size", (Object)33792);
        return attachment;
    }

    private void setAttachmentFile(String filename, DynamicObject template, DynamicObject attachment) {
        DynamicObjectCollection attachmententry = template.getDynamicObjectCollection("attachmententry");
        DynamicObject entry = attachmententry.addNew();
        entry.set("version", (Object)1);
        entry.set("modifydate", (Object)new Date());
        entry.set("filename", (Object)filename);
        entry.set("filemodifier", (Object)RequestContext.get().getUserId());
        String entryid = String.valueOf(DB.genLongId((String)"conm_template.attachmententry"));
        entry.set("id", (Object)entryid);
        DynamicObjectCollection attachmentfield1 = entry.getDynamicObjectCollection("attachmentfile");
        DynamicObject aNew = attachmentfield1.addNew();
        aNew.set("fbasedataid", (Object)attachment);
        entry.set("attachmentfile", (Object)attachmentfield1);
        entry.set("rowenablestatus", (Object)Boolean.TRUE);
        entry.set("entrynum", (Object)template.getString("number"));
    }
}

