/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.task;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.earlywarn.EarlyWarnContext;
import kd.bos.entity.earlywarn.warn.plugin.IEarlyWarnDataSource;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.tree.TreeNode;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ContractEarlyWarnTask
implements IEarlyWarnDataSource {
    private static final String warnObjEntityNumber = "conm_earlywarnobject";

    public List<QFilter> buildFilter(String s, FilterCondition filterCondition, EarlyWarnContext earlyWarnContext) {
        FilterBuilder fb = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)warnObjEntityNumber), filterCondition);
        fb.buildFilter();
        return fb.getQFilters();
    }

    public DynamicObjectCollection getData(String s, List<QFilter> list, EarlyWarnContext earlyWarnContext) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)warnObjEntityNumber);
        DynamicObjectCollection collection = new DynamicObjectCollection((DynamicObjectType)mainEntityType, null, new ArrayList(16));
        DataSet purContract = this.queryData("conm_purcontract", list);
        this.addToEarlyWarnObjs(purContract, collection);
        DataSet salContract = this.queryData("conm_salcontract", list);
        this.addToEarlyWarnObjs(salContract, collection);
        return collection;
    }

    private DataSet queryData(String entity, List<QFilter> filters) {
        String selectFields = "billno,billname,billstatus,cancelstatus,validstatus,terminatestatus,changestatus,closestatus,biztimebegin,biztimeend,creator";
        return QueryServiceHelper.queryDataSet((String)"queryPurContract", (String)entity, (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]), null).distinct();
    }

    private void addToEarlyWarnObjs(DataSet dataSet, DynamicObjectCollection collection) {
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            DynamicObject data = collection.addNew();
            for (int i = 0; i < fieldNames.length; ++i) {
                String fieldName = fieldNames[i];
                Object value = row.get(fieldName);
                data.set(fieldName, value);
            }
        }
    }

    public List<Map<String, Object>> getCommonFilterColumns(String entity) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        EntityTypeUtil helper = new EntityTypeUtil();
        List filterColumns = helper.getFilterColumns((IDataEntityType)mainEntityType);
        return filterColumns;
    }

    public TreeNode getSingleMessageFieldTree(String entity) {
        PropTreeBuildOption option = new PropTreeBuildOption();
        option.setOnlyPhysicsField(false);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entity);
        TreeNode root = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainEntityType, (PropTreeBuildOption)option);
        root.setIsOpened(true);
        return root;
    }

    public TreeNode getMergeMessageFieldTree(String s) {
        return this.getSingleMessageFieldTree(s);
    }
}

