/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.opplugin.tpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class ContractTplSubmitOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("biztimebegin");
        e.getFieldKeys().add("biztimebegin");
        e.getFieldKeys().add("biztimeend");
        e.getFieldKeys().add("totalallamount");
        e.getFieldKeys().add("iselecsignature");
        e.getFieldKeys().add("payamount");
        e.getFieldKeys().add("lastupdateuser");
        e.getFieldKeys().add("lastupdatetime");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] bills = e.getDataEntities();
        DynamicObject user = UserServiceHelper.getCurrentUser((String)"id");
        Date now = TimeServiceHelper.now();
        for (DynamicObject bill : bills) {
            bill.set("lastupdateuser", (Object)user);
            bill.set("lastupdatetime", (Object)now);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        ArrayList<String> ids = new ArrayList<String>();
        for (DynamicObject bill : e.getDataEntities()) {
            Long id;
            String entityName = bill.getDataEntityType().getName();
            if ("conm_xpurcontract".equals(entityName) || "conm_xsalcontract".equals(entityName) || !bill.getBoolean("iselecsignature") || (id = (Long)bill.getPkValue()) == null || 0L == id) continue;
            ids.add(String.valueOf(id));
        }
        if (ids.isEmpty()) {
            return;
        }
        QFilter finterid = new QFilter("finterid", "in", (Object)ids.toArray());
        QFilter fattachmentpanel = new QFilter("fattachmentpanel", "=", (Object)"signattachment");
        DynamicObject[] attachments = BusinessDataServiceHelper.load((String)"bos_attachment", (String)"finterid,fextname", (QFilter[])new QFilter[]{finterid.and(fattachmentpanel)});
        List billIds = Arrays.stream(attachments).map(a -> a.getLong("finterid")).collect(Collectors.toList());
        ArrayList<String> extnames = new ArrayList<String>();
        extnames.add("doc");
        extnames.add("docx");
        extnames.add("pdf");
        for (DynamicObject bill : e.getDataEntities()) {
            String billno = bill.getString("billno");
            if (!bill.getBoolean("iselecsignature")) {
                return;
            }
            boolean contains = billIds.contains((Long)bill.getPkValue());
            if (!contains) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u7b7e\u7ae0\u9644\u4ef6\u3002", (String)"ContractTplSubmitOp_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]));
            }
            int j = 0;
            for (int i = 0; i < attachments.length; ++i) {
                if (!bill.getPkValue().equals(attachments[i].getLong("finterid"))) continue;
                if (++j > 1) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7535\u5b50\u7b7e\u7ae0\u4ec5\u652f\u6301\u4e0a\u4f20\u5355\u4e2a\u6587\u4ef6\u3002", (String)"ContractTplSubmitOp_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), billno));
                }
                if (extnames.contains(attachments[i].getString("fextname"))) continue;
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7535\u5b50\u7b7e\u7ae0\u4ec5\u652f\u6301\u9644\u4ef6\u4e3adoc\u3001docx\u3001pdf\u6587\u4ef6\u7c7b\u578b\u3002", (String)"ContractTplSubmitOp_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), billno));
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
    }
}

