/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class ReviewApplyValidator
extends AbstractValidator {
    public void validate() {
        switch (this.getOperateKey()) {
            case "save": 
            case "submit": {
                HashSet<Long> bills = new HashSet<Long>();
                HashSet<Long> pks = new HashSet<Long>();
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    if (bill.getLong("srcbillid") == 0L) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u9700\u8981\u8bc4\u5ba1\u7684\u5355\u636e\u3002", (String)"ReviewApplyValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                    }
                    long srcbillid = bill.getLong("srcbillid");
                    long pkValue = (Long)bill.getPkValue();
                    if (srcbillid != 0L) {
                        bills.add(srcbillid);
                    }
                    pks.add(pkValue);
                }
                QFilter id = new QFilter("srcbillid", "in", bills);
                QFilter pk = new QFilter("id", "not in", pks);
                QFilter billstatus = new QFilter("billstatus", "not in", (Object)new String[]{"D"});
                QFilter cancelStatus = new QFilter("cancelstatus", "!=", (Object)"B");
                DynamicObjectCollection query = QueryServiceHelper.query((String)"conm_reviewapply", (String)"id,srcbillid", (QFilter[])new QFilter[]{id.and(billstatus.and(cancelStatus)).and(pk)});
                bills.clear();
                query.forEach(q -> bills.add(q.getLong("srcbillid")));
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    long srcbillid = bill.getLong("srcbillid");
                    if (!bills.contains(srcbillid)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u5408\u540c\u5df2\u5b58\u5728\u8bc4\u5ba1\u7533\u8bf7\u5355\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u8d77\u7533\u8bf7\u3002", (String)"ReviewApplyValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                }
                break;
            }
            case "bizcancel": {
                HashMap<String, Set> srcBills = new HashMap<String, Set>();
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    long srcBillId = bill.getLong("srcbillid");
                    String srcEntity = bill.getString("srcbillentity");
                    if (!StringUtils.isNotEmpty((String)srcEntity)) continue;
                    Set srcBillIds = srcBills.computeIfAbsent(srcEntity, a -> new HashSet());
                    srcBillIds.add(srcBillId);
                }
                HashMap srcBillStatusMap = new HashMap();
                for (Map.Entry entry : srcBills.entrySet()) {
                    String entity = (String)entry.getKey();
                    Set ids = (Set)entry.getValue();
                    if (ids == null || ids.size() <= 0) continue;
                    DynamicObjectCollection datas = QueryServiceHelper.query((String)entity, (String)"id,signstatus,validstatus", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)ids)});
                    for (DynamicObject srcBill : datas) {
                        String signstatus = srcBill.getString("signstatus");
                        String validstatus = srcBill.getString("validstatus");
                        HashMap<String, String> statusMap = new HashMap<String, String>();
                        statusMap.put("signstatus", signstatus);
                        statusMap.put("validstatus", validstatus);
                        srcBillStatusMap.put(srcBill.getLong("id"), statusMap);
                    }
                }
                for (ExtendedDataEntity data : this.dataEntities) {
                    Map statusMap;
                    DynamicObject bill = data.getDataEntity();
                    String cancelstatus = bill.getString("cancelstatus");
                    if ("B".equals(cancelstatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u8bc4\u5ba1\u7533\u8bf7\u5355\u5df2\u4f5c\u5e9f\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u64cd\u4f5c\u3002", (String)"ReviewApplyValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                        continue;
                    }
                    String billStatus = bill.getString("billstatus");
                    if (!"C".equals(billStatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u201c\u5df2\u901a\u8fc7\u201d\u7684\u5355\u636e\uff0c\u624d\u53ef\u8fdb\u884c\u4f5c\u5e9f\u64cd\u4f5c\u3002", (String)"ReviewApplyValidator_5", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                        continue;
                    }
                    Long srcBillId = bill.getLong("srcbillid");
                    if (srcBillId == null || srcBillId == 0L || (statusMap = (Map)srcBillStatusMap.get(srcBillId)) == null) continue;
                    String signstatus = (String)statusMap.get("signstatus");
                    if (!"A".equals(signstatus) && !"C".equals(signstatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u7b7e\u7ae0\u72b6\u6001\u4e3a\u201c\u672a\u7b7e\u7ae0\u201d\u65f6\uff0c\u624d\u5141\u8bb8\u8fdb\u884c\u8bc4\u5ba1\u4f5c\u5e9f\u3002", (String)"ReviewApplyValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                        continue;
                    }
                    String validstatus = (String)statusMap.get("validstatus");
                    if ("A".equals(validstatus)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u751f\u6548\u72b6\u6001\u4e3a\u201c\u672a\u751f\u6548\u201d\u65f6\uff0c\u624d\u5141\u8bb8\u8fdb\u884c\u8bc4\u5ba1\u4f5c\u5e9f\u3002", (String)"ReviewApplyValidator_4", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                }
                break;
            }
        }
    }
}

