/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.scmc.conm.enums.ChangeTypeEnum;

public class ContractSettleOrgValidator
extends AbstractValidator {
    public Set<String> preparePropertys() {
        Set preparePropertys = super.preparePropertys();
        preparePropertys.add("billentry");
        preparePropertys.add("entrysettleorg");
        preparePropertys.add("payentry");
        preparePropertys.add("isprepay");
        preparePropertys.add("payentrychangetype");
        preparePropertys.add("billentrychangetype");
        return preparePropertys;
    }

    public void validate() {
        block0: for (ExtendedDataEntity data : this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            boolean isPrePay = false;
            DynamicObjectCollection payEntries = bill.getDynamicObjectCollection("payentry");
            if (payEntries != null && payEntries.size() > 0) {
                for (int i = 0; i < payEntries.size(); ++i) {
                    DynamicObject entry = (DynamicObject)payEntries.get(i);
                    if (!ChangeTypeEnum.CANCEL.getValue().equals(entry.getString("payentrychangetype")) && (isPrePay = entry.getBoolean("isprepay"))) break;
                }
            }
            if (!isPrePay) continue;
            DynamicObjectCollection materialEntries = bill.getDynamicObjectCollection("billentry");
            DynamicObject cachedSettleOrg = null;
            if (materialEntries == null || materialEntries.size() <= 1) continue;
            for (int i = 0; i < materialEntries.size(); ++i) {
                DynamicObject entry = (DynamicObject)materialEntries.get(i);
                if (ChangeTypeEnum.CANCEL.getValue().equals(entry.getString("billentrychangetype"))) continue;
                DynamicObject settleOrg = entry.getDynamicObject("entrysettleorg");
                if (cachedSettleOrg == null) {
                    cachedSettleOrg = settleOrg;
                    continue;
                }
                if (settleOrg == null || cachedSettleOrg.getPkValue().equals(settleOrg.getPkValue())) continue;
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4ed8\u6b3e\u8ba1\u5212\u5b58\u5728\u9884\u4ed8\u65f6\uff0c\u7269\u6599\u660e\u7ec6\u7684\u7ed3\u7b97\u7ec4\u7ec7\u5fc5\u987b\u76f8\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ContractSettleOrgValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]));
                continue block0;
            }
        }
    }
}

