/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.contract;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.conm.enums.ChangeTypeEnum;

public class PurContractBlockedValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extend : this.dataEntities) {
            Boolean purchasehold;
            DynamicObject supplier;
            DynamicObject entity = extend.getDataEntity();
            String entityName = entity.getDataEntityType().getName();
            if (!"conm_purcontract".equals(entityName) || (supplier = entity.getDynamicObject("supplier")) == null || !(purchasehold = Boolean.valueOf(supplier.getBoolean("purchasehold"))).booleanValue()) continue;
            String tip = String.format(ResManager.loadKDString((String)"\u5408\u540c\u7f16\u53f7\u201c%1$s\u201d\u7684\u8ba2\u8d27\u4f9b\u5e94\u5546\u201c%2$s\u201d\u4e3a\u201c\u91c7\u8d2d\u51bb\u7ed3\u201d\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u63d0\u4ea4\u3002", (String)"PurContractBlockedValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), entity.getString("billno"), supplier.getString("number"));
            this.addMessage(extend, tip, ErrorLevel.Error);
        }
        for (ExtendedDataEntity extend : this.dataEntities) {
            DynamicObjectCollection billentrys;
            DynamicObject type;
            DynamicObject bill = extend.getDataEntity();
            if (bill == null || (type = bill.getDynamicObject("type")) == null || !type.getBoolean("costexpense")) continue;
            DynamicObjectCollection payentrys = bill.getDynamicObjectCollection("payentry");
            if (payentrys != null && payentrys.isEmpty()) {
                String tip = String.format(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u4ed8\u6b3e\u8ba1\u5212\u3002", (String)"PurContractBlockedValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]);
                this.addMessage(extend, tip, ErrorLevel.Error);
            }
            if (!"conm_purcontract".equals(this.entityKey) || (billentrys = bill.getDynamicObjectCollection("billentry")) == null || billentrys.isEmpty()) continue;
            DynamicObject billentry = (DynamicObject)billentrys.get(0);
            DynamicObject entrysettleorg = billentry.getDynamicObject("entrysettleorg");
            String entryChange = billentry.getString("billentrychangetype");
            if (entrysettleorg != null || !ChangeTypeEnum.UPDATE.getValue().equals(entryChange)) continue;
            String tip = String.format(ResManager.loadKDString((String)"\u8bf7\u5728\u7269\u6599\u660e\u7ec6\u7b2c1\u884c\u5f55\u5165\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"PurContractBlockedValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), new Object[0]);
            this.addMessage(extend, tip, ErrorLevel.Error);
        }
    }
}

