/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.tpl;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.util.StringUtils;
import kd.scmc.conm.enums.BizChangeStatusEnum;
import kd.scmc.conm.enums.BizCloseStatusEnum;
import kd.scmc.conm.enums.BizValidStatusEnum;
import kd.scmc.conm.utils.CommonUtils;

public class BizCloseStatusValidator
extends AbstractValidator {
    public void validate() {
        String operateName = this.getOperationName();
        ArrayList<String> MsgStr = new ArrayList<String>(10);
        switch (this.getOperateKey()) {
            case "bizclose": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    String message;
                    DynamicObject bill = data.getDataEntity();
                    String validStatus = bill.getString("validstatus");
                    String changeStatus = bill.getString("changestatus");
                    String closeStatus = bill.getString("closestatus");
                    if (BizChangeStatusEnum.CHANGING.getValue().equals(changeStatus)) {
                        MsgStr.add(ResManager.loadKDString((String)"\u53d8\u66f4\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u53d8\u66f4\u4e2d\u201d", (String)"BizCloseStatusValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]));
                    }
                    if (BizCloseStatusEnum.CLOSE.getValue().equals(closeStatus)) {
                        MsgStr.add(ResManager.loadKDString((String)"\u5173\u95ed\u72b6\u6001\u4e0d\u4e3a\u201c\u5df2\u5173\u95ed\u201d", (String)"BizCloseStatusValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]));
                    }
                    if (BizValidStatusEnum.UNVALID.getValue().equals(validStatus)) {
                        MsgStr.add(ResManager.loadKDString((String)"\u751f\u6548\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u672a\u751f\u6548\u201d", (String)"BizCloseStatusValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]));
                    }
                    if (StringUtils.isNotEmpty((String)(message = CommonUtils.getOpValidateMessage((String)operateName, MsgStr)))) {
                        this.addMessage(data, message, ErrorLevel.Error);
                    }
                    MsgStr.clear();
                }
                break;
            }
        }
    }
}

