/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.validation.tpl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.scmc.conm.enums.BizChangeStatusEnum;
import kd.scmc.conm.enums.BizRowTerminateStatusEnum;
import kd.scmc.conm.enums.BizTerminateStatusEnum;
import kd.scmc.conm.enums.BizValidStatusEnum;

public class BizRowTerminateStatusValidator
extends AbstractValidator {
    public void validate() {
        switch (this.getOperateKey()) {
            case "rowterminate": {
                for (ExtendedDataEntity data : this.dataEntities) {
                    DynamicObject bill = data.getDataEntity();
                    String validStatus = bill.getString("validstatus");
                    String terminateStatus = bill.getString("terminatestatus");
                    String changeStatus = bill.getString("changestatus");
                    String option = this.getOption().getVariableValue("bos_listselectedrowcollection");
                    if (BizValidStatusEnum.UNVALID.getValue().equals(validStatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u751f\u6548\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u672a\u751f\u6548\u201d\u65f6\uff0c\u624d\u80fd\u8fdb\u884c\u201c\u884c\u7ec8\u6b62\u201d\u64cd\u4f5c\u3002", (String)"BizRowTerminateStatusValidator_2", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (BizTerminateStatusEnum.TERMINATE.getValue().equals(terminateStatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u5355\u636e\u7ec8\u6b62\u72b6\u6001\u4e3a\u201c\u672a\u7ec8\u6b62\u201d\u65f6\uff0c\u624d\u80fd\u8fdb\u884c\u201c\u884c\u7ec8\u6b62\u201d\u64cd\u4f5c\u3002", (String)"BizRowTerminateStatusValidator_4", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (BizChangeStatusEnum.CHANGING.getValue().equals(changeStatus)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u53d8\u66f4\u72b6\u6001\u4e0d\u7b49\u4e8e\u201c\u53d8\u66f4\u4e2d\u201d\u65f6\uff0c\u624d\u80fd\u8fdb\u884c\u201c\u884c\u7ec8\u6b62\u201d\u64cd\u4f5c\u3002", (String)"BizRowTerminateStatusValidator_1", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    if (StringUtils.isEmpty((CharSequence)option)) {
                        this.addMessage(data, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u5904\u7406\u7684\u6570\u636e\u884c\u3002", (String)"BizRowTerminateStatusValidator_0", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Warning);
                        continue;
                    }
                    ListSelectedRowCollection selRows = (ListSelectedRowCollection)SerializationUtils.fromJsonString((String)option, ListSelectedRowCollection.class);
                    ArrayList<Object> selRowList = new ArrayList<Object>(Arrays.asList(selRows.getEntryPrimaryKeyValues()));
                    if (!this.isCloseAllRows(bill, selRowList)) continue;
                    this.addMessage(data, ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u884c\u7ec8\u6b62\u72b6\u6001\u4e3a\u201c\u6b63\u5e38\u201d\u7684\u6570\u636e\u884c\u3002", (String)"BizRowTerminateStatusValidator_3", (String)"scmc-conm-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                }
                break;
            }
        }
    }

    private boolean isCloseAllRows(DynamicObject bill, List<Object> selRows) {
        int closedFlag = 0;
        int selRowFlag = 0;
        DynamicObjectCollection entry = bill.getDynamicObjectCollection("billentry");
        for (DynamicObject row : entry) {
            if (!selRows.contains(row.getPkValue())) continue;
            String rowCloseStatus = row.getString("rowterminatestatus");
            if (BizRowTerminateStatusEnum.TERMINATE.getValue().equals(rowCloseStatus)) {
                ++closedFlag;
            }
            if (++selRowFlag != selRows.size()) continue;
            break;
        }
        return closedFlag == selRows.size();
    }
}

