/*
 * Decompiled with CFR 0.152.
 */
package kd.scmc.conm.formplugin.basedata;

import java.util.EventObject;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.scmc.conm.utils.CommonUtils;

public class ContpartiesPlugin
extends AbstractBillPlugIn {
    private static final String OPPARAM_AFTERCONFIRM = "afterconfirm";
    private static final String BOS_ORG_PATTERN = "bos_org_pattern";
    private static final String PATTERNTYPE = "patterntype";
    private static final String ORGPATTERN = "orgpattern";

    public void afterCreateNewData(EventObject e) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        if (org != null) {
            this.BizOrgChanged(org);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        if (!CommonUtils.isRealChanged((ChangeData)e.getChangeSet()[0])) {
            return;
        }
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (propName) {
            case "org": {
                this.BizOrgChanged((DynamicObject)newValue);
                break;
            }
            case "frepresentativeorg": {
                this.frepresentativeOrgChanged((DynamicObject)newValue);
                break;
            }
        }
    }

    private void BizOrgChanged(DynamicObject BizOrg) {
        QFilter patterntypeFilter = new QFilter(PATTERNTYPE, "in", (Object)new String[]{"1", "2"});
        Map ids = BusinessDataServiceHelper.loadFromCache((String)BOS_ORG_PATTERN, (String)"id", (QFilter[])new QFilter[]{patterntypeFilter});
        QFilter orgpatternFilter = new QFilter(ORGPATTERN, "in", (Object)ids.keySet().toArray());
        Map FOrgIds = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{orgpatternFilter});
        if (FOrgIds.containsKey(BizOrg.getPkValue())) {
            this.getModel().setValue("frepresentativeorg", (Object)BizOrg);
            this.frepresentativeOrgChanged(BizOrg);
        }
    }

    private void frepresentativeOrgChanged(DynamicObject org) {
        IDataModel model = this.getModel();
        if (org == null) {
            model.setValue("faddress", (Object)"");
            model.setValue("phone", (Object)"");
            model.setValue("frepresentative", (Object)"");
            model.setValue("contacts", (Object)"");
            return;
        }
        model.setValue("faddress", (Object)org.getString("faddress"));
        model.setValue("phone", (Object)org.getString("phone"));
        model.setValue("frepresentative", (Object)org.getString("frepresentative"));
        model.setValue("name", (Object)org.getString("name"));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (StringUtils.equals((CharSequence)"save", (CharSequence)operate.getOperateKey())) {
            boolean isDefault = (Boolean)this.getModel().getValue("isdefault");
            if (!isDefault) {
                return;
            }
            RefObject afterConfirm = new RefObject();
            if (!operate.getOption().tryGetVariableValue(OPPARAM_AFTERCONFIRM, afterConfirm)) {
                QFilter isDefalut;
                DynamicObject dataEntity = this.getModel().getDataEntity();
                Object createOrgValue = dataEntity.getDynamicObject("org").getPkValue();
                QFilter createOrg = new QFilter("org", "=", createOrgValue);
                DynamicObject load = BusinessDataServiceHelper.loadSingle((String)"conm_contparties", (String)"id", (QFilter[])new QFilter[]{createOrg.and(isDefalut = new QFilter("isdefault", "=", (Object)"1"))});
                if (load == null || load.getPkValue().toString().equals(dataEntity.getPkValue().toString())) {
                    return;
                }
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operate.getOperateKey(), (IFormPlugin)this);
                String confirmTip = ResManager.loadKDString((String)"\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u5df2\u5b58\u5728\u9ed8\u8ba4\u5408\u540c\u4e3b\u4f53\uff0c\u662f\u5426\u9700\u8981\u66ff\u6362\uff1f", (String)"ContpartiesPlugin_0", (String)"scmc-conm-formplugin", (Object[])new Object[0]);
                this.getView().showConfirm(confirmTip, MessageBoxOptions.YesNo, ConfirmTypes.Default, confirmCallBacks);
                args.setCancel(true);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (StringUtils.equals((CharSequence)"save", (CharSequence)messageBoxClosedEvent.getCallBackId())) {
            if (messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
                OperateOption operateOption = OperateOption.create();
                operateOption.setVariableValue(OPPARAM_AFTERCONFIRM, "true");
                this.getView().invokeOperation(messageBoxClosedEvent.getCallBackId(), operateOption);
            } else {
                this.getModel().setValue("isdefault", (Object)Boolean.FALSE);
            }
        }
    }
}

